/* wknsuche.cpp
 *
 * Andreas Wst
 *
 */

#include "wknsuche.moc"

WKNSuche::WKNSuche ( QWidget *parent, const char *name )
                : QDialog ( parent, name, TRUE )
{
  setCaption ("Look for WKN / Company");

  bg = new QButtonGroup( this, "ButtonGroup_1" );
  bg->setGeometry( 10, 10, 310, 250 );
  bg->setFrameStyle( 49 );
  bg->setAlignment( 1 );
  bg->lower();

  le = new QLineEdit(bg, "LineEdit_1" );
  le->setGeometry( 70, 210, 60, 20 );
  le->setMaxLength( 7 );
  connect (le, SIGNAL (textChanged (const char *)), 
           SLOT (sucheString (const char *)));

  le2 = new QLineEdit (bg, "LineEdit_2");
  le2->setGeometry (210, 210, 90, 20);
  le2->setMaxLength (20);
  connect (le2, SIGNAL (textChanged (const char *)),
           SLOT (sucheString (const char *)));



  QLabel *l = new QLabel("WKN :", bg, "Label_1" );
  l->setGeometry( 10, 210, 40, 20 );
  l->setAlignment( 290 );

  l = new QLabel ("Name : ", bg, "Label_2");
  l->setGeometry (140, 210, 50, 20);
  l->setAlignment (290);


  lb = new QListBox(bg, "ListBox_1" );
  lb->setGeometry( 10, 10, 290, 190 );
  lb->setFrameStyle( 51 );
  lb->setLineWidth( 2 );
  lb->setAutoBottomScrollBar (FALSE);

  ok = new QPushButton ("OK", this, "PushButton1" );
  ok->setGeometry( 250, 270, 70, 30 );
  connect (ok, SIGNAL (clicked ()), SLOT (accept ()));

  clear = new QPushButton ("Clear", this, "PushButton2");
  clear->setGeometry (20, 270, 80, 30);
  connect (clear, SIGNAL (clicked ()), SLOT (clearLineEdits ()));

  resize( 330, 310 );

  // pfad fest auf l.list setzen   
  pfad = getenv ("KDEDIR");
  pfad += "/share/apps/kstocks/l.list";

  // alle Eintrg aus l.list einlesen und in eintraege - Array ablegen
  FILE *in;
  char st [80];
  if ((in = fopen (pfad.data (), "rt")) == NULL)
  {
    fprintf (stderr, "Error opening l.list - file !");
  }
  else
  {   
    int i = 0;
    while (fgets (st, 78, in) != NULL)
    {
      QString dummy (st);
      // WKN holen 
      eintraege [i] = dummy.left (7) + " ";
      // Company Name holen
      eintraege [i] += dummy.mid (37, 30);
      // alle Leerzeichen am Ende des Strings entfernen
      while (eintraege [i].find (QRegExp (" $")) != -1)
        eintraege [i].replace (QRegExp (" $"), 0);
      // Markt holen und ranhngen   
      bool ok;
      QString marktnummer = dummy.mid (8, 1);
      int marktnr = marktnummer.toInt (&ok);
      if (ok == false)
      {
        fprintf (stderr, "Error : Wrong market number !");
      }
      else
      {
        eintraege [i] += markt [marktnr];
      }
      // Strings in Listbox eintragen
      lb->insertItem (eintraege [i].data ());        
      i++;
    }
    fclose (in);
    anzeintraege = i;
  }
}

WKNSuche::~WKNSuche()
{      
}

void WKNSuche::clearLineEdits ()
{
  le->clear ();
  le2->clear ();
}

void WKNSuche::sucheString (const char *)
{
  debug ("sucheString - WKNSuche");
  QString eintrag;
  QString regexp;

  // bergabeparameter kann vergessen werden,
  // le, le2 werden hier ausgelesen
  QString swkn = le->text ();
  QString sname = le2->text ();  
  // String komplett in Grobuchstaben umwandeln
  sname = sname.upper ();

  if (lb->count () != 0)
  {
    lb->clear ();
  }

  for (int i = 0; i < anzeintraege; i++)
  {
    eintrag = eintraege [i].upper ();

    // Eintrag in wkn und name vorhanden
    if ((sname.length () != 0) && (swkn.length () != 0))
    {
      regexp = "^" + swkn;
      if (eintrag.find (QRegExp (regexp)) != -1)
      {
        // wkn gefunden, -> name noch suchen
        regexp = "^........" + sname;
        if (eintrag.find (QRegExp (regexp)) != -1)
        {
          // auch name gefunden ! -> in listbox eintragen
          lb->insertItem (eintraege [i].data ());
        }
      }
    }
       
    // nur name vorhanden
    if ((sname.length () != 0) && (swkn.length () == 0))
    {
      regexp = "^........" + sname;
      if (eintrag.find (QRegExp (regexp)) != -1)
        lb->insertItem (eintraege [i].data ());
    }

    // nur wkn vorhanden  
    if ((sname.length () == 0) && (swkn.length () != 0))
    {
      regexp = "^" + swkn;
      if (eintrag.find (QRegExp (regexp)) != -1)
        lb->insertItem (eintraege [i].data ());
    }
     
    if ((sname.length () == 0) && (swkn.length () == 0))
    {
      lb->insertItem (eintraege [i].data ());
    }

  }
}

const char WKNSuche::markt [] [20] = {" (DAX)", 
                                      " (EURO-STOXX 50)", 
                                      " (M-DAX)", 
                                      " (Neuer Markt)", 
                                      " (Ausland)", 
                                      " (Dow Jones)",
                                      " (EASDAQ)" };
