
#include "ksiag_toolbar.h"
#include "siagcallbacks.h"
#include <stdio.h>

extern "C" {
#include "../siag/calc.h"
}

void KSiagToolBarReceiver::newFile()
{
    execute("(new-buffer)");
}

void KSiagToolBarReceiver::open()
{
    execute("(load-buffer)");
}

void KSiagToolBarReceiver::save()
{
    execute("(save-buffer-as)");
}

void KSiagToolBarReceiver::preview()
{
    execute("(preview)");
}

void KSiagToolBarReceiver::print()
{
    execute("(print)");
}

void KSiagToolBarReceiver::plot()
{
    execute("(plot \"lines\")");
}

void KSiagToolBarReceiver::sigma()
{
    execute("(block-sum)");
}

void KSiagToolBarReceiver::info()
{
    execute("(help-contents)");
}

void KSiagToolBarReceiver::borders()
{
    execute("(block-borders 1)");
}

void KSiagToolBarReceiver::grid()
{
    execute("(block-borders 2)");
}

void KSiagToolBarReceiver::underline()
{
    execute("(block-borders 3)");
    emit update();
}

void KSiagToolBarReceiver::none()
{
    execute("(block-borders 0)");
    emit update();
}

void KSiagToolBarReceiver::fwizard()
{
    error_box("The Quick Kalc wizard is not\nyet implemented in Beta1.");
}

void KSiagToolBarReceiver::cut()
{
    execute ("(cut-block)");
}

void KSiagToolBarReceiver::copy()
{
    execute ("(copy-block)");
}

void KSiagToolBarReceiver::paste()
{
    execute ("(paste-block)");

}

void KSiagToolBarReceiver::bold()
{
    execute("(toggle-fontflag BOLD)");
    emit update();
}

void KSiagToolBarReceiver::italic()
{
    execute("(toggle-fontflag ITALIC)");
    emit update();
}

void KSiagToolBarReceiver::leftJustify()
{
    execute("(change-font HADJ_LEFT HADJ_MASK)");
    emit update();
}

void KSiagToolBarReceiver::centerJustify()
{
    execute("(change-font HADJ_CENTER HADJ_MASK)");
    emit update();
}

void KSiagToolBarReceiver::rightJustify()
{
    execute("(change-font HADJ_RIGHT HADJ_MASK)");
    emit update();
}

void KSiagToolBarReceiver::fontComboActivated (int i)
{
    switch (i){
    case ID_FONT_HELVETICA:
        execute("(change-font HELVETICA FONT_MASK)");
        break;
    case ID_FONT_COURIER:
        execute("(change-font COURIER FONT_MASK)");
        break;
    case ID_FONT_SCHOOLBOOK:
        execute("(change-font NEW_CENTURY FONT_MASK)");
        break;
    case ID_FONT_TIMES:
        execute("(change-font TIMES FONT_MASK)");
        break;
    }
    emit update();
}

void KSiagToolBarReceiver::sizeComboActivated (int i)
{
    switch (i){
    case ID_SIZE_8:
        execute("(change-font SIZE_8  SIZE_MASK)");
        break;
    case ID_SIZE_10:
        execute("(change-font SIZE_10 SIZE_MASK)");
        break;
    case ID_SIZE_12:
        execute("(change-font SIZE_12 SIZE_MASK)");
        break;
    case ID_SIZE_14:
        execute("(change-font SIZE_14 SIZE_MASK)");
        break;
    case ID_SIZE_18:
        execute("(change-font SIZE_18 SIZE_MASK)");
        break;
    case ID_SIZE_20:
        execute("(change-font SIZE_20 SIZE_MASK)");
        break;
    case ID_SIZE_24:
        execute("(change-font SIZE_24 SIZE_MASK)");
        break;
    case ID_SIZE_30:
        execute("(change-font SIZE_30 SIZE_MASK)");
        break;
    }
    emit update();
}

void KSiagToolBarReceiver::typeComboActivated (int i)
{
   switch (i){
    case ID_TYPE_DEFAULT:
        execute("(change-font FMT_DEFAULT FMT_MASK)");
        break;
    case ID_TYPE_INVISIBLE:
        execute("(change-font FMT_INVISIBLE FMT_MASK)");
        break;
    case ID_TYPE_INTEGER:
        execute("(change-font FMT_INTEGER FMT_MASK)");
        break;
    case ID_TYPE_SCIENTIFIC:
        execute("(change-font FMT_SCIENTIFIC FMT_MASK)");
        break;
    case ID_TYPE_FIXED:
        execute("(change-font FMT_FIXED FMT_MASK)");
        break;
    case ID_TYPE_DATE:
        execute("(change-font FMT_DATE FMT_MASK)");
        break;
    case ID_TYPE_TIME:
        execute("(change-font FMT_TIME FMT_MASK)");
        break;
    case ID_TYPE_TIME_DIFF:
        execute("(change-font FMT_TIMEDIF FMT_MASK)");
        break;
    case ID_TYPE_PERCENT:
        execute("(change-font FMT_PERCENT FMT_MASK)");
        break;
    case ID_TYPE_HEX:
        execute("(change-font FMT_HEX FMT_MASK)");
        break;
    case ID_TYPE_CURRENCY:
        execute("(change-font FMT_CURRENCY FMT_MASK)");
        break;
    case ID_TYPE_USER1:
        execute("(change-font FMT_USER1 FMT_MASK)");
        break;
    case ID_TYPE_USER2:
        execute("(change-font FMT_USER2 FMT_MASK)");
        break;
    case ID_TYPE_USER3:
        execute("(change-font FMT_USER3 FMT_MASK)");
        break;
    case ID_TYPE_USER4:
        execute("(change-font FMT_USER4 FMT_MASK)");
        break;
    case ID_TYPE_USER5:
        execute("(change-font FMT_USER5 FMT_MASK)");
        break;
   }
    emit update();
}

void KSiagToolBarReceiver::colorComboActivated (int i)
{
    switch (i){
    case ID_COLOR_BLACK:
        execute("(change-font COLOR_BLACK COLOR_MASK)");
        break;
    case ID_COLOR_RED:
        execute("(change-font COLOR_RED COLOR_MASK)");
        break;
    case ID_COLOR_GREEN:
        execute("(change-font COLOR_GREEN COLOR_MASK)");
        break;
    case ID_COLOR_BLUE:
        execute("(change-font COLOR_BLUE COLOR_MASK)");
        break;
    case ID_COLOR_YELLOW:
        execute("(change-font COLOR_YELLOW COLOR_MASK)");
        break;
    case ID_COLOR_MAGENTA:
        execute("(change-font COLOR_MAGENTA COLOR_MASK)");
        break;
    case ID_COLOR_CYAN:
        execute("(change-font COLOR_CYAN COLOR_MASK)");
        break;
    case ID_COLOR_WHITE:
        execute("(change-font COLOR_WHITE COLOR_MASK)");
        break;
    }
    emit update();
}

void KSiagToolBarReceiver::lineEntered ()
{
    ;
}

void KSiagToolBarReceiver::lineAccept ()
{
    ;
}

void KSiagToolBarReceiver::lineReject ()
{
    ;
}

