
#include <kapp.h>
#include "ksiag_tablemanager.h"
#include "../common/common.h"

// Since Siag references dynamic menus based on it's name, we keep an array
// of names in the same order as the menu array. Makes lookups easier.
static char menu_names[][10]={"File", "Edit", "Block", "Format", "Data",
    "Plugin", "Window", "Plot", "Tools", "Help", "Shortcuts"};

SiagWindow::~SiagWindow()
{
    buffer *b;
    delete top;

    for(b=bufList.first(); b; b=bufList.next())
        free_buffer(b);
    llpr("freeing window");
    free_window(w);
}

bool SiagWindow::removeBuffer(buffer *b)
{
    if (bufList.find(b) == -1)
        return (0);
    if (bufList.count() == 1){
        llpr("Cannot close last buffer.");
        return (0);
    }
    top->view()->removeBufferTab(b->name);
    free_buffer(b);
    bufList.remove();
    w->buf = bufList.current();
    top->view()->resetBuffer();
    return(1);
}

bool SiagWindow::queryBuffer(buffer *b)
{
    if (bufList.find(b) == -1)
        return (0);
    return (1);
}

KSiagTableManager::KSiagTableManager (QObject *parent, const char *name)
    : QObject(parent, name)
{
    cur = 0;
    int i;
    for (i=0; i <= ID_MENU_SHORTCUTS; ++i)
        menus[i] = new KSiagPopupMenu;
    winList.setAutoDelete(true);
}

KSiagTableManager::~KSiagTableManager()
{
    int i;

    winList.clear();
    for (i=0; i <= ID_MENU_SHORTCUTS; ++i)
        delete menus[i];
}

int KSiagTableManager::menuIndex(const char *name) const
{
    int i;
    for (i=0; i <= ID_MENU_SHORTCUTS; ++i)
        if (cstrcasecmp(menu_names[i], name) == 0)
            return (i);
    return (-1);
}

char* KSiagTableManager::menuName(int index) const
{
    return (menu_names[index]);
}

int KSiagTableManager::addMenuItem (const char *menu, const char *name,
                                const char *function)
{
    SiagWindow *win;
    int idx = menuIndex(menu);
    if (idx != -1){
        KSiagPopupMenu *mnu = menus[idx];
        mnu->addLispFunction(name, function);
        for (win = winList.first(); win; win = winList.next())
            win->topLevel()->menuAt(idx)->addLispFunction(name, function);
        return(1);
    }
    return(0);
}

int KSiagTableManager::addSubmenu (const char *menu, const char *name)
{
    SiagWindow *win;
    int idx = menuIndex(menu);
    if (idx != -1){
        KSiagPopupMenu *mnu = menus[idx];
        mnu->insertSubmenu(name);
        for (win = winList.first(); win; win = winList.next())
            win->topLevel()->menuAt(idx)->insertSubmenu(name);
        return(1);
    }
    return(0);
}

int KSiagTableManager::addSubmenuEntry (const char *menu, const char *submenu,
                                        const char *name, const char *function)
{
    SiagWindow *win;
    KSiagPopupMenu *sub=0, *parent;
    int idx = menuIndex(menu);
    if (idx != -1){
        parent = menus[idx];
        sub = parent->findSubmenu(submenu);
        if (!sub)
            return(0);
        sub->addLispFunction(name, function);
        for (win = winList.first(); win; win = winList.next()){ 
            sub = win->topLevel()->menuAt(idx)->findSubmenu(submenu);
            sub->addLispFunction(name, function);
        }
        return(1);
    }
    return(0);
}

void KSiagTableManager::setActiveWindow (window *w)
{
    SiagWindow *win;
    for (win = winList.first(); win && win->siagWindow() != w;
         win = winList.next())
        ;
    if (win->siagWindow() != w){
        llpr("KSiag: adding unmanaged window.");
        addWindow(w);
        win = winList.current();
    }
    if (!win->queryBuffer(w->buf)){
        win->addBuffer(w->buf);
        win->topLevel()->view()->addBufferTab(w->buf->name);
    }
    w_list = w;
    cur = win;
    //cur->topLevel()->view()->resetBuffer();
    cur->topLevel()->view()->setActiveTab(w->buf->name);
}

void KSiagTableManager::addWindow (window *w)
{
    KSiagTopLevel *top = new KSiagTopLevel(w);
    SiagWindow *sw = new SiagWindow (w, top);
    top->updateMenus(menus);
    QSize s = top->toolBar(1)->sizeHint();
    if (top->width() < s.width()) // Resize if width < longest toolbar...
        top->resize(s.width(), top->height());
    top->show();
    winList.append(sw);
    connect(top, SIGNAL(closeWindow(window *)),
            SLOT(removeWindow(window *)));
    connect(top->view(), SIGNAL(activateBuffer(KSiagTableView *, const char *)),
            SLOT(activateBuffer(KSiagTableView *, const char *)));
    connect(top->view()->table(), SIGNAL(activated(window *)),
            SLOT(setActiveWindow(window *)));
}

void KSiagTableManager::removeWindow (window *w)
{
    SiagWindow *win;
    for (win = winList.first(); win && win->siagWindow() != w;
         win = winList.next())
        ;
    if (win->siagWindow() != w){
        llpr("KSiag error: TableManager removeWindow failed!");
        return;
    }
    winList.remove();
    if (winList.isEmpty())
        KApplication::getKApplication()->quit();
}

void KSiagTableManager::activateBuffer (KSiagTableView *tbl, const char *name)
{
    SiagWindow *win;
    for (win = winList.first(); win && win->topLevel()->view() != tbl;
         win = winList.next())
        ;
    if (win->topLevel()->view() != tbl){
        llpr("KSiag error: TableManager activateBuffer failed!");
        return;
    }
    set_window_buffer(win->siagWindow(),
                      find_buffer_by_name(const_cast <char *>(name)));
    win->topLevel()->view()->resetBuffer();
}
    
bool KSiagTableManager::removeBuffer (buffer *b)
{
    SiagWindow *win;
    for (win = winList.first(); win && (!win->queryBuffer(b));
         win = winList.next())
        ;
    if (!win->queryBuffer(b)){
        llpr("KSiag error: TableManager removeBuffer failed!");
        return (0);
    }
    win->removeBuffer(b);
    return (1);
}

bool KSiagTableManager::addBuffer (window *w, buffer *b)
{
    SiagWindow *win;
    for (win = winList.first(); win && win->siagWindow() != w;
         win = winList.next())
        ;
    if (win->siagWindow() != w){
        llpr("KSiag error: TableManager addBuffer failed!");
        return (0);
    }
    win->addBuffer(b);
    win->topLevel()->view()->addBufferTab(w->buf->name);
    return (1);
}
