#include <stdio.h>

#include "action.h"

Action::Action(long p, long s, long d, const char *sz, long m)
{
  pred=p;
  succ=s;
  dur=d;
  text = new char [::strlen(sz) + 1];
  ::strcpy(text, sz);
  lbt=0L;
  ebt=0L;
  let=0L;
  eet=0L;
  mark=m;
  crit=0;
  iso=1;	/* node is isolated by default */
}

int Action::setText(const char *sz) 
{
	if (sz!=0) {
		delete [] text;
		text = new char[::strlen(sz)+1];
		::strcpy(text,sz);
		return ::strlen(text);
	} else {
		return 0;
	}
}

Action::~Action()
{
  delete [] text;
}

char* Action::print(char* sz, const char c) 
{
  char crt,i;
  if (get_tbt()<=0L) {
     crt='C';
     crit=1; 
  } else {
     crt=' ';
     crit=0;
  }
  if (getIso()) i='I'; else i=' '; 
  sprintf(sz, "%c%c%c%c%4ld%c%4ld%c%10s%c%3ld%c%4ld%c%4ld%c%4ld%c%4ld%c%ld\n",
     crt,c,i,c,pred,c,succ,c,text,c,dur,c,ebt,c,lbt,c,eet,c,let,c,get_tbt());
  return sz;
}

