#ifndef __KPP_NET_H__
#define __KPP_NET_H__

#include <qdialog.h>
#include <qwidget.h>

#define minbary 10
#define minbarx 5
#define yoff 20
#define xoff 40

class QMatrix;
class Action;

class QGanttWidget : public QWidget {
public:
   QGanttWidget (QWidget *, const char *,QMatrix *, long);
   void setPD(long p) {pd=p;}
   void setList(QMatrix *l) {list=l;}
   
   QGanttWidget &operator = (QGanttWidget &w);
protected:
   void DrawNode(int, Action* );
   void DrawAll();
   void DrawCoords()   ;
   virtual void paintEvent(QPaintEvent *); 
private:
   long pd;
   uint sx, sy; /* needed size */
   QMatrix *list;
};

class QGantt : public QDialog
{
public:
   QGantt(QWidget *, const char *,QMatrix *, long);
   ~QGantt();
   
   void setPD(long p) {gantt->setPD(p);}
   void setList(QMatrix *l) {gantt->setList(l);}
protected:
   //virtual void paintEvent(QPaintEvent *); 
private:
   QGanttWidget *gantt;
signals:
public slots:
private slots:
};

#endif
