// -*- C++ -*-
/* International support for LyX


 */
#ifndef _INTL_H
#define _INTL_H

class LyXText;
class Combox;
class TransManager;
class LString;
class KeyboardOptionsDialog;


///
/** The gui part and the non gui part should be split into two different
  classes. Probably should the gui class just have a pointer to the non
  gui class.
  */
class Intl
{
friend class KeyboardOptionsDialog;

public:
	///
	Intl();
	///
	~Intl();
	
	/// show key mapping dialog
	void MenuKeymap(); 
	///
	void KeyMapOn(bool on);
	///
	void KeyMapPrim();
	///
	void KeyMapSec();

	/// turn on/off key mappings, status in keymapon
	void ToggleKeyMap();

	///
	int SetPrimary(LString const &);

	///
	int SetSecondary(LString const &);

	// insert correct stuff into paragraph
	void TranslateAndInsert(char c, LyXText *text);

	/// initialize key mapper
	void InitKeyMapper(bool on);

	/// Get the Translation Manager
	inline TransManager *getTrans();
	///
	bool keymapon;
	///
	char *chsetcode;
private:
	///
	int SelectCharset(char const *code);
	///
	void update();
	///
	bool primarykeymap;
	///
	int curkeymap;
	///
	int otherkeymap;
	
  KeyboardOptionsDialog* keydialog;

	LString& prim_lang;
	///
	LString& sec_lang;
	///
	TransManager *trans;
};

TransManager* Intl::getTrans()
{
	return trans;
}

#endif
