/*
 * $Id: MathDelimiterDialog.C,v 1.6 1998/06/08 21:40:06 kalle Exp $
 */

#include "MathDelimiterDialog.h"

#include <kapp.h>
#include <kiconloader.h>
#include <klocale.h>

#include <qbttngrp.h>
#include <qlabel.h>
#include <qpainter.h>
#include <qpushbt.h>
#include <qradiobt.h>
#include <qlayout.h>

#include "LyXView.h"
#include "commandtags.h"
#include "lyxfunc.h"
#include "symbol_def.h"

MathDelimiterDialog::MathDelimiterDialog( LyXView* view, QWidget * parent=0, 
										  const char * name=0, 
										  WFlags f=0 ) :
  QDialog( parent, name, false, f ),
  _view( view )
{
  QVBoxLayout *toplevelVL = new QVBoxLayout(this, 10);
  
  QButtonGroup* leftrightBG = new QButtonGroup( this );
  
  QHBoxLayout *leftrightHL = new QHBoxLayout( 10);
  toplevelVL->addLayout(leftrightHL, 0);
  leftrightHL->addStretch(1);
  leftrightBG->hide(); // this group is just to group the buttons
  
  leftRB = new QRadioButton( i18n( "Left" ), this);
  leftrightBG->insert(leftRB);
  leftRB->adjustSize();
  leftRB->setMinimumSize(leftRB->size());
  leftRB->setMaximumWidth(leftRB->width() * 3 / 2);
  leftrightHL->addWidget(leftRB, 1, AlignRight);
  leftRB->setChecked( true );
  
  rightRB = new QRadioButton( i18n( "Right" ), this );
  leftrightBG->insert(rightRB);
  rightRB->adjustSize();
  rightRB->setMinimumSize(rightRB->size());
  rightRB->setMaximumWidth(rightRB->width() * 3 / 2);
  leftrightHL->addWidget(rightRB, 1, AlignLeft);
  leftrightHL->addStretch(1);
  loader = kapp->getIconLoader();

  QGridLayout *buttonsGL = new QGridLayout(9, 13, 5);
  toplevelVL->addLayout(buttonsGL, 3);

  int i;
  for (i = 0; i < 13; i++)
    buttonsGL->setColStretch(i, 1);
  for (i = 0; i < 9; i++)
    buttonsGL->setRowStretch(i, 1);

  lparenPB = new QPushButton( this );
  buttonsGL->addWidget(lparenPB, 1, 1);
  lparenPB->setPixmap( loader->loadIcon( "lparen.xbm" ) );
  QObject::connect( lparenPB, SIGNAL( clicked() ), 
					this, SLOT( lparenClicked() ) );

  rparenPB = new QPushButton( this );
  buttonsGL->addWidget(rparenPB, 1, 3);
  rparenPB->setPixmap( loader->loadIcon( "rparen.xbm" ) );
  QObject::connect( rparenPB, SIGNAL( clicked() ), 
					this, SLOT( rparenClicked() ) );

  lceilPB = new QPushButton( this );
  buttonsGL->addWidget(lceilPB, 1, 5);
  lceilPB->setPixmap( loader->loadIcon( "lceil.xbm" ) );
  QObject::connect( lceilPB, SIGNAL( clicked() ), 
					this, SLOT( lceilClicked() ) );

  rceilPB = new QPushButton( this );
  buttonsGL->addWidget(rceilPB, 1, 7);
  rceilPB->setPixmap( loader->loadIcon( "rceil.xbm" ) );
  QObject::connect( rceilPB, SIGNAL( clicked() ), 
					this, SLOT( rceilClicked() ) );

  uparrowPB = new QPushButton( this );
  buttonsGL->addWidget(uparrowPB, 1, 9);
  uparrowPB->setPixmap( loader->loadIcon( "uparrow.xbm" ) );
  QObject::connect( uparrowPB, SIGNAL( clicked() ), 
					this, SLOT( uparrowClicked() ) );

  UparrowPB = new QPushButton( this );
  buttonsGL->addWidget(UparrowPB, 1, 11);
  UparrowPB->setPixmap( loader->loadIcon( "Uparrow.xbm" ) );
  QObject::connect( UparrowPB, SIGNAL( clicked() ), 
					this, SLOT( UparrowClicked() ) );

  lsqbPB = new QPushButton( this );
  buttonsGL->addWidget(lsqbPB, 3, 1);
  lsqbPB->setPixmap( loader->loadIcon( "lsqb.xbm" ) );
  QObject::connect( lsqbPB, SIGNAL( clicked() ), this, SLOT( lsqbClicked() ) );
  
  rsqbPB = new QPushButton( this );
  buttonsGL->addWidget(rsqbPB, 3, 3);
  rsqbPB->setPixmap( loader->loadIcon( "rsqb.xbm" ) );
  QObject::connect( rsqbPB, SIGNAL( clicked() ), this, SLOT( rsqbClicked() ) );

  lfloorPB = new QPushButton( this );
  buttonsGL->addWidget(lfloorPB, 3, 5);
  lfloorPB->setPixmap( loader->loadIcon( "lfloor.xbm" ) );
  QObject::connect( lfloorPB, SIGNAL( clicked() ), 
					this, SLOT( lfloorClicked() ) );

  rfloorPB = new QPushButton( this );
  buttonsGL->addWidget(rfloorPB, 3, 7);
  rfloorPB->setPixmap( loader->loadIcon( "rfloor.xbm" ) );
  QObject::connect( rfloorPB, SIGNAL( clicked() ), 
					this, SLOT( rfloorClicked() ) );

  updownarrowPB = new QPushButton( this );
  buttonsGL->addWidget(updownarrowPB, 3, 9);
  updownarrowPB->setPixmap( loader->loadIcon( "updownarrow.xbm" ) );
  QObject::connect( updownarrowPB, SIGNAL( clicked() ), 
					this, SLOT( updownarrowClicked() ) );
  
  UpdownarrowPB = new QPushButton( this );
  buttonsGL->addWidget(UpdownarrowPB, 3, 11);

  UpdownarrowPB->setPixmap( loader->loadIcon( "Updownarrow.xbm" ) );
  QObject::connect( UpdownarrowPB, SIGNAL( clicked() ), 
					this, SLOT( UpdownarrowClicked() ) );
  
  lcubPB = new QPushButton( this );
  buttonsGL->addWidget(lcubPB, 5, 1);
  lcubPB->setPixmap( loader->loadIcon( "lcub.xbm" ) );
  QObject::connect( lcubPB, SIGNAL( clicked() ), this, SLOT( lcubClicked() ) );

  rcubPB = new QPushButton( this );
  buttonsGL->addWidget(rcubPB, 5, 3);
  rcubPB->setPixmap( loader->loadIcon( "rcub.xbm" ) );
  QObject::connect( rcubPB, SIGNAL( clicked() ), this, SLOT( rcubClicked() ) );

  solPB = new QPushButton( this );
  buttonsGL->addWidget(solPB, 5, 5);
  solPB->setPixmap( loader->loadIcon( "sol.xbm" ) );
  QObject::connect( solPB, SIGNAL( clicked() ), this, SLOT( solClicked() ) );

  bsolPB = new QPushButton( this );
  buttonsGL->addWidget(bsolPB, 5, 7);
  bsolPB->setPixmap( loader->loadIcon( "bsol.xbm" ) );
  QObject::connect( bsolPB, SIGNAL( clicked() ), 
					this, SLOT( bsolClicked() ) );

  downarrowPB = new QPushButton( this );
  buttonsGL->addWidget(downarrowPB, 5, 9);
  downarrowPB->setPixmap( loader->loadIcon( "downarrow.xbm" ) );
  QObject::connect( downarrowPB, SIGNAL( clicked() ), 
					this, SLOT( downarrowClicked() ) );

  DownarrowPB = new QPushButton( this );
  buttonsGL->addWidget(DownarrowPB, 5, 11);
  DownarrowPB->setPixmap( loader->loadIcon( "Downarrow.xbm" ) );
  QObject::connect( DownarrowPB, SIGNAL( clicked() ), 
					this, SLOT( DownarrowClicked() ) );

  langlePB = new QPushButton( this );
  buttonsGL->addWidget(langlePB, 7, 1);
  langlePB->setPixmap( loader->loadIcon( "langle.xbm" ) );
  QObject::connect( langlePB, SIGNAL( clicked() ), 
					this, SLOT( langleClicked() ) );

  ranglePB = new QPushButton( this );
  buttonsGL->addWidget(ranglePB, 7, 3);
  ranglePB->setPixmap( loader->loadIcon( "rangle.xbm" ) );
  QObject::connect( ranglePB, SIGNAL( clicked() ), 
					this, SLOT( rangleClicked() ) );

  verbarPB = new QPushButton( this );
  buttonsGL->addWidget(verbarPB, 7, 5);
  verbarPB->setPixmap( loader->loadIcon( "verbar.xbm" ) );
  QObject::connect( verbarPB, SIGNAL( clicked() ), 
					this, SLOT( verbarClicked() ) );

  dverbarPB = new QPushButton( this );
  buttonsGL->addWidget(dverbarPB, 7, 7);
  dverbarPB->setPixmap( loader->loadIcon( "dverbar.xbm" ) );
  QObject::connect( dverbarPB, SIGNAL( clicked() ), 
					this, SLOT( dverbarClicked() ) );

  blankPB = new QPushButton( this );
  buttonsGL->addWidget(blankPB, 7, 9);
  blankPB->setPixmap( loader->loadIcon( "blank.xbm" ) );
  QObject::connect( blankPB, SIGNAL( clicked() ), this, 
					SLOT( blankClicked() ) );

  lparenPB->adjustSize();
  QSize size = lparenPB->size();
  lparenPB->setFixedSize(size);
  rparenPB->setFixedSize(size);
  lceilPB->setFixedSize(size);
  rceilPB->setFixedSize(size);
  uparrowPB->setFixedSize(size);
  UparrowPB->setFixedSize(size);
  lsqbPB->setFixedSize(size);
  rsqbPB->setFixedSize(size);
  lfloorPB->setFixedSize(size);
  rfloorPB->setFixedSize(size);
  updownarrowPB->setFixedSize(size);
  UpdownarrowPB->setFixedSize(size);
  lcubPB->setFixedSize(size);
  rcubPB->setFixedSize(size);
  solPB->setFixedSize(size);
  bsolPB->setFixedSize(size);
  downarrowPB->setFixedSize(size);
  DownarrowPB->setFixedSize(size);
  langlePB->setFixedSize(size);
  ranglePB->setFixedSize(size);
  verbarPB->setFixedSize(size);
  dverbarPB->setFixedSize(size);
  blankPB->setFixedSize(size);

  QHBoxLayout* previewLY = new QHBoxLayout();
  toplevelVL->addLayout( previewLY, 0 );

  previewLeftLA = new QLabel( this );
  previewLeftLA->setFixedSize(size.width() + 10, size.height() + 10);

  previewLY->addWidget(previewLeftLA, 0);
  previewLeftLA->setFrameStyle( QFrame::Panel | QFrame::Raised );

  previewRightLA = new QLabel( this );
  previewRightLA->setFixedSize( size.width() + 10, size.height() + 10 );

  previewLY->addWidget( previewRightLA, 0 );
  previewRightLA->setFrameStyle( QFrame::Panel | QFrame::Raised );
  
  QHBoxLayout *buttons2HL = new QHBoxLayout();
  toplevelVL->addLayout(buttons2HL, 0);
  
  QPushButton* okPB = new QPushButton( i18n( "OK" ), this );
  okPB->adjustSize();
  okPB->setFixedHeight(okPB->height());
  okPB->setMinimumWidth(okPB->width());
  buttons2HL->addWidget(okPB);
  okPB->setDefault( true );
  connect( okPB, SIGNAL( clicked() ), SLOT( okClicked() ) );

  QPushButton* applyPB = new QPushButton( i18n( "Apply" ), this );
  applyPB->adjustSize();
  applyPB->setFixedHeight(applyPB->height());
  applyPB->setMinimumWidth(applyPB->width());
  buttons2HL->addWidget(applyPB);
  connect( applyPB, SIGNAL( clicked() ), SLOT( applyClicked() ) );

  QPushButton* cancelPB = new QPushButton( i18n( "Cancel" ), this );
  cancelPB->adjustSize();
  cancelPB->setFixedHeight(cancelPB->height());
  cancelPB->setMinimumWidth(cancelPB->width());
  buttons2HL->addWidget(cancelPB);
  connect( cancelPB, SIGNAL( clicked() ), SLOT( cancelClicked() ) );

  toplevelVL->activate();
  resize(10,10);
  setCaption( i18n( "Delimiter" ) );

  left = '.';
  right = '.';
}


void MathDelimiterDialog::okClicked()
{
  applyClicked();

  hide();
}


void MathDelimiterDialog::cancelClicked()
{
  hide();
}


void MathDelimiterDialog::applyClicked()
{
  char s[80];
  sprintf(s, "%d %d", leftDelimiter(), rightDelimiter()); 
  _view->getLyXFunc()->Dispatch(LFUN_MATH_DELIM, s);
}


void MathDelimiterDialog::lparenClicked()
{
  if( leftRB->isChecked() )
	left = '(';
  else
	right = '(';

  drawSymbol();
}


void MathDelimiterDialog::rparenClicked()
{
  if( leftRB->isChecked() )
	left = ')';
  else
	right = ')';

  drawSymbol();
}


void MathDelimiterDialog::lceilClicked()
{
  if( leftRB->isChecked() )
	left = LM_lceil;
  else
	right = LM_lceil;

  drawSymbol();
}


void MathDelimiterDialog::rceilClicked()
{
  if( leftRB->isChecked() )
	left = LM_rceil;
  else
	right = LM_rceil;

  drawSymbol();
}


void MathDelimiterDialog::uparrowClicked()
{
  if( leftRB->isChecked() )
	left = LM_uparrow;
  else
	right = LM_uparrow;

  drawSymbol();
}


void MathDelimiterDialog::UparrowClicked()
{
  if( leftRB->isChecked() )
	left = LM_Uparrow;
  else
	right = LM_Uparrow;

  drawSymbol();
}


void MathDelimiterDialog::lsqbClicked()
{
  if( leftRB->isChecked() )
	left = '[';
  else
	right = '[';

  drawSymbol();
}


void MathDelimiterDialog::rsqbClicked()
{
  if( leftRB->isChecked() )
	left = ']';
  else
	right = ']';

  drawSymbol();
}


void MathDelimiterDialog::lfloorClicked()
{
  if( leftRB->isChecked() )
	left = LM_lfloor;
  else
	right = LM_lfloor;

  drawSymbol();
}


void MathDelimiterDialog::rfloorClicked()
{
  if( leftRB->isChecked() )
	left = LM_rfloor;
  else
	right = LM_rfloor;

  drawSymbol();
}


void MathDelimiterDialog::updownarrowClicked()
{
  if( leftRB->isChecked() )
	left = LM_updownarrow;
  else
	right = LM_updownarrow;

  drawSymbol();
}


void MathDelimiterDialog::UpdownarrowClicked()
{
  if( leftRB->isChecked() )
	left = LM_Updownarrow;
  else
	right = LM_Updownarrow;

  drawSymbol();
}


void MathDelimiterDialog::lcubClicked()
{
  if( leftRB->isChecked() )
	left = '{';
  else
	right = '{';

  drawSymbol();
}


void MathDelimiterDialog::rcubClicked()
{
  if( leftRB->isChecked() )
	left = '}';
  else
	right = '}';

  drawSymbol();
}


void MathDelimiterDialog::solClicked()
{
  if( leftRB->isChecked() )
	left = '/';
  else
	right = '/';

  drawSymbol();
}


void MathDelimiterDialog::bsolClicked()
{
  if( leftRB->isChecked() )
	left = LM_backslash;
  else
	right = LM_backslash;

  drawSymbol();
}


void MathDelimiterDialog::downarrowClicked()
{
  if( leftRB->isChecked() )
	left = LM_downarrow;
  else
	right = LM_downarrow;

  drawSymbol();
}


void MathDelimiterDialog::DownarrowClicked()
{
  if( leftRB->isChecked() )
	left = LM_Downarrow;
  else
	right = LM_downarrow;

  drawSymbol();
}


void MathDelimiterDialog::langleClicked()
{
  if( leftRB->isChecked() )
	left = LM_langle;
  else
	right = LM_langle;

  drawSymbol();
}


void MathDelimiterDialog::rangleClicked()
{
  if( leftRB->isChecked() )
	left = LM_rangle;
  else
	right = LM_rangle;

  drawSymbol();
}


void MathDelimiterDialog::verbarClicked()
{
  if( leftRB->isChecked() )
	left = '|';
  else
	right = '|';

  drawSymbol();
}


void MathDelimiterDialog::dverbarClicked()
{
  if( leftRB->isChecked() )
	left = LM_Vert;
  else
	right = LM_Vert;

  drawSymbol();
}


void MathDelimiterDialog::blankClicked()
{
  if( leftRB->isChecked() )
	left = '.';
  else
	right = '.';

  drawSymbol();
}


int MathDelimiterDialog::leftDelimiter()
{
  return left;
}


int MathDelimiterDialog::rightDelimiter()
{
  return right;
}


void MathDelimiterDialog::drawSymbol()
{
  switch( left ) {
  case '(':
	previewLeftLA->setPixmap( loader->loadIcon( "lparen.xbm" ) );
	break;
  case ')':
	previewLeftLA->setPixmap( loader->loadIcon( "rparen.xbm" ) );
	break;
  case LM_lceil:
	previewLeftLA->setPixmap( loader->loadIcon( "lceil.xbm" ) );
	break;
  case LM_rceil:
	previewLeftLA->setPixmap( loader->loadIcon( "rceil.xbm" ) );
	break;
  case LM_uparrow:
	previewLeftLA->setPixmap( loader->loadIcon( "uparrow.xbm" ) );
	break;
  case LM_Uparrow:
	previewLeftLA->setPixmap( loader->loadIcon( "Uparrow.xbm" ) );
	break;
  case '[':
	previewLeftLA->setPixmap( loader->loadIcon( "lsqb.xbm" ) );
	break;
  case ']':
	previewLeftLA->setPixmap( loader->loadIcon( "rsqb.xbm" ) );
	break;
  case LM_lfloor:
	previewLeftLA->setPixmap( loader->loadIcon( "lfloor.xbm" ) );
	break;
  case LM_rfloor:
	previewLeftLA->setPixmap( loader->loadIcon( "rfloor.xbm" ) );
	break;
  case LM_updownarrow:
	previewLeftLA->setPixmap( loader->loadIcon( "updownarrow.xbm" ) );
	break;
  case LM_Updownarrow:
	previewLeftLA->setPixmap( loader->loadIcon( "Updownarrow.xbm" ) );
	break;
  case '{':
	previewLeftLA->setPixmap( loader->loadIcon( "lcub.xbm" ) );
	break;
  case '}':
	previewLeftLA->setPixmap( loader->loadIcon( "rcub.xbm" ) );
	break;
  case '/':
	previewLeftLA->setPixmap( loader->loadIcon( "sol.xbm" ) );
	break;
  case LM_backslash:
	previewLeftLA->setPixmap( loader->loadIcon( "bsol.xbm" ) );
	break;
  case LM_downarrow:
	previewLeftLA->setPixmap( loader->loadIcon( "downarrow.xbm" ) );
	break;
  case LM_Downarrow:
	previewLeftLA->setPixmap( loader->loadIcon( "Downarrow.xbm" ) );
	break;
  case LM_langle:
	previewLeftLA->setPixmap( loader->loadIcon( "langle.xbm" ) );
	break;
  case LM_rangle:
	previewLeftLA->setPixmap( loader->loadIcon( "rangle.xbm" ) );
	break;
  case '|':
	previewLeftLA->setPixmap( loader->loadIcon( "verbar.xbm" ) );
	break;
  case LM_Vert:
	previewLeftLA->setPixmap( loader->loadIcon( "dverbar.xbm" ) );
	break;
  case '.':
	previewLeftLA->setPixmap( loader->loadIcon( "blank.xbm" ) );
	break;
  };

  switch( right ) {
  case '(':
	previewRightLA->setPixmap( loader->loadIcon( "lparen.xbm" ) );
	break;
  case ')':
	previewRightLA->setPixmap( loader->loadIcon( "rparen.xbm" ) );
	break;
  case LM_lceil:
	previewRightLA->setPixmap( loader->loadIcon( "lceil.xbm" ) );
	break;
  case LM_rceil:
	previewRightLA->setPixmap( loader->loadIcon( "rceil.xbm" ) );
	break;
  case LM_uparrow:
	previewRightLA->setPixmap( loader->loadIcon( "uparrow.xbm" ) );
	break;
  case LM_Uparrow:
	previewRightLA->setPixmap( loader->loadIcon( "Uparrow.xbm" ) );
	break;
  case '[':
	previewRightLA->setPixmap( loader->loadIcon( "lsqb.xbm" ) );
	break;
  case ']':
	previewRightLA->setPixmap( loader->loadIcon( "rsqb.xbm" ) );
	break;
  case LM_lfloor:
	previewRightLA->setPixmap( loader->loadIcon( "lfloor.xbm" ) );
	break;
  case LM_rfloor:
	previewRightLA->setPixmap( loader->loadIcon( "rfloor.xbm" ) );
	break;
  case LM_updownarrow:
	previewRightLA->setPixmap( loader->loadIcon( "updownarrow.xbm" ) );
	break;
  case LM_Updownarrow:
	previewRightLA->setPixmap( loader->loadIcon( "Updownarrow.xbm" ) );
	break;
  case '{':
	previewRightLA->setPixmap( loader->loadIcon( "lcub.xbm" ) );
	break;
  case '}':
	previewRightLA->setPixmap( loader->loadIcon( "rcub.xbm" ) );
	break;
  case '/':
	previewRightLA->setPixmap( loader->loadIcon( "sol.xbm" ) );
	break;
  case LM_backslash:
	previewRightLA->setPixmap( loader->loadIcon( "bsol.xbm" ) );
	break;
  case LM_downarrow:
	previewRightLA->setPixmap( loader->loadIcon( "downarrow.xbm" ) );
	break;
  case LM_Downarrow:
	previewRightLA->setPixmap( loader->loadIcon( "Downarrow.xbm" ) );
	break;
  case LM_langle:
	previewRightLA->setPixmap( loader->loadIcon( "langle.xbm" ) );
	break;
  case LM_rangle:
	previewRightLA->setPixmap( loader->loadIcon( "rangle.xbm" ) );
	break;
  case '|':
	previewRightLA->setPixmap( loader->loadIcon( "verbar.xbm" ) );
	break;
  case LM_Vert:
	previewRightLA->setPixmap( loader->loadIcon( "dverbar.xbm" ) );
	break;
  case '.':
	previewRightLA->setPixmap( loader->loadIcon( "blank.xbm" ) );
	break;
  };
}
	
  


/*
 * $Log: MathDelimiterDialog.C,v $
 * Revision 1.6  1998/06/08 21:40:06  kalle
 * Fixing bugs by the pound:
 * - corrected brelsubseteq.xbm
 * - math delimiter dialog shows delimiters correctly when called the second time
 * - corrected signal connection in paper format dialog
 * - added switch --no-splash for avoiding the splash screen
 *
 * Revision 1.5  1998/03/11 19:11:57  kalle
 * More dialogs Qt-ified
 *
 * Revision 1.4  1998/03/06 13:44:57  kulow
 * fixed the layout.
 *
 * Revision 1.3  1998/03/05 21:16:00  kulow
 * finished only first step to GM MathDelimiterDialog. But I got home now
 *
 * Revision 1.2  1998/03/03 22:36:21  kulow
 * removed all those ->show(), they make me crazy
 *
 * Revision 1.1  1998/01/09 22:46:57  kalle
 * math toolbar finished
 * old math panel removed
 * This concludes my work on the math toolbar!
 *
 */
