/*
 * $Id: CreditsDialog.C,v 1.4 1998/03/16 20:40:14 kulow Exp $
 */

#include "CreditsDialog.h"

#include <kapp.h>
#include <klocale.h>

#include <qfileinf.h>
#include <qlabel.h>
#include <qmlined.h>
#include <qpushbt.h>
#include <qlayout.h>

#include "LString.h"
#include "filetools.h"

extern LString system_lyxdir;

CreditsDialog::CreditsDialog( LyXView* view, QWidget * parent=0, 
			      const char * name=0, 
			      WFlags f=0 ) :
    QDialog( parent, name, true, f ),
    _view( view )
{
  QLabel* firstLA = new QLabel( i18n( "All these people have contributed to the KLyX project. Thanks," ), this );
  // firstLA->setGeometry( 480, 30 );
  firstLA->setAlignment( AlignVCenter | AlignCenter );

  QLabel* secondLA = new QLabel( i18n( "Matthias" ), this );
  //  secondLA->setGeometry( 480, 30 );
  secondLA->setAlignment( AlignVCenter | AlignCenter );
  secondLA->setFont( QFont( "Helvetica", 12, QFont::Normal, true ) );

  creditsML = new QMultiLineEdit( this );
  creditsML->adjustSize();
  creditsML->setMinimumSize( 480, 200 );
  creditsML->setReadOnly( true );
  

  QPushButton* okPB = new QPushButton( i18n( "OK" ), this );
  okPB->setFixedSize( 140, 30 );
  okPB->setDefault( true );
  connect( okPB, SIGNAL( clicked() ), SLOT( okClicked() ) );

  setCaption( i18n( "Credits" ) );

  firstLA->setMinimumSize(firstLA->sizeHint());
  secondLA->setMinimumSize(secondLA->sizeHint());
  okPB->setMinimumSize(okPB->sizeHint());
  if (okPB->minimumSize().width() <75)
      okPB->setFixedWidth(75);
  
  QVBoxLayout *v=new QVBoxLayout(this,5,5);
  v->addWidget(firstLA,0);
  v->addWidget(secondLA,0);
  v->addWidget(creditsML,1);
  v->addWidget(okPB,0);
  v->activate();

  resize(400,400);
  
}


void CreditsDialog::okClicked()
{
  accept();
}


void CreditsDialog::loadCredits()
{
  LString read_file;
  creditsML->clear();

  /* read the credits into the browser */ 
  
  /* try file LYX_DIR/CREDITS */ 
  read_file = AddName (system_lyxdir, "CREDITS");

  if( !QFileInfo( read_file.c_str() ).exists() )
      creditsML->insertLine( i18n( "ERROR: KLyX wasn't able to read CREDITS file\n" 
				   "\n"
				   "Please install correctly to estimate the great\n"
				   "amount of work other people have done for the KLyX project."));
  else
	{
	  QFile file( read_file.c_str() );
	  if( file.open( IO_ReadOnly ) )
		{
		  QTextStream stream( &file );
		  while( !stream.eof() )
			creditsML->insertLine( stream.readLine() );
		  
		  file.close();
		}
	}
}

/*
 * $Log: CreditsDialog.C,v $
 * Revision 1.4  1998/03/16 20:40:14  kulow
 * GM related bug fixes and cat the error message together to make translations easier
 *
 * Revision 1.3  1998/03/05 21:40:25  ralsina
 * [Roberto] GMified CreditsDialog. Notice, however, that I can't see this
 *           dialog, so I don't know if it's really right.
 *           I could bet a beer (or three) that it is ok, though.
 *
 * Revision 1.2  1998/03/04 21:49:17  kalle
 * More Qt-ified
 *
 * Revision 1.1  1998/02/16 20:20:54  kalle
 * Kalle: First XForms-free version
 *
 */
