/*
 * $Id: MathMatrixDialog.C,v 1.4 1999/01/05 11:16:43 kulow Exp $
 */

#include <qslider.h>

#include "MathMatrixDialog.h"

#include <kapp.h>
#include <klocale.h>

#include <qcombo.h>
#include <qgrpbox.h>
#include <qlcdnum.h>
#include <qlabel.h>
#include <qpushbt.h>
#include <qradiobt.h>

#include "LyXView.h"
#include "commandtags.h"
#include "lyxfunc.h"

MathMatrixDialog::MathMatrixDialog( LyXView* view, QWidget * parent=0, 
									  const char * name=0, 
									  WFlags f=0 ) :
  QDialog( parent, name, true, f ),
  _view( view )
{
  QGroupBox* rowsGB = new QGroupBox( i18n( "Rows" ), this );
  rowsGB->setGeometry( 10, 10, 220, 60 );

  rowsSL = new QSlider( 1, 20, 1, 1, QSlider::Horizontal, this );
  rowsSL->setGeometry( 20, 30, 140, 30 );

  rowsLC = new QLCDNumber( 2, this );
  rowsLC->setGeometry( 170, 30, 50, 30 );
  rowsLC->display( 1 );
  QObject::connect( rowsSL, SIGNAL( valueChanged( int ) ),
					rowsLC, SLOT( display( int ) ) );

  QGroupBox* columnsGB = new QGroupBox( i18n( "Columns" ), 
										this );
  columnsGB->setGeometry( 10, 80, 220, 60 );

  columnsSL = new QSlider( 1, 20, 1, 1, QSlider::Horizontal, this );
  columnsSL->setGeometry( 20, 100, 140, 30 );

  columnsLC = new QLCDNumber( 2, this );
  columnsLC->setGeometry( 170, 100, 50, 30 );
  columnsLC->display( 1 );
  QObject::connect( columnsSL, SIGNAL( valueChanged( int ) ),
					columnsLC, SLOT( display( int ) ) );
  QObject::connect( columnsSL, SIGNAL( valueChanged( int ) ),
					this, SLOT( columnValueChanged( int ) ) );

  QGroupBox* alignmentGB = new QGroupBox( i18n( "Alignment" ), 
										  this );
  alignmentGB->setGeometry( 10, 150, 220, 100 );

  QLabel* horzalignmentLA = new QLabel( i18n( "Horizontal" ), 
										this );
  horzalignmentLA->setGeometry( 20, 170, 60, 30 );

  horzalignmentED = new QLineEdit( this );
  horzalignmentVA = new MathHorzAlignmentValidator( this );
  horzalignmentED->setGeometry( 90, 170, 130, 30 );
  horzalignmentED->setText( "c" );
  horzalignmentED->setValidator( horzalignmentVA );

  QLabel* vertalignmentLA = new QLabel( i18n( "Vertical" ), 
										this );
  vertalignmentLA->setGeometry( 30, 210, 50, 30 );

  vertalignmentCB = new QComboBox( false, this );
  vertalignmentCB->setGeometry( 90, 210, 130, 30 );
  vertalignmentCB->insertItem( i18n( "Top" ) );
  vertalignmentCB->insertItem( i18n( "Center" ) );
  vertalignmentCB->insertItem( i18n( "Bottom" ) );
  vertalignmentCB->setCurrentItem( 1 ); // Center

  QPushButton* okPB = new QPushButton( i18n( "OK" ), this );
  okPB->setGeometry( 10, 260, 100, 30 );
  okPB->setDefault( true );
  connect( okPB, SIGNAL( clicked() ), this, SLOT( accept() ) );

  QPushButton* cancelPB = new QPushButton( i18n( "Cancel" ), 
										   this );
  cancelPB->setGeometry( 130, 260, 100, 30 );
  connect( cancelPB, SIGNAL( clicked() ), this, SLOT( reject() ) );

  setCaption( i18n( "Matrix" ) );
}


void MathMatrixDialog::columnValueChanged( int _new )
{
  if( _new > (int)strlen( horzalignmentED->text() ) )
	{
	  // more columns
	  QString pad; pad.fill( 'c', _new - strlen( horzalignmentED->text() ) );
	  horzalignmentED->setText( horzalignmentED->text() + pad );
	}
  else if( _new < (int)strlen( horzalignmentED->text() ) )
	{
	  // less columns
	  QString newstring = horzalignmentED->text();
	  newstring.truncate( _new );
	  horzalignmentED->setText( newstring );
	}
  // we should not come here
}


void MathMatrixDialog::setData( MathMatrixDialogData* _data )
{
  rowsSL->setValue( _data->num_rows );
  rowsLC->display( _data->num_rows );
  columnsSL->setValue( _data->num_cols );
  columnsLC->display( _data->num_cols );
  horzalignmentED->setText( _data->horz_align );
  vertalignmentCB->setCurrentItem( (int)_data->vert_align );
}


static MathMatrixDialogData tempdata;

MathMatrixDialogData* MathMatrixDialog::data() const
{
  tempdata.num_rows = rowsSL->value();
  tempdata.num_cols = columnsSL->value();
  tempdata.horz_align = horzalignmentED->text();
  tempdata.vert_align = 
	(MathMatrixDialogData::VerticalAlign)vertalignmentCB->currentItem();

  return &tempdata;
}


QValidator::State MathHorzAlignmentValidator::validate( QString& input, 
														int& pos )
{
  if( ( _owner->columnsSL->value() - input.length() ) >= 0 &&
	  ( input[pos] == 'c' || input[pos] == 'l' || input[pos] == 'r' ) )
	return QValidator::Acceptable;
  else
	return QValidator::Invalid;
}

			  

/*
 * $Log: MathMatrixDialog.C,v $
 * Revision 1.4  1999/01/05 11:16:43  kulow
 * s/klocale->translate/i18n
 * updated po files with the newly i18ned file dialogs
 *
 * Revision 1.3  1998/03/11 19:12:00  kalle
 * More dialogs Qt-ified
 *
 * Revision 1.2  1998/03/03 22:36:22  kulow
 * removed all those ->show(), they make me crazy
 *
 * Revision 1.1  1998/01/09 19:51:12  kalle
 * Math matrix and math spacing dialogs added
 *
 */
