/*
 * $Id: InsertCrossReferenceDialog.C,v 1.4 1999/01/29 12:57:06 kuepper Exp $
 */

#include "InsertCrossReferenceDialog.h"

#include <kapp.h>
#include <klocale.h>

#include <qlistbox.h>
#include <qpushbt.h>

#include "LyXView.h"
#include "LString.h"
#include "insetref.h"
#include "commandtags.h"
#include "lyxfunc.h"
#include <qlayout.h>

extern void InsertLatexDelInset(LString const & macro);

InsertCrossReferenceDialog::InsertCrossReferenceDialog( LyXView* view, 
							QWidget * parent=0, 
							const char * name=0, 
							WFlags f=0 ) :
  QDialog( parent, name, false, f ),
  _view( view )
{
  QGridLayout *grid = new QGridLayout(this, 4, 2, 5);

  listboxLB = new QListBox( this );
  listboxLB->adjustSize();
  listboxLB->setMinimumSize(listboxLB->size());
  grid->addMultiCellWidget(listboxLB, 0, 0, 0, 1);
 
  // listboxLB->setGeometry( 10, 10, 250, 160 );
  connect( listboxLB, SIGNAL( selected( int ) ),
	   this, SLOT( insertReferenceClicked() ) );
  
  QPushButton* insertpagenumberPB = new QPushButton( i18n( "Insert &Page Number" ), this ); 
  insertpagenumberPB->adjustSize();
  insertpagenumberPB->setMinimumSize(insertpagenumberPB->size());
  insertpagenumberPB->setMaximumHeight(insertpagenumberPB->height());
  grid->addWidget(insertpagenumberPB, 1, 0);
  connect( insertpagenumberPB, SIGNAL( clicked() ), 
	   this, SLOT( insertPageNumberClicked() ) );

  QPushButton* insertreferencePB = new QPushButton( i18n( "&Insert Reference" ), this );
  insertreferencePB->adjustSize();
  insertreferencePB->setMinimumSize(insertreferencePB->size());
  insertreferencePB->setMaximumHeight(insertpagenumberPB->height());

  grid->addWidget(insertreferencePB, 2, 0);
  connect( insertreferencePB, SIGNAL( clicked() ),
	   this, SLOT( insertReferenceClicked() ) );

  QPushButton* gotoreferencePB = new QPushButton( i18n( "&Go to Reference" ),this);
  gotoreferencePB->adjustSize();
  gotoreferencePB->setMinimumSize(gotoreferencePB->size());
  gotoreferencePB->setMaximumHeight(insertpagenumberPB->height());
  grid->addWidget(gotoreferencePB, 3, 0);
  connect( gotoreferencePB, SIGNAL( clicked() ),
	   this, SLOT( goToReferenceClicked() ) );

  QPushButton* updatePB = new QPushButton( i18n( "&Update" ), this );
  updatePB->adjustSize();
  updatePB->setMinimumSize(updatePB->size());
  updatePB->setMaximumHeight(insertpagenumberPB->height());
  grid->addWidget(updatePB, 1, 1);
  connect( updatePB, SIGNAL( clicked() ),
	   this, SLOT( updateClicked() ) );

  QPushButton* closePB = new QPushButton( i18n( "&Close" ), this );
  closePB->adjustSize();
  closePB->setMinimumSize(closePB->size());
  closePB->setMaximumHeight(insertpagenumberPB->height());
  grid->addWidget(closePB, 2, 1);
  connect( closePB, SIGNAL( clicked() ),
		   this, SLOT( closeClicked() ) );

  grid->setRowStretch(0, 6);
  grid->setRowStretch(1, 1);
  grid->setRowStretch(2, 1);
  grid->setRowStretch(3, 1);

  grid->setColStretch(0,1);
  grid->setColStretch(1,1);

  grid->activate();
  setCaption( i18n( "Insert Cross Reference" ) );
}


void InsertCrossReferenceDialog::insertPageNumberClicked()
{
  if (!_view->currentView()->available())
	return;

  LString s = listboxLB->text( listboxLB->currentItem() );
  if (s.empty())
	return;

  if (!_view->currentBuffer()->isLinuxDoc()) {
	LString t;
	t += "\\pageref{";
	t += s;
	t += '}';
	Inset *new_inset =
	  new InsetRef(t, _view->currentBuffer());
	_view->currentBuffer()->insertInset(new_inset);
  } else {
#ifdef WITH_WARNINGS
#warning FIXME!
#endif
	// probably changes should be made to InsetRef to handle
	// linuxdoc as well. (Lgb)
	/* special hack for linuxdoc sgml references */ 
	InsertLatexDelInset("\\ref{");
	for (int i=0; i<s.length(); i++) 
	  _view->currentBuffer()->text->InsertChar(s[i]);
	InsertLatexDelInset("}{");
	InsertLatexDelInset("}");
	_view->currentBuffer()->text->InsertChar(' ');
  }
}


void InsertCrossReferenceDialog::insertReferenceClicked()
{
  if (!_view->currentView()->available())
	return;

  LString s = listboxLB->text( listboxLB->currentItem() );
  if (s.empty())
	return;

  if (!_view->currentView()->currentBuffer()->isLinuxDoc()) {
	LString t;
	t += "\\ref{";
	t += s;
	t += '}';
	Inset *new_inset =
	  new InsetRef(t, _view->currentBuffer());
	_view->currentBuffer()->insertInset(new_inset);
  } else {
#ifdef WITH_WARNINGS
#warning FIXME!
#endif
	// probably changes should be made to InsetRef to handle
	// linuxdoc as well. (Lgb)
	/* special hack for linuxdoc sgml references */ 
	InsertLatexDelInset("\\ref{");
	for (int i=0; i<s.length(); i++) 
	  _view->currentBuffer()->text->InsertChar(s[i]);
	InsertLatexDelInset("}{");
	InsertLatexDelInset("}");
	_view->currentBuffer()->text->InsertChar(' ');
  }
}


void InsertCrossReferenceDialog::goToReferenceClicked()
{
  if (!_view->currentView()->available())
	return;
  
  LString s = listboxLB->text( listboxLB->currentItem() );
  if (s.empty())
	return;

  if (!_view->currentBuffer()->isLinuxDoc()) {
	_view->getLyXFunc()->Dispatch(LFUN_REFGOTO, s.c_str());
	return;

	} else {
#warning 1.) FIXME.   2.) This is no gotoref when this is a LinuxDoc document
	  // probably changes should be made to InsetRef to handle
	  // linuxdoc as well. (Lgb)
	  /* special hack for linuxdoc sgml references */ 
	  InsertLatexDelInset("\\ref{");
	  for (int i=0; i<s.length(); i++) 
		_view->currentBuffer()->text->InsertChar(s[i]);
	  InsertLatexDelInset("}{");
	  InsertLatexDelInset("}");
	  _view->currentBuffer()->text->InsertChar(' ');
	}
}


void InsertCrossReferenceDialog::updateClicked()
{
  listboxLB->clear();
  if (!_view->currentView()->available())
	return;
  
  LString references;
  LString curr_ref;
  int ref_num;
  
  ref_num=0;
  references=_view->currentBuffer()->getReferenceList();
  
  while(true) {
	curr_ref=references.token('|',ref_num);
	
	if (curr_ref=="")
	  break;
	
	listboxLB->insertItem( curr_ref.c_str() );
	ref_num++;
  }
  
  if( !listboxLB->count() ) {
	listboxLB->insertItem( i18n("*** No labels found in document ***") );
	listboxLB->setEnabled( false );
  } else {
	listboxLB->setCurrentItem( 0 );
	listboxLB->setEnabled( true );
  }
}


void InsertCrossReferenceDialog::closeClicked()
{
  hide();
}


/*
 * $Log: InsertCrossReferenceDialog.C,v $
 * Revision 1.4  1999/01/29 12:57:06  kuepper
 * Toolbar and Menu changes and cleanup.
 * (Esp. Mathfunction pulldown button.)
 *
 * Revision 1.3  1998/03/02 21:13:33  kalle
 * Kalle: Started to make dialogs more Qt-like
 *
 * Revision 1.2  1998/03/02 18:45:05  kulow
 * geometry managment for InsertCrossReferenceDialog. Looks a little bit bigger
 * than the old, but there is less I can do about
 *
 * Revision 1.1  1998/02/07 08:16:08  kalle
 * - added insert citation reference dialog
 * - added insert cross reference dialog
 * - fixed up Makefiles a bit
 * - removed old compatibility stuff
 *
 */
