// -*- c++ -*-
/* Copyright (C) 1999 Claus Wilke <claus.wilke@gmx.net>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

#ifndef KBIBLIOSHELL_H
#define KBIBLIOSHELL_H

#include <ktmainwindow.h>
#include <qstringlist.h>

class KBiblioMainView;
class KBiblioDoc;
class QString;

class KBiblioShell : public KTMainWindow
{
    Q_OBJECT
public:
    KBiblioShell( KBiblioDoc *doc, const QString &fileName, const char *name = 0 );

    ~KBiblioShell();
    bool setNewDoc( const QString &text = 0 );	

    QStringList editableFields( const QString &entryName ) const;
    QStringList viewableFields( const QString &entryName ) const;
    QString entryDescription( const QString &entryName ) const;
    QStringList entryDescriptionList( const QStringList &entryList ) const;
    QString fieldDescription( const QString &fieldName ) const;
    QStringList fieldDescriptionList( const QStringList &fieldList ) const;

    bool fieldIsEditable( const QString &fieldName );
    bool fieldIsViewable( const QString &fieldName );

    KBiblioDoc* document() const;
    KBiblioMainView* mainView() const;

    int marginHint() const;
    int spacingHint() const;

public slots:
    void setFieldEditable( const QString &fieldName, bool editable = true );
    void setFieldViewable( const QString &fieldName, bool viewable = true );

    void load();
    void load( const QString &fileName );
    void save();
    void saveAs();
    void saveToBibtex();
    void quit();
    void slotNewDoc();

    void preferences();
    void find();

    void about();
signals:
    void newDocument();

private:
    KBiblioMainView *mMainView;
    KBiblioDoc *mDocument;

    QString mFileName;
};

#endif







