// -*- c++ -*-
/* Copyright (C) 1999 Claus Wilke <claus.wilke@gmx.net>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

#ifndef ENTRYMANIPULATOR_H
#define ENTRYMANIPULATOR_H

#include "kbibliodoc.h"

class QString;
class QRegExp;
class QDomElement;
class KBiblioShell;

class EntryManipulator
{
 public:
    EntryManipulator();
    EntryManipulator( QDomElement entry, KBiblioShell *shell );
    EntryManipulator( QDomElement entry, KBiblioDoc *doc );
    EntryManipulator( const EntryManipulator &manip );
    ~EntryManipulator();
    EntryManipulator& operator=( const EntryManipulator &manip );


    BibEntryFieldType::DataType fieldDataType( const QString &fieldName ) const;

    QString name() const;
    QString label() const;
    QString fieldFlatText( const QString &fieldName, int length = -1 ) const;
    QString fieldRichText( const QString &fieldName ) const;

    QString richDisplayText() const;

    bool find( const QRegExp &regExp,  const QString &fieldName );

    void setValue( const QString &fieldName, const QString &value );
    void setLabel( const QString &label );

 protected:
    QString stringFieldText( QDomElement ) const;
    QString textFieldText( QDomElement ) const;
    QString stringFieldDisplayText( QDomElement field ) const;
    QString textFieldDisplayText( QDomElement ) const;
    QString authorListFieldDisplayText( QDomElement ) const;

    void stringFieldSetValue( QDomElement field, const QString &value );
    void textFieldSetValue( QDomElement field, const QString &value );

 private:
    KBiblioShell *mShell;
    KBiblioDoc *mDocument;
    QDomElement mEntry;
    QString mEntryName;
};





#endif
