// -*- c++ -*-
/* Copyright (C) 1999 Claus Wilke <claus.wilke@gmx.net>

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.

   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public License
   along with this library; see the file COPYING.LIB.  If not, write to
   the Free Software Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.
*/

#ifndef BIBENTRYDIALOG_H
#define BIBENTRYDIALOG_H

#include <qlist.h>
#include <qgroupbox.h>
#include <kdialogbase.h>

class QDomElement;
class QGroupBox;
class QComboBox;
class QLineEdit;
class QBoxLayout;
class QStringList;

class KBiblioShell;

class BibEntryFieldView;
class EntryManipulator;

class BibEntryView : public QWidget
{
    Q_OBJECT
public:
    BibEntryView( QDomElement entry, KBiblioShell *shell, QWidget *parent, const char *name = 0 );
    ~BibEntryView();

    bool edited();

public slots:
    void setEditedTrue();
    void typeChanged( int index );
    void storeData();

protected:
    BibEntryFieldView* addEntryView( int row, const QString &fieldName );
    void setupEditWidgets( const QStringList &editFieldNames );
    void setupEmptyWidget();


private:
    QList<BibEntryFieldView> *mFieldViews;
    QBoxLayout *mTopLayout;
    QGridLayout *mGridLayout;
    QGroupBox *mGroupBox;
    QLineEdit *mLined;
    QComboBox *mTypeCombo;
    QStringList mEntryTypes;

    int mOldIndex;
    bool mEdited;

    KBiblioShell *mShell;
    QDomElement mEntry;
    EntryManipulator *mManip;
};


class BibEntryDialog : public KDialogBase
{
    Q_OBJECT
public:
    BibEntryDialog( QDomElement entry, KBiblioShell *shell, QWidget *parent, const char *name=0 );

    virtual ~BibEntryDialog();
    bool edited();

public slots:
    void slotOk();

private:
    BibEntryView *mEntryView;
};

#endif






