/***************************************************************************
                          sendfaks.h  -  description
                             -------------------
    begin                : Fri Jan 28 16:21:57 CET 2000
    copyright            : (C) 2000 by Michael Sabielny
    email                : sabielny@tu-harburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef SENDFAKS_H
#define SENDFAKS_H



#ifdef HAVE_CONFIG_H
#include <config.h>
#endif


// include files for KDE 
#include <kapp.h>
#include <ktmainwindow.h>
#include <kaccel.h>
#include <kprocess.h>
#include <qpushbutton.h>
#include <qlistbox.h>
#include <qmultilinedit.h>
#include <autotab.h>
#include <qlcdnumber.h>
#include <faxnumber.h>
#include <listbox.h>
#include <qevent.h>

// forward declaration of the SendfaKs classes
class SendfaKsView;

/**
  * The base class for SendfaKs application windows. It sets up the main
  * window and reads the config file as well as providing a menubar, toolbar
  * and statusbar. An instance of SendfaKsView creates your center view, which is connected
  * to the window's Doc object.
  * SendfaKsApp reimplements the methods that KTMainWindow provides for main window handling and supports
  * full session management as well as keyboard accelerator configuration by using KAccel.
  * @see KTMainWindow
  * @see KApplication
  * @see KConfig
  * @see KAccel
  *
  * @author Source Framework Automatically Generated by KDevelop, (c) The KDevelop Team.
  * @version KDevelop version 0.4 code generation
  */
class SendfaKsApp : public KTMainWindow
{
  Q_OBJECT

  friend class SendfaKsView;

  public:
    /** construtor of SendfaKsApp, calls all init functions to create the application.
     * @see initMenuBar initToolBar
     */
    SendfaKsApp();
    ~SendfaKsApp();
    /** enables menuentries/toolbar items
     */
    void enableCommand(int id_);
    /** disables menuentries/toolbar items
     */
    void disableCommand(int id_);
    /** add a opened file to the recent file list and update recent_file_menu
     */
    void addRecentFile(const QString &file);



				
  protected:
    /** save general Options like all bar positions and status as well as the geometry and the recent file list to the configuration
     * file
     */ 	
    void saveOptions();
    /** read general Options again and initialize all variables like the recent file list
     */
    void readOptions();
    /** initKeyAccel creates the keyboard accelerator items for the available slots and changes the menu accelerators.
     * @see KAccel
     */
    void initKeyAccel();
    /** initMenuBar creates the menubar and inserts the menupopups as well as creating the helpMenu.
     * @see KApplication#getHelpMenu
     */
    void initMenuBar();
    /** this creates the toolbars.
     */
    void initToolBar();
    /** sets up the statusbar for the main window by initialzing a statuslabel.
     */
    void initStatusBar();
    /** initializes the document object of the main window that is connected to the view in initView().
     * @see initView();
     */
    // void initDocument();
    /** creates the centerwidget of the KTMainWindow instance and sets it as the view
     */
    void initView();
    /** queryClose is called by KTMainWindow on each closeEvent of a window. Against the
     * default implementation (only returns true), this calles saveModified() on the document object to ask if the document shall
     * be saved if Modified; on cancel the closeEvent is rejected.
     * @see KTMainWindow#queryClose
     * @see KTMainWindow#closeEvent
     */
    void initProcs();
    // initiates the commandline procs faxq, faxspool, faxrm
    //virtual bool queryClose();
    /** queryExit is called by KTMainWindow when the last window of the application is going to be closed during the closeEvent().
     * Against the default implementation that just returns true, this calls saveOptions() to save the settings of the last window's	
     * properties.
     * @see KTMainWindow#queryExit
     * @see KTMainWindow#closeEvent
     */

     void keyPressEvent(QKeyEvent *ev);

     void checkOptions();
     // checks all the user specific options and calls the options widget, if some options are not set

     QString createCustomHeaderFile();
     void removeCustomHeaderFile();
     //

  public slots:

    // slots in the faxMenu
    //
    // send the file
    void slotFaxSend();
    // polls a fax from a given faxnumber
    void slotFaxPoll();
		// gets the faxrunq status
		void slotFaxStatus();
		// deletes a job
		void slotFaxDelete();
		// quits the application
    void slotFaxQuit();

		// slots in the listMenu
		//
    // clears the document in the actual view to reuse it as the new document
    void slotListOpen();
    // opens a file from the recent files menu
    void slotListOpenRecent(int id_);
    // delete an entry in the filelist
    void slotListDelete();
    // move an entry up
    void slotListUp();
    // move an entry down
    void slotListDown();

		// slots in the viewMenu
		//
    void slotViewToolBar();
    // toggles the statusbar
    void slotViewStatusBar();
    // toggles the statusbar


    void slotSetupOptions();
    // shows the options dialog

    // other slots...
    //
    /** changes the statusbar contents for the standard label permanently, used to indicate current actions.
     * @param text the text that is displayed in the statusbar
     */
    void slotStatusMsg(const QString &text);

    /** changes the status message of the whole statusbar for two seconds, then restores the last status. This is used to display
     * statusbar messages that give information about actions for toolbar icons and menuentries.
     * @param text the text that is displayed in the statusbar
     */
    void slotStatusHelpMsg(const QString &text);

    void slotProcessOutput(KProcess *proc, char *buffer, int buflen);
    // collects the stdout/stderr-output from command-line programs

    void slotProcessExit(KProcess *proc);
    // actions after exit of external process


    /** switch argument for slot selection by menu or toolbar ID */
    void commandCallback(int id_);
    /** switch argument for Statusbar help entries on slot selection. Add your ID's help here for toolbars and menubar entries. */
    void statusCallback(int id_);

    void slotCommandLine(const QString);

    void slotListButtons(bool,bool,bool);

    void slotEnableSendPoll(int,int);

		
  private:
    /** contains the recently used filenames */
    QStrList recentFiles;
 		
 		// program configuration
    KConfig *config;

    /** the key accelerator container */
    KAccel *keyAccel;

    /** file_menu contains all items of the menubar entry "File" */
    QPopupMenu *faxMenu;

    QPopupMenu *recentFilesMenu;
    /** edit_menu contains all items of the menubar entry "Edit" */
    QPopupMenu *listMenu;

    QPopupMenu *setupMenu;
    // contains all user-specific initialisations

    QPopupMenu *viewMenu;
    /** help_menu contains all items of the menubar entry "Help" */

    QPopupMenu *helpMenu;
    /** view is the main widget which represents your working area. The View
     * class should handle all events of the view widget.  It is kept empty so
     * you can create your view according to your application's needs by
     * changing the view class.
     */
    SendfaKsView *view;
    /** doc represents your actual document and is created only once. It keeps
     * information such as filename and does the serialization of your files.
     */
  	
  	// Widgets of the main-window
		AutoTab *mainSelect;
		QListBox *messageListBox, *serverListBox;
		ListBox *fileListBox;
		bool fileListHasItems;

		// process-Containers
		KProcess *procGetFaxStatus;
		KProcess *procSendFax;
		KProcess *procPollFax;
		KProcess *procRemoveFax;

		// faxdisplay
		FaxNumber *faxNumberDisplay;
		bool faxNumberIsSet;

};
 
#endif // SENDFAKS_H
