/***************************************************************************
 group.cpp  -  description
 -------------------                                         
 begin                : Sun Jun 13 1999                                           
 copyright            : (C) 1999 by Roberto Alsina                         
 email                : ralsina@unl.edu.ar                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include <stdlib.h>
#include <stdio.h>

#include "group.h"
#include "connmgr.h"
#include "resource.h"
#include "kfileio.h"
#include "util.h"
#include "article.h"
#include "serversroot.h"
#include <pth.h>
#include <kmsgbox.h>
#include <ksimpleconfig.h>
#include <kapp.h>
#include <qlist.h>
#include <qstrlist.h>
#include <qfile.h>


Group::Group(const char *_server, const char *_name)
{
    server=_server;
    name=_name;
}
Group::~Group()
{
}

void Group::update()
{
    //exceptions:
    // 0 = nothing to do
    // 1 = can't connect
    // 2 = NNTP error
    // 3 = unknown error
    // 4 = nosql error while merging groupinfo table
    // 5 = nosql error while merging articles table
    // 6 = lost connection

    KMTNntpClient *client=0;
    try
    {
        debug ("entered Group::update");
        client=connmgr->getConn(server,name);
        if (!client) //if the open failed, do nothing
        {
            throw (1);
        }
        client->busy++;
        client->setStatus(QString("Updating ")+name);

        GroupItem gitem;
        gitem.Server=qstrdup(client->ProfileName());
        gitem.Group=qstrdup(name);
        
        if (name!=client->GroupName()) //If needed, change groups
            if (client->Group(name)!=211) //couldnt change group
                throw(2);

        QStrList pieces;
        QStringSplit(client->StatusResponse().c_str(),' ',pieces);
        int from=QString(pieces.at(2)).toInt();
        int to=QString(pieces.at(3)).toInt();
        debug ("from-->%d-to-->%d-",from,to);
        QString confpath=KApplication::localkdedir()+"/share/apps/newkrn/servers/"+server;
        debug ("confpath:%s",confpath.data());
        KSimpleConfig *conf=new KSimpleConfig(confpath,true);
        conf->setGroup("Xover");
        int lastFrom=conf->readNumEntry (name,-1);
        delete conf;
        if (from < lastFrom)
            from=lastFrom+1;
        if (from < 0)
            from=0;
        if (from > to)
            throw(0);
        debug ("processed: from-->%d-to-->%d-",from,to);
        //See if they are not TooMany (TM)
        if (to-from > TooManyThreshold)
        {
            debug ("too many");
            //FIXME Handle the too many case
        }

        //And now XOVER
        switch (client->Xover(from,to))
        {
        case 0:
            throw(6);
        case 224: //Success
            break;
        case 412: //Should not happen
        case 420: //Should not happen
        case 520: //No permission, whatever that means
            throw(2);
            break;
        default: //whatever
            throw(3);
            break;
        }

        QString resp=client->TextResponse().c_str();
        QStrList l;
        QStringSplit(resp,'\n',l);
        QListIterator <char> it(l);
        client->setStatus("Parsing XOVER data");

        QStrList parsed;
        uint counter=0;
        uint count=it.count();
        QString tempstr;
        dbCursor <Article> cursor;
        dbQuery q;
        for ( ; it.current(); ++it, counter++ ) //for each row of Xover data
        {
            if (!(counter%10))
            {
                client->clearStatus();
                client->setStatus(QString().sprintf("Parsing XOVER data %d of %d",counter,count));
            }
            //This removes the bogus \r
            it.current()[strlen(it.current())-1]=0;
            QStringSplit (it.current(),'\t',parsed);

            q="ID=",parsed.at(client->OffsetID);
            if (cursor.select(q)==0) //if article exists, do nothing
            {
            	Article art;
            	art.Subject=parsed.at(client->OffsetSubject);
            	art.From=parsed.at(client->OffsetFrom);
            	art.Lines=atol(parsed.at(client->OffsetLines));
            	art.ID=parsed.at(client->OffsetID);
            	art.Date=parsed.at(client->OffsetDate);
             	art.Ref=parsed.at(client->OffsetRef);
             	insert (art);
            }
            gitem.ID=parsed.at(client->OffsetID);
            gitem.Number=atol(parsed.at(0));

            //FIXME here is half a problem. If you get the same XOVER range
            //from the same group, from the same profile twice, you get
            //article duplication. Is avoiding that worth the effort of
            //checking for uniqueness on this insert? Good question!
            insert (gitem);
            debug ("GroupItem inserted");
            parsed.clear();
            pth_yield(NULL);
        }
        db.commit();

        //Merge group database



        //If all went ok, mark these headers as retrieved
        conf=new KSimpleConfig(confpath,false);
        conf->setGroup("Xover");
        conf->writeEntry (name,to);
        conf->sync();
        delete conf;
    }
    catch (int err)
    {

        debug ("exception in Group::update()-->%d",err);
        //exceptions:
        // 0 = nothing to do
        // 1 = can't connect
        // 2 = NNTP error
        // 3 = unknown error
        // 4 = nosql error while merging groupinfo table
        // 5 = nosql error while merging articles table
        QString msg;
        switch (err)
        {
        case 0:
            {
                break;
            }
        case 1:
            {
                msg.sprintf("Couldn't connect to server %s",server.data());
                KMsgBox::message(0,"Error",msg,0,"OK");
                return;
                break;
            }
        case 2:
            {
                msg.sprintf("NNTP error.\nServer said: %s",client->StatusResponse().c_str());
                KMsgBox::message(0,"Error",msg,0,"OK");
                break;
            }
        case 3:
            {
                msg.sprintf("Unknown error.\nServer said: %s",client->StatusResponse().c_str());
                KMsgBox::message(0,"Error",msg,0,"OK");
                break;
            }
        case 4:
            {
                KMsgBox::message(0,"Error","NoSQL database error while merging groupinfo table",0,"OK");
                break;
            }
        case 5:
            {
                KMsgBox::message(0,"Error","NoSQL database error while merging articles table",0,"OK");
                break;
            }
        case 6:
            {
                connmgr->killConn(client);
                KMsgBox::message(0,"Error","Lost connection to server",0,"OK");
                return;
                break;
            }
        }
    }
    client->clearStatus();
    client->busy--;
    debug ("leaving thr_GroupUpdate");
    connmgr->releaseConn(client);
    debug ("leaving Group::update");
}

void Group::list(ArticleList &arts)
{
    debug ("entered Group::list");
    
    dbCursor <GroupItem> gicursor;
    dbCursor <Article> artcursor;
    dbQuery q;
    dbQuery q2;
    
    q="Server=",server,"and Group=",name;
    debug ("select1");
    if (gicursor.select(q)>0)
    {
        do
        {
            debug ("loop gicursor");
            q2="ID=",gicursor->ID;
            debug ("select2");
            if (artcursor.select(q2)>0)
            {
                Article *art=new Article();;
                art->Read=artcursor->Read;
                art->From=artcursor->From;
                art->ID=artcursor->ID;
                art->Subject=artcursor->Subject;
                art->Date=artcursor->Date;
                art->Ref=artcursor->Ref;
                art->Lines=artcursor->Lines;
                arts.append(art);
            }
            else
            {
                debug ("bogus ID in groupitem???");
            }
        } while (gicursor.next());
    }
    debug ("leaving Group::list");
}

bool Group::fetch (const char *ID,bool quick)
{
    // Exceptions
    // 0 No need to fetch (cached)
    // 1 Can't connect
    // 2 NNTP error
    // 3 Lost connection
    // 4 No problem
    // 5 Unknown error
    // 6 Error saving
    
    KMTNntpClient *client=0;
    try
    {
        //    debug ("entered Group::fetch");
        QString path=KApplication::localkdedir()+"/share/apps/newkrn/cache/"+ID;
        
        
        if (QFile::exists(path))
            throw(0);
        
        client=connmgr->getConn(server,name);
        if (!client)
        {
            throw(1);
        }
        
        client->busy++;
        client->setStatus(QString("Getting article ")+ID);
        //I may need to enter the group
        if ((!client->canFetchByIDWithoutGroup) || (!client->canFetchByID))
            if (name!=client->GroupName()) //And I am not in the group
                if (211!=client->Group(name)) //And I can't enter the group
                    //FIXME handle error better
                    throw(2);
        int res=0;
        if (client->canFetchByID)
        {
            if (quick)
                res=client->Body(ID);
            else
                res=client->Article(ID);
            
        }
        else //have to fetch by number
        {
            dbCursor <GroupItem> cursor;
            dbQuery q;
            q="Server=",server,"and Group=",name,"and ID=",ID;
            if (cursor.select(q)>0)
            {
                long num=cursor->Number;
                if (quick)
                    res=client->Body(num);
                else
                    res=client->Article(num);
            }
            else
            {
                debug ("ID not in this server?");
                throw (5);
            }
        }

        //Now res holds the status of the ARTICLE or BODY command

        switch (res)
        {
        case 0:
            throw (3);
            break;
        case 220:
        case 221:
        case 222:
        case 223:
            break;
        default:
            throw(5);
            break;
        }
        QString data=client->TextResponse().c_str();
        //Save to disk
        bool b=kStringToFile(data,path,FALSE,FALSE);
        if (!b)
            throw (6);
    }
    catch (int err)
    {
        // Exceptions
        // 0 No need to fetch (cached)
        // 1 Can't connect
        // 2 NNTP error
        // 3 Lost connection
        // 4 No problem
        // 5 Unknown error
        // 6 Error saving
        QString msg;
        switch (err)
        {
        case 0:
            {
                return true;
            }
        case 1:
            {
                return false;
            }
        case 3:
            {
                connmgr->killConn(client);
                KMsgBox::message(0,"Error","Lost connection to server",0,"OK");
                return false;
                break;
            }
        case 2:
            {
                msg.sprintf("NNTP error.\nServer said: %s",client->StatusResponse().c_str());
                KMsgBox::message(0,"Error",msg,0,"OK");
                break;
            }
        case 5:
            {
                msg.sprintf("Unknown error.\nServer said: %s",client->StatusResponse().c_str());
                KMsgBox::message(0,"Error",msg,0,"OK");
                break;
            }
        case 4:
            {
                break;
            }
        case 6:
            {
                // kStringToFile already gives a message
                client->clearStatus();
                client->busy--;
                connmgr->releaseConn(client);
                return false;
                break;
            }

        }

    }
    //    debug ("leaving Group::fetch");
    client->clearStatus();
    client->busy--;
    connmgr->releaseConn(client);
    return true;
}














