/***************************************************************************
 util.cpp  -  description                              
 -------------------                                         
 begin                : Wed Jun 9 1999                                           
 copyright            : (C) 1999 by Roberto Alsina                         
 email                : ralsina@unl.edu.ar                                     
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include <sys/stat.h>
#include <sys/wait.h>
#include <dirent.h>
#include <unistd.h>
#include <stdlib.h>
#include <errno.h>

#include <qstrlist.h>
#include <qlist.h>
#include <kmsgbox.h>
#include <kapp.h>
#include <string.h>
#include <pth.h>

#include "busything.h"
#include "fastdb/fastdb.h"

dbDatabase db;

extern char **environ;


void QStringSplit (const QString &data,char sep,QStrList &splitted)
{
    uint counter=0;
    char *buf=data.data();
    char	*index,*oldindex=buf;
    while (1)
    {
        counter++;
        index=strchr(oldindex,sep);
        if (!index)
        {
            if ((*oldindex)!=0) //not end
            {
                splitted.append(oldindex);
            }
            break;
        }
        *(index)=0;
        splitted.append(oldindex);
        *(index)=sep;
        oldindex=index+1;
        pth_yield(NULL);
    }
}

void notImplemented ()
{
    KMsgBox::message(0,"Error","Not implemented yet",0,"OK");

}

void testDir( const char *_name )
{
    DIR *dp;
    QString c = KApplication::localkdedir();
    c += _name;
    dp = opendir( c.data() );
    if ( dp == NULL )
        ::mkdir( c.data(), S_IRWXU );
    else
        closedir( dp );
}


QList <BusyThing> dying_things;

void scheduleForDeath(BusyThing *thing)
{
    if (dying_things.findRef(thing)==-1)
        dying_things.append(thing);
}
void dieNow(BusyThing *thing)
{
    dying_things.removeRef(thing);
    delete thing;
}
void *thr_Reaper(void *arg)
{
    QListIterator <BusyThing> it(dying_things);
    while (1)
    {
        for (it.toFirst();it.current();)
        {
            if (!(it.current()->isBusy()))
            {
                dieNow(it.current());
            }
            ++it;
        }
        pth_usleep(50000);
    }
}


