/*
   $Id: sendDialog.cpp,v 1.1.2.2 1998/12/19 16:19:21 herwinjs Exp $
*/


#include <qpixmap.h>
#include <qlayout.h>
#include "sendDialog.h"

#include <libXicq.h>
#include <qlabel.h>
#include <qbttngrp.h>
#include <qpushbt.h>
#include <qcheckbox.h>
#include <qmlined.h>
#include "kxicq.h"
#include <qmessagebox.h>

#include "message.h"
extern int logged_on;

extern mainWin *mainW;
extern QList < MSG > userMsg;

sendDialog::sendDialog
(
    unsigned int toUIN,
    int t,
    QWidget* parent,
    const char* name
)
        :
        QDialog( parent, name, TRUE, 0 )
{
    uin = toUIN;
    type = t;
    QButtonGroup* qtarch_ButtonGroup_2;
    qtarch_ButtonGroup_2 = new QButtonGroup( this, "ButtonGroup_2" );
    qtarch_ButtonGroup_2->setGeometry( 5, 155, 390, 40 );
    qtarch_ButtonGroup_2->setMinimumSize( 0, 40 );
    qtarch_ButtonGroup_2->setMaximumSize( 32767, 40 );
    qtarch_ButtonGroup_2->setFocusPolicy( QWidget::NoFocus );
    qtarch_ButtonGroup_2->setBackgroundMode( QWidget::PaletteBackground );
    qtarch_ButtonGroup_2->setFontPropagation( QWidget::NoChildren );
    qtarch_ButtonGroup_2->setPalettePropagation( QWidget::NoChildren );
    qtarch_ButtonGroup_2->setFrameStyle( 49 );
    qtarch_ButtonGroup_2->setAlignment( 1 );

    QButtonGroup* qtarch_ButtonGroup_1;
    qtarch_ButtonGroup_1 = new QButtonGroup( this, "ButtonGroup_1" );
    qtarch_ButtonGroup_1->setGeometry( 5, 5, 390, 40 );
    qtarch_ButtonGroup_1->setMinimumSize( 245, 40 );
    qtarch_ButtonGroup_1->setMaximumSize( 32767, 40 );
    qtarch_ButtonGroup_1->setFocusPolicy( QWidget::NoFocus );
    qtarch_ButtonGroup_1->setBackgroundMode( QWidget::PaletteBackground );
    qtarch_ButtonGroup_1->setFontPropagation( QWidget::NoChildren );
    qtarch_ButtonGroup_1->setPalettePropagation( QWidget::NoChildren );
    qtarch_ButtonGroup_1->setFrameStyle( 49 );
    qtarch_ButtonGroup_1->setTitle( "" );
    qtarch_ButtonGroup_1->setAlignment( 1 );

    QLabel* qtarch_nick;
    qtarch_nick = new QLabel( qtarch_ButtonGroup_1, "nick" );
    qtarch_nick->setGeometry( 5, 8, 34, 25 );
    qtarch_nick->setMinimumSize( 0, 25 );
    qtarch_nick->setMaximumSize( 32767, 25 );
    qtarch_nick->setFocusPolicy( QWidget::NoFocus );
    qtarch_nick->setBackgroundMode( QWidget::PaletteBackground );
    qtarch_nick->setFontPropagation( QWidget::NoChildren );
    qtarch_nick->setPalettePropagation( QWidget::NoChildren );
    qtarch_nick->setFrameStyle( 50 );
    qtarch_nick->setText( "Nick:" );
    qtarch_nick->setAlignment( 289 );
    qtarch_nick->setMargin( -1 );


    qtarch_toNick = new QLabel( qtarch_ButtonGroup_1, "toNick" );
    qtarch_toNick->setGeometry( 44, 8, 129, 25 );
    qtarch_toNick->setMinimumSize( 100, 25 );
    qtarch_toNick->setMaximumSize( 32767, 25 );
    qtarch_toNick->setFocusPolicy( QWidget::NoFocus );
    qtarch_toNick->setBackgroundMode( QWidget::PaletteBackground );
    qtarch_toNick->setFontPropagation( QWidget::NoChildren );
    qtarch_toNick->setPalettePropagation( QWidget::NoChildren );
    qtarch_toNick->setFrameStyle( 34 );
    QString tmp;
    if ( uin > 0 ) tmp.sprintf( "%s", contact_uin2nick( uin ) );
    else	tmp.sprintf(  i18n("<UNKNOWN>") );
    qtarch_toNick->setText( tmp.data() );
    qtarch_toNick->setAlignment( 289 );
    qtarch_toNick->setMargin( -1 );

    QLabel* qtarch_uin;
    qtarch_uin = new QLabel( qtarch_ButtonGroup_1, "uin" );
    qtarch_uin->setGeometry( 217, 8, 34, 25 );
    qtarch_uin->setMinimumSize( 0, 25 );
    qtarch_uin->setMaximumSize( 32767, 25 );
    qtarch_uin->setFocusPolicy( QWidget::NoFocus );
    qtarch_uin->setBackgroundMode( QWidget::PaletteBackground );
    qtarch_uin->setFontPropagation( QWidget::NoChildren );
    qtarch_uin->setPalettePropagation( QWidget::NoChildren );
    qtarch_uin->setFrameStyle( 50 );
    qtarch_uin->setText(  i18n("UIN:") );
    qtarch_uin->setAlignment( 289 );
    qtarch_uin->setMargin( -1 );

    qtarch_toUin = new QLabel( qtarch_ButtonGroup_1, "toUin" );
    qtarch_toUin->setGeometry( 256, 8, 129, 25 );
    qtarch_toUin->setMinimumSize( 100, 25 );
    qtarch_toUin->setMaximumSize( 32767, 25 );
    qtarch_toUin->setFocusPolicy( QWidget::NoFocus );
    qtarch_toUin->setBackgroundMode( QWidget::PaletteBackground );
    qtarch_toUin->setFontPropagation( QWidget::NoChildren );
    qtarch_toUin->setPalettePropagation( QWidget::NoChildren );
    qtarch_toUin->setFrameStyle( 34 );
    tmp.sprintf( "%d", uin );
    qtarch_toUin->setText( tmp.data() );
    qtarch_toUin->setAlignment( 289 );
    qtarch_toUin->setMargin( -1 );

    if ( type == SEND_URL )
    {
        qtarch_LineEdit_2 = new QLineEdit( this, "LineEdit_2" );
        qtarch_LineEdit_2->setGeometry( 5, 50, 442, 25 );
        qtarch_LineEdit_2->setMinimumSize( 0, 25 );
        qtarch_LineEdit_2->setMaximumSize( 32767, 25 );
        qtarch_LineEdit_2->setFocusPolicy( QWidget::StrongFocus );
        qtarch_LineEdit_2->setBackgroundMode( QWidget::PaletteBase );
        qtarch_LineEdit_2->setFontPropagation( QWidget::NoChildren );
        qtarch_LineEdit_2->setPalettePropagation( QWidget::NoChildren );
        qtarch_LineEdit_2->setText( "" );
        qtarch_LineEdit_2->setMaxLength( 32767 );
        qtarch_LineEdit_2->setEchoMode( QLineEdit::Normal );
        qtarch_LineEdit_2->setFrame( TRUE );
        qtarch_LineEdit_2->setFocus();
    }

    qtarch_MultiLineEdit_1 = new MLEditWrap( TRUE, this );
    qtarch_MultiLineEdit_1->setGeometry( 5, 50, 390, 100 );
    qtarch_MultiLineEdit_1->setMinimumSize( 0, 0 );
    qtarch_MultiLineEdit_1->setMaximumSize( 32767, 32767 );
    qtarch_MultiLineEdit_1->setFocusPolicy( QWidget::StrongFocus );
    qtarch_MultiLineEdit_1->setBackgroundMode( QWidget::PaletteBase );
    qtarch_MultiLineEdit_1->setFontPropagation( QWidget::SameFont );
    qtarch_MultiLineEdit_1->setPalettePropagation( QWidget::SameFont );
    qtarch_MultiLineEdit_1->insertLine( "" );
    qtarch_MultiLineEdit_1->setReadOnly( FALSE );
    qtarch_MultiLineEdit_1->setOverwriteMode( FALSE );
    if ( type != SEND_URL ) qtarch_MultiLineEdit_1->setFocus();

    qtarch_trueServer = new QCheckBox( qtarch_ButtonGroup_2, "trueServer" );
    qtarch_trueServer->setGeometry( 125, 5, 140, 30 );
    qtarch_trueServer->setMinimumSize( 140, 30 );
    qtarch_trueServer->setMaximumSize( 140, 30 );
    qtarch_trueServer->setFocusPolicy( QWidget::TabFocus );
    qtarch_trueServer->setBackgroundMode( QWidget::PaletteBackground );
    qtarch_trueServer->setFontPropagation( QWidget::NoChildren );
    qtarch_trueServer->setPalettePropagation( QWidget::NoChildren );
    qtarch_trueServer->setText(  i18n("Send through Server") );
    qtarch_trueServer->setAutoRepeat( FALSE );
    qtarch_trueServer->setAutoResize( FALSE );

    QPushButton* qtarch_Send;
    qtarch_Send = new QPushButton( qtarch_ButtonGroup_2, "Send" );
    qtarch_Send->setGeometry( 10, 5, 100, 30 );
    qtarch_Send->setMinimumSize( 100, 30 );
    qtarch_Send->setMaximumSize( 100, 30 );
    connect( qtarch_Send, SIGNAL( clicked() ), SLOT( doSend() ) );
    qtarch_Send->setFocusPolicy( QWidget::TabFocus );
    qtarch_Send->setBackgroundMode( QWidget::PaletteBackground );
    qtarch_Send->setFontPropagation( QWidget::NoChildren );
    qtarch_Send->setPalettePropagation( QWidget::NoChildren );
    qtarch_Send->setText(  i18n("Send" ));
    qtarch_Send->setAutoRepeat( FALSE );
    qtarch_Send->setAutoResize( FALSE );

    QPushButton* qtarch_cancel;
    qtarch_cancel = new QPushButton( qtarch_ButtonGroup_2, "cancel" );
    qtarch_cancel->setGeometry( 280, 5, 100, 30 );
    qtarch_cancel->setMinimumSize( 100, 30 );
    qtarch_cancel->setMaximumSize( 100, 30 );
    connect( qtarch_cancel, SIGNAL( released() ), SLOT( doCancel() ) );
    qtarch_cancel->setFocusPolicy( QWidget::TabFocus );
    qtarch_cancel->setBackgroundMode( QWidget::PaletteBackground );
    qtarch_cancel->setFontPropagation( QWidget::NoChildren );
    qtarch_cancel->setPalettePropagation( QWidget::NoChildren );
    qtarch_cancel->setText(  i18n("Cancel") );
    qtarch_cancel->setAutoRepeat( FALSE );
    qtarch_cancel->setAutoResize( FALSE );

    qtarch_ButtonGroup_2->insert( qtarch_trueServer );
    qtarch_ButtonGroup_2->insert( qtarch_Send );
    qtarch_ButtonGroup_2->insert( qtarch_cancel );


    QBoxLayout* qtarch_layout_1 = new QBoxLayout( this, QBoxLayout::TopToBottom, 5, 5, NULL );
    qtarch_layout_1->addStrut( 0 );
    qtarch_layout_1->addWidget( qtarch_ButtonGroup_1, 1, 36 );
    QGridLayout* qtarch_layout_1_1 = new QGridLayout( qtarch_ButtonGroup_1, 1, 5, 5, 5, NULL );
    qtarch_layout_1_1->addColSpacing( 0, 5 );
    qtarch_layout_1_1->setColStretch( 0, 1 );
    qtarch_layout_1_1->addColSpacing( 1, 5 );
    qtarch_layout_1_1->setColStretch( 1, 1 );
    qtarch_layout_1_1->addColSpacing( 2, 5 );
    qtarch_layout_1_1->setColStretch( 2, 1 );
    qtarch_layout_1_1->addColSpacing( 3, 5 );
    qtarch_layout_1_1->setColStretch( 3, 1 );
    qtarch_layout_1_1->addColSpacing( 4, 5 );
    qtarch_layout_1_1->setColStretch( 4, 1 );
    qtarch_layout_1_1->addRowSpacing( 0, 0 );
    qtarch_layout_1_1->setRowStretch( 0, 1 );
    qtarch_layout_1_1->addWidget( qtarch_nick, 0, 0, 36 );
    qtarch_layout_1_1->addWidget( qtarch_toNick, 0, 1, 36 );
    qtarch_layout_1_1->addWidget( qtarch_uin, 0, 3, 36 );
    qtarch_layout_1_1->addWidget( qtarch_toUin, 0, 4, 36 );
    if ( type == SEND_URL )
        qtarch_layout_1->addWidget( qtarch_LineEdit_2, 1, 36 );
    qtarch_layout_1->addWidget( qtarch_MultiLineEdit_1, 100, 36 );
    qtarch_layout_1->addWidget( qtarch_ButtonGroup_2, 1, 36 );
    QGridLayout* qtarch_layout_1_3 = new QGridLayout( qtarch_ButtonGroup_2, 1, 3, 5, 5, NULL );
    qtarch_layout_1_3->addColSpacing( 0, 5 );
    qtarch_layout_1_3->setColStretch( 0, 1 );
    qtarch_layout_1_3->addColSpacing( 1, 5 );
    qtarch_layout_1_3->setColStretch( 1, 1 );
    qtarch_layout_1_3->addColSpacing( 2, 5 );
    qtarch_layout_1_3->setColStretch( 2, 1 );
    qtarch_layout_1_3->addRowSpacing( 0, 0 );
    qtarch_layout_1_3->setRowStretch( 0, 1 );
    qtarch_layout_1_3->addWidget( qtarch_Send, 0, 0, 36 );
    qtarch_layout_1_3->addWidget( qtarch_trueServer, 0, 1, 36 );
    qtarch_layout_1_3->addWidget( qtarch_cancel, 0, 2, 36 );
    resize( 400, 200 );
    setMinimumSize( 400, 200 );
    setMaximumSize( 32767, 32767 );
}


sendDialog::~sendDialog()
{
}
void sendDialog::doSend()
{
    char *tmp2, *tmp;
    tmp2 = ( char * ) malloc( qtarch_MultiLineEdit_1->text().length() + 1 );
    strcpy( tmp2, qtarch_MultiLineEdit_1->	text().data() );
    tmp = ( char * ) malloc( BUFSIZE );
    int len = qtarch_MultiLineEdit_1->text().length();
    if ( len > 1023 ) len = 1023;
    strncpy( tmp, tmp2, len );
    tmp[ len ] = 0;
    unix2dos( tmp );
    int tt;
    if ( qtarch_trueServer->isChecked() )
        tt = SEND_TRUE_SERVER;
    else
        tt = SEND_TCP;

    MESSAGE mes;
    URL url;
    time_t t=time(NULL);
    tm *t2=localtime(&t);
    MSG *meg;
    if ( logged_on==1 )
    {
        switch ( type )
        {
        case SEND_MSG:
            
            
            mes.time.day=t2->tm_mday;
            mes.time.month=t2->tm_mon+1;
            mes.time.year=t2->tm_year+1900;
            mes.time.min=t2->tm_min;
            mes.time.hour=t2->tm_hour;
            mes.sender=uin;
            mes.length=strlen(tmp);
            mes.message=(char *)tmp;
            mes.online=2;
            mainW->Wmessage(&mes);

            MSG *meg;

            meg=userMsg.last();
            meg->setRead(2);
            
            
                send_message( tt, uin, tmp );
                break;
            case SEND_CHAT:
                if ( tt == SEND_TRUE_SERVER )
                {
                    if ( QMessageBox::warning( this, i18n( "Chat Request" ),
                                               i18n( "You have Checked 'Send through Server for a chat request.'\nThat is not possible!\n\n"
                                                     "Do you want to Cancel it or Send it direct ?" ), i18n( "Send" ), i18n( "Cancel" ) ) == 0 )
                        send_chatRequest( uin, tmp );
                }
                else
                {
                    send_chatRequest( uin, tmp );
                }
                break;
        case SEND_URL:
            url.time.day=t2->tm_mday;
            url.time.month=t2->tm_mon+1;
            url.time.year=t2->tm_year+1900;
            url.time.min=t2->tm_min;
            url.time.hour=t2->tm_hour;
            url.sender=uin;
            url.desc=(char *)tmp;
            url.url=(char *)(char *)qtarch_LineEdit_2->text();
            url.online=2;
            mainW->Wurl(&url);

            meg=userMsg.last();
            meg->setRead(2);

            send_url( tt, uin, (char *)qtarch_LineEdit_2->text(), tmp );

            break;
        }
    }
    else
        loggedon();
    free( tmp );
    free( tmp2 );
    if (this) delete this;

}
void sendDialog::doCancel()
{
    if (this) delete this;
}

#include "sendDialog.moc"
