#include "message.h"
#include <qlist.h>
#include <stdio.h>
#include <stdlib.h>


extern QList <MSG> userMsg;
extern ReadFile readFile;

ReadFile::ReadFile(char *f)
{
    status=FILE_NONE;
    file.setName(f);
    count=0;
    if (file.open(IO_ReadWrite)==FALSE)
        status=FILE_ERROR;
    else
        status=FILE_OPEN;
}

ReadFile::ReadFile()
{
    status=FILE_NONE;
}

ReadFile::~ReadFile()
{
    file.close();
}

int ReadFile::getStatus()
{
    return status;
}

void ReadFile::setFileName(char *f)
{
    if (status!=FILE_NONE)
        return;
    file.setName(f);
    count=0;
    if (file.open(IO_ReadWrite)==FALSE)
        status=FILE_ERROR;
    else
        status=FILE_OPEN;
}
void ReadFile::setRead(UIN pos, int b)
{
    if (b>2) b=2; else if (b<=0) b=0;

    file.at(pos);

    char *buf;
    buf=(char *)malloc(2048);

    for (int t=0; t<3; t++)
    {
        if (file.readLine(buf,2000)==0)
        {
            status=FILE_ERROR;
        }
        else
        {
        }
    }
    sprintf(buf,"Read=%d\n",b);
    file.writeBlock(buf, strlen(buf));
    file.flush();
    
    free(buf);
    
}


int ReadFile::scanMessages()
{
    QString buffer(2048);
    QString command(2048);
    char *buf;
    buf=(char *)malloc(2048);

    file.at(0);
    if (file.readLine(buf,100)==0 || file.size() == 0 || file.atEnd() == TRUE )
        count=0;
    else
    {
        buffer=buf;
        buffer.remove(0,buffer.find("=")+1);
        count=buffer.toInt();
        if (count<0) return -1;
        int error=0;
        int found;
        int at=0;
        MSG *tmpMSG=NULL;
        while(file.atEnd()==FALSE && error==0)
        {
            at=file.at();
            if (file.readLine(buf,2000)==0)
            {
                error=1;
            }
            else
            {
                buffer=buf;
                command=buf;
                found=buffer.find("=");
                command.remove(found,2048);
                buffer.remove(0,found+1);
                //printf("->%s=%s<-\n",command.data(),buffer.data());
                if (strncmp(buffer.data(),"[Message",8)==0)
                {
                    userMsg.append(new MSG());
                    tmpMSG=userMsg.current();
                    tmpMSG->setPos(at);
                    
                }
                if (command=="UIN")
                {
                    //printf("Uin: %d\n",buffer.toInt());
                    if (tmpMSG)
			tmpMSG->setUin(buffer.toLong());
                    
                }
                if (command=="Read")
                {
                    if (tmpMSG!=NULL)
                    {
			if (tmpMSG)
                    	    tmpMSG->setnRead(buffer.toInt());
                    }
                }
            }
//            error=1;
        }
    }
    free(buf);
    return count;
}
void ReadFile::readMessage(UIN p, MSGf *m)
{
    
    QString buffer(2048);
    QString command(2048);
    char *buf;
    buf=(char *)malloc(2048);
    int error=0;
    int found;
    //int at=0;
    file.at(p);
    int max_t=12;
            m->message=NULL;
            m->firstName=NULL;
            m->lastName=NULL;
            m->nick=NULL;
            m->email=NULL;
            m->url=NULL;
            m->auth_req=0;

    for (int t=0; t<max_t; t++)
    {
        if (file.readLine(buf,2000)==0)
        {
            error=1;
        }
        else
        {

                buffer=buf;
                command=buf;
                found=buffer.find("=");
                command.remove(found,2048);
                buffer.remove(0,found+1);
                //printf("->%s/%s<-\n",command.data(),buffer.data());
                if (t==1)
                    m->uin=buffer.toLong();
                if (t==2)
                {
                    buffer.remove(buffer.find("\n"),1);
                    if (buffer=="message")
                        m->type=1;
                    else if (buffer=="url")
                        m->type=2;
                    else if (buffer=="added")
                        m->type=3;
                    else if (buffer=="request")
                        m->type=4;
                }

                
                if (t==3)
                    m->status=buffer.toInt();
                if (t==4)
                    m->time.year=buffer.toInt();
                if (t==5)
                    m->time.month=buffer.toInt();
                if (t==6)
                    m->time.day=buffer.toInt();
                if (t==7)
                    m->time.hour=buffer.toInt();
                if (t==8)
                    m->time.min=buffer.toInt();
                if (t==9)
                    m->online=buffer.toInt();
                switch(m->type)
                {
                case 1:
                    if (t==10)
                        m->len=buffer.toInt();
                    if (t==11) // message
                    {
                        buffer.remove(buffer.find("\n"),1);
                        asprintf(&m->message,buffer.data());
                    }
                    max_t=12;
                    break;
                case 2:
                        if (t==10) // message
                        {
                            buffer.remove(buffer.find("\n"),1);
                            asprintf(&m->message,"%s",buffer.data());
                        }
                        if (t==11) // url
                        {
                            buffer.remove(buffer.find("\n"),1);
                            asprintf(&m->url,"%s",buffer.data());
                        }
                        max_t=12;
                        break;
                case 4:
                        if (t==15)
                        {
                            buffer.remove(buffer.find("\n"),1);
                            asprintf(&m->message,"%s",buffer.data());
                        }
                        m->auth_req=1;
                        max_t=16;


                case 3:
                        if (t==10) // message
                        {
                            buffer.remove(buffer.find("\n"),1);
                            asprintf(&m->nick,"%s",buffer.data());
                        }
                        if (t==11) // url
                        {
                            buffer.remove(buffer.find("\n"),1);
                            asprintf(&m->firstName,"%s",buffer.data());
                        }
                        if (t==12)
                        {
                            buffer.remove(buffer.find("\n"),1);
                            asprintf(&m->lastName,"%s",buffer.data());
                        }
                        if (t==13)
                        {
                            buffer.remove(buffer.find("\n"),1);
                            asprintf(&m->email,"%s",buffer.data());
                        }
                        if (t==14)
                        {
                            m->auth=buffer.toInt();
                        }
                        if (max_t<=15) max_t=15;
                        if (max_t!=16)
                        {
                            m->message=NULL;
                            m->auth_req=0;
                        }

                }
        }
    }
    free(buf);
}

/* ------------------------------------------------------------------------- */

MSG::MSG(UIN u)
{
    uin=u;
}
MSG::MSG()
{
}

MSG::~MSG()
{
}

void MSG::setUin(UIN u)
{
    uin=u;
}
void MSG::setMessage(MSGf *)
{
}
void MSG::setPos(int p)
{
    pos=p;
}
void MSG::setStatus(int s)
{
    status=s;
}

void MSG::getMessage(MSGf *m)
{
    if (pos>0)
    {
        readFile.readMessage(pos,m);
    }
}
void MSG::setRead(int b)
{
    if (pos>0)
    {
        readFile.setRead(pos,b);
        setnRead(b);
    }
}
