/*
    Requires the Qt widget libraries, available at no cost at
    http://www.troll.no

    Copyright (C) 1998 Stephen Hutton
                       shutton@acm.org

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

/* utils.h */

#ifndef _UTILS_H
#define _UTILS_H

#include <qdatetm.h>
#include <qstring.h>
#include <stdlib.h>
#include <fcntl.h>
#include "kapp.h"
#include <errno.h>

const char* const months[] = { "Jan", "Feb", "Mar", "Apr", "May", "Jun",
			       "Jul", "Aug", "Sep", "Oct", "Nov", "Dec" };

const char* const timechoices[] = { "6 hours", "24 hours", "12 hours", "3 hours",
                                    "1 hour", "30 minutes", "10 minutes", 0 };

const int  time_in_seconds[] = { 6*60*60, 24*60*60, 12*60*60,
                                 3*60*60, 60*60, 30*60, 10*60 }; 

QDateTime* GetDateTimeFromString( QString str );
QString    StripTime( QDateTime dt );
char*      TrimString(char* s);
long       CountCharsOutsideOfTags( const char* body_buff, int& inside_tags );
bool       FirstInstance(long* pid);

#endif // _UTILS_H
