/***************************************************************************
                          inputwindow.cpp  -  description
                             -------------------
    begin                : Tue Oct 12 1999
    copyright            : (C) 1999 by Andreas Bleischwitz & Joerg Zopes
    email                : Zab@Pironet.de & Joerg.Zopes@t-online.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
#include "inputwindow.h"

inputwindow::inputwindow(QWidget *parent, const char *name, DataSet * userdata ) : QDialog(parent,name,true) {
int index=0;

	data = userdata;

	this->setCaption("Enter User Data");
	this->setFixedSize(250,150);
		
	mainframe = new QFrame(this);
	mainframe->setGeometry(5,5,240,140);
	mainframe->setFrameStyle( QFrame::Panel | QFrame::Sunken );

	servicelabel = new QLabel(this);
	servicelabel->setText("Service: ");
	servicelabel->setGeometry(20,(this->height()-50)/4*3,50,20);

	services = new QStrList(true);
  services->insert(services->count(),"CELLNET");
	services->insert(services->count(),"DETEMOBIL D1");
	services->insert(services->count(),"D2");
	services->insert(services->count(),"EPLUS");
	services->insert(services->count(),"TELENOR");
	services->insert(services->count(),"AZCOM");
	services->insert(services->count(),"TELESTRA");
	services->insert(services->count(),"VODAFONO UK");
	services->insert(services->count(),"VODAFONO AU");
	services->insert(services->count(),"ORANGE");
	services->insert(services->count(),"MINICALL");
	services->insert(services->count(),"ONE2ONE");
	services->insert(services->count(),"VODAPAGE");
	services->insert(services->count(),"VODACOM");
	services->insert(services->count(),"PTT/KPN Telecom");
	services->insert(services->count(),"ANSWER");
	services->insert(services->count(),"MTN");
	services->insert(services->count(),"LIBERTEL");
	services->insert(services->count(),"TIM");
	services->insert(services->count(),"PROXIMUS");
	services->insert(services->count(),"AMPI");
	services->insert(services->count(),"EUROPOLITAN");
	services->insert(services->count(),"BTEASYREACH");
	services->insert(services->count(),"SWISSCOM");
	servicefield = new QComboBox(this);
  servicefield->setGeometry(servicelabel->x()+servicelabel->width()+20,servicelabel->y(),130,20);
  servicefield->insertStrList(services,-1);
	while ((index < servicefield->count()-1) && (strcmp(servicefield->text(index),data->service) != 0)){
		index++;
		servicefield->setCurrentItem(index);
	}

	namelabel = new QLabel(this);
	namelabel->setText("Name: ");
	namelabel->setGeometry(20,(this->height()-50)/4,50,20);
  namefield = new QLineEdit(this);
	namefield->setGeometry(namelabel->x()+namelabel->width()+20,namelabel->y(),130,20);
  namefield->setMaxLength(20);
	namefield->setText(data->name);

	phonenrlabel = new QLabel(this);
	phonenrlabel->setText("Phone Nr: ");
	phonenrlabel->setGeometry(20,(this->height()-50)/4*2,50,20);
	phonenrfield = new QLineEdit(this);
	phonenrfield->setGeometry(phonenrlabel->x()+phonenrlabel->width()+20,phonenrlabel->y(),130,20);
	phonenrfield->setMaxLength(20);
	phonenrfield->setText(data->phonenr);

	okbutton = new QPushButton("&OK",this);
	okbutton->setGeometry(this->width()-130,this->height()-30,50,20);

	cancelbutton = new QPushButton("&Cancel",this);
	cancelbutton->setGeometry(this->width()-60,this->height()-30,50,20);

	connect(okbutton,SIGNAL(clicked()),this,SLOT(slotexit_inputwindow()));
	connect(cancelbutton,SIGNAL(clicked()),this,SLOT(slotcancel_inputwindow()));
}
inputwindow::~inputwindow(){
}

void inputwindow::slotexit_inputwindow(){
	strcpy(data->name,namefield->text());
	strcpy(data->service,servicefield->currentText());
	strcpy(data->phonenr,phonenrfield->text());
	this->done(true);
}

void inputwindow::slotcancel_inputwindow(){
	this->done(false);
}

