//////////////////////////////////////////////////////////////////////////////
//                                                                          //
// This file os part of KRN, a newsreader for the KDE project.              //
// KRN is distributed under the GNU General Public License.                 //
// Read the acompanying file COPYING for more info.                         //
//                                                                          //
// KRN wouldn't be possible without these libraries, whose authors have     //
// made free to use on non-commercial software:                             //
//                                                                          //
// MIME++ by Doug Sauder                                                    //
// Qt     by Troll Tech                                                     //
//                                                                          //
// This file is copyright 1997 by                                           //
// Roberto Alsina <ralsina@unl.edu.ar>                                      //
// Magnus Reftel  <d96reftl@dtek.chalmers.se>                               //
//                                                                          //
//////////////////////////////////////////////////////////////////////////////

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <unistd.h>
#include <pwd.h>

#include <qapp.h>
#include <qfile.h>
#include <qdir.h>
#include <qdict.h>

#include <kapp.h>
#include <kconfig.h>
#include <kmsgbox.h>
#include <kstdaccel.h>
#include <ksimpleconfig.h>
#include <kiconloader.h>

#include "rules.h"
#include "asker.h"
#include "krnsender.h"
#include "kmidentity.h"
#include "kbusyptr.h"
#include "kmmessage.h"
#include "kmaddrbook.h"
#include "kfileio.h"
#include "groupdlg.h"
#include "artdlg.h"
#include "expirestatusdlg.h"
#include "NNTP.h"
#include "article.h"
#include <mimelib/mimepp.h>

// robert's cache stuff
#include <dirent.h>
#include <time.h>
#include <stdlib.h>

#include "gigabase/gigabase.h"

KApplication *app;
Groupdlg  *main_widget;
KConfig *conf;
KLocale *nls;
KRNSender *msgSender;
KMIdentity *identity;
KBusyPtr *kbp;
KMAddrBook *addrBook;
KStdAccel* keys;
QPopupMenu *serversPopup=0;
QDict <NewsGroup> groupDict(17,TRUE);

QList <Rule> ruleList;
KSimpleConfig *ruleFile=0;

NNTP *server=0;

QString krnpath,cachepath,artinfopath,groupinfopath,dbasepath,outpath;

void checkConf();
void expireCache();

void testDir( const char *_name )
{
    DIR *dp;
    QString c = KApplication::localkdedir();
    c += _name;
    dp = opendir( c.data() );
    if ( dp == NULL )
	::mkdir( c.data(), S_IRWXU );
    else
	closedir( dp );
}

dbDatabase db (dbDatabase::dbAllAccess,0,dbDefaultExtensionQuantum,4096);
dbCursor <Article> cursor(dbCursorForUpdate);

bool strictdelete=true;

int main( int argc, char **argv )
{

    msgSender=0;
    // Initialize the mime++ library
    DwInitialize();

    debug ("creating application");
    KApplication *a=new KApplication ( argc, argv, "krn" );
    //a.enableSessionManagement();

    debug ("creating more globals");
    app=a;
    conf=a->getConfig();

    checkConf();
    nls=a->getLocale();
    keys = new KStdAccel(conf);
    kbp=new KBusyPtr();
    msgSender=new KRNSender();
    msgSender->readConfig();
    msgSender->setMethod(KMSender::smSMTP);
    KMMessage::readConfig();

    addrBook=new KMAddrBook();
    addrBook->readConfig();
    addrBook->load();


    // Create our directory. If it exists, no problem
    // Should do some checking, though

    debug ("testing dirs");
    testDir( "/share" );
    testDir( "/share/config" );
    testDir( "/share/apps" );
    testDir( "/share/apps/krn" );
    testDir( "/share/apps/krn/cache" );
    testDir( "/share/apps/krn/groupinfo" );
    testDir( "/share/apps/krn/outgoing" );

    krnpath = KApplication::localkdedir() + "/share/apps/krn/";

    mkdir (krnpath.data(),S_IREAD|S_IWRITE|S_IEXEC);
    cachepath=krnpath+"/cache/";
    mkdir (cachepath.data(),S_IREAD|S_IWRITE|S_IEXEC);
    groupinfopath=krnpath+"/groupinfo/";
    mkdir (groupinfopath.data(),S_IREAD|S_IWRITE|S_IEXEC);
    outpath=krnpath+"outgoing/";
    mkdir (outpath.data(),S_IREAD|S_IWRITE|S_IEXEC);

    // See if last version used was 0.6.0
    // Really, it looks for just anyhting older than this
    conf->setGroup("KRN");
    QString vname=conf->readEntry("Version","0.6.0");
    if (vname=="0.6.0")
    {

        // Check for database existance, and run converter
        if ( QFile::exists(krnpath+"/artinfo.db") ||
             QFile::exists(krnpath+"/refs.db") ||
             QFile::exists(krnpath+"/scores.db") )
        {
            int i=KMsgBox::yesNo (0,"KRN - Message",
                                  "Because of complaints by owners of the GDBM library\n"
                                  "KRN, after version 0.6.0, has changed it's storage\n"
                                  "mechanism to a much nicer, faster, smarter library.\n"
                                  "The good news are that I can convert them automatically.\n"
                                  "Should I convert the databases?");

            if (i==1)
            {
                system ("kvt -e krnconvert");
            }

        }
    }
    conf->writeEntry("Version","0.6.11");

    // Create the articles database

    debug ("opening database");
    QString basepath=krnpath+"/articles.dbs";
    int res=db.open(basepath.data());
    if (!res)
    {
        KMsgBox::message(0,"Error opening database");
        exit(1);
    }

    //Cleaning stale artlist references in database
    dbQuery q("exists i: (lists[i] > 0)");
    dbCursor <Article> *mycursor=new dbCursor <Article>;
    if (mycursor->select(q))
    {
        debug ("removing list references from %d articles",mycursor->getNumberOfRecords());
        Article *art=mycursor->first();
        while (art)
        {
            art->lists.clear();
            art->save(false);
            art=mycursor->next();
        }
        db.commit();
    }

    mycursor->reset();
    strictdelete=false;
    delete mycursor;
    strictdelete=true;


    debug ("loading rules");

    // Load the rules
    ruleFile=new KSimpleConfig(krnpath+"/rules");
    Rule::updateGlobals();

    // Create the servers popup
    conf->setGroup("NNTP");
    QStrList servlist;
    serversPopup=new QPopupMenu(0);
    conf->readListEntry("NNTPServerList",servlist);
    for (char *sn=servlist.first();sn!=0;sn=servlist.next())
    {
        serversPopup->insertItem(sn);
    }

    debug ("creating main widget");
    Groupdlg *k=new Groupdlg();
    main_widget = k;

    //insert this:
    if (a->isRestored())
        k->restore(1);

    a->setMainWidget( k );
    a->setTopWidget( k );

    k->setMinimumSize( 250, 250 );
    k->show();

    a->exec();

    expireCache();

    db.close();
    k->close();
    delete k;
    db.commit();
    strictdelete=false;
    exit(0);
}

void checkConf()
// This checks that all necessary data exists and/or asks for it
{

    identity=new KMIdentity();
    identity->setSignatureFile(QString(getenv("HOME"))+"/.signature");

    Asker *ask;
    ask=new Asker();
    QString data;
    conf->setGroup("Identity");

    data=conf->readEntry("Email Address");
    if (data.isEmpty())
    {
        ask->setCaption (klocale->translate("KRN-Missing Configuration info"));
        ask->label->setText(klocale->translate("Please enter your email adress"));
        ask->entry->setText(identity->emailAddr());
        ask->exec();
        data=ask->entry->text();
        identity->setEmailAddr(data);
    }
    delete ask;
    ask=new Asker();

    data=conf->readEntry("Name");
    if (data.isEmpty())
    {
        ask->setCaption (klocale->translate("KRN-Missing Configuration info"));
        ask->label->setText(klocale->translate("Please enter your real name"));
        ask->entry->setText(identity->fullName());
        ask->exec();
        data=ask->entry->text();
        identity->setFullName(data);
    }

    delete ask;
    ask=new Asker();

    data=identity->organization();
    if (data.isEmpty())
    {
        ask->setCaption (klocale->translate("KRN-Missing Configuration info"));
        ask->label->setText(klocale->translate("Please enter your organization's name"));
        ask->entry->setText(getenv("ORGANIZATION"));
        ask->exec();
        data=ask->entry->text();
        if (data.isEmpty())
            data="-";
        conf->writeEntry("Organization",data);
        identity->setOrganization(data);
    }

    delete ask;
    ask=new Asker();

    conf->setGroup("NNTP");
    data=conf->readEntry("NNTPServer");
    if (data.isEmpty())
    {
        ask->setCaption (klocale->translate("KRN-Missing Configuration info"));
        ask->label->setText(klocale->translate("Please enter your NNTP server name"));
        ask->entry->setText(getenv("NNTPSERVER"));
        ask->exec();
        data=ask->entry->text();
        conf->writeEntry("NNTPServer",data);
    }

    delete ask;
    ask=new Asker();

    conf->setGroup("sending mail");
    data=conf->readEntry("Smtp Host");
    if (data.isEmpty())
    {
        ask->setCaption (klocale->translate("KRN-Missing Configuration info"));
        ask->label->setText(klocale->translate("Please enter your SMTP server name"));
        QString add=identity->emailAddr();
        add=add.right(add.length()-add.find('@')-1);
        ask->entry->setText(add.data());
        ask->exec();
        data=ask->entry->text();
        conf->writeEntry("Smtp Host",data);
    }

    conf->sync();
    identity->writeConfig();
}

void expireCache()   // robert's cache stuff
{

    main_widget->hide();
    QDictIterator <NewsGroup> it(groupDict);

    NewsGroup *iter;

    for (it.toFirst();it.current(); ++it)
    {
        iter=it.current();
        if (iter->isVisible)
            iter->isVisible->hide();
    }
    new ExpireStatusDlg();
}


