/***************************************************************************
                          make_popup.cpp  -  description
                          ------------------------------
    copyright            : (C) 2000 by Torsten Henschel
    email                : henschel@fh-brandenburg.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <ctype.h>
#include <malloc.h>
#include <stdio.h>
#include <unistd.h>

#include <klocale.h>
#include <kmessagebox.h>

#include <qfile.h>

#include <make_popup.h>
#include <misc.h>

make_Popup::make_Popup(QWidget *parent, const char *name) : KDialog(parent, name, TRUE)
{
 hostname = (char *) malloc (30 * (sizeof(char)));
 ReadHostName();

 B_Ok = new QPushButton(i18n("Ok"), this);
 B_Ok -> setGeometry(25, 165, 60, 25);
 connect(B_Ok, SIGNAL(clicked()), SLOT(SendPopup()));

 B_Cancel = new QPushButton(i18n("Cancel"), this );
 B_Cancel -> setGeometry(180, 165, 75, 25);
 connect(B_Cancel, SIGNAL(clicked()), SLOT(reject()));

 L_Receiver = new QLabel(i18n("To:"), this);
 L_Receiver -> setGeometry(20, 9, 30, 20);

 CB_Receiver = new QComboBox(TRUE, this);
 CB_Receiver -> setGeometry(55, 8, 205, 22);

 L_Text = new QLabel(i18n("Text:"), this);
 L_Text -> setGeometry(20, 33, 98, 20);

 MLE_Text = new QMultiLineEdit(this);
 MLE_Text -> setGeometry(20, 57, 240, 100);

 setMinimumSize(280, 195);
 setMaximumSize(280, 195);
}

make_Popup::~make_Popup()
{
 free(hostname);
}


void make_Popup::SendPopup()
{
 FILE *sendprocess;
 char *commandline;
 int linecount = 0;

 commandline = (char *) malloc (182 * (sizeof(char)));
 sprintf(commandline, "%s/smbclient -M %s -N -U %s > /dev/null", SMBPATH, (const char *)CB_Receiver->currentText(), hostname);

 if((sendprocess = popen(commandline, "w")) != 0)
   {
    while(linecount < MLE_Text -> numLines())
     {
      fprintf(sendprocess, "%s\n", (const char *)MLE_Text -> textLine(linecount));
      linecount++;
     }
   if(pclose(sendprocess) == 0)
     {
      KMessageBox::information(this, i18n("Popup sent!"), i18n("Success"));
      reject();
     }
    else
     {
      KMessageBox::sorry(this, i18n("Popup not sent!"), i18n("Error"));
     }
   }

 free(commandline);
}


void make_Popup::ReadHostName()
{
 gethostname(hostname, 30);
 for(int i = 0; i <= 29; i++) hostname[i] = toupper(hostname[i]);
}


void make_Popup::ReadBrowseList()
{
 QFile *hostfile;
 char *line;
 char *host;
 int flag1 = 0, flag2 = 0;

 line = (char *) malloc (201 * (sizeof(char)));
 host = (char *) malloc (22 * (sizeof(char)));
 hostfile = new QFile("/tmp/kpopup.hostlist");

 if(hostfile -> open(IO_ReadOnly))
   {
    while(!(hostfile -> atEnd()))
     {
      hostfile -> readLine(line, 200);
      if((strlen(line) == 1) && (flag1 == 1)) flag2 = 1;

      if((flag1 == 1) && (flag2 == 0))
        {
         if((strlen(line) > 22) && (line[0] == '\t') && (strncmp(line, "	---------", 10) > 0))
           {
            line[0] = ' ';
            line[22] = 0;
            for(int i = 23; i >= 1; i--)
             {
              host[i - 1] = 0;
              if(line[i] == 32) host[i - 1] = 0;
               else host[i - 1] = line[i];
             }
            CB_Receiver -> insertItem(host, -1);
           }
        }
      if((strncmp(line, "	Server               Comment", 24)) == 0) flag1 = 1;
     }
    free(line);
    free(host);
    hostfile -> close();
   }
}
