/***************************************************************************
                     knreadoptions.cpp - description
 copyright            : (C) 1999 by Christian Thurner
 email                : cthurner@freepage.de
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "knreadoptions.h"
#include "knglobals.h"
#include <qlabel.h>
#include <qlayout.h>



KNReadOptions::KNReadOptions(QWidget *parent, const char *name ) :
	KNOptionsWidget(parent,name)
{
	gGeneral=new QGroupBox(i18n("General"), this);	

	autoChk=new QCheckBox(i18n("check for new messages automatically"), gGeneral);
	maxFetch=new KRestrictedLine(gGeneral); maxFetch->setValidChars("0123456789");
	markTime=new KRestrictedLine(gGeneral); markTime->setValidChars("0123456789");
	showSig=new QCheckBox(i18n("show signature"), gGeneral);
	
	SIZE(autoChk); SIZE(showSig);
	WIDTH(maxFetch, 50); WIDTH(markTime, 50);
	
	QLabel *l1=new QLabel(i18n("max to fetch:"), gGeneral);
	QLabel *l2=new QLabel(i18n("mark messages as read after:"), gGeneral);
	QLabel *l3=new QLabel(i18n("secs"), gGeneral);
	
	SIZE(l1); SIZE(l2); SIZE(l3);
	
	
	gExpire=new QGroupBox(i18n("Expire"), this);	
	
	expInt=new KRestrictedLine(gExpire); expInt->setValidChars("0123456789");
	keepRead=new KRestrictedLine(gExpire); keepRead->setValidChars("0123456789");
	keepUnread=new KRestrictedLine(gExpire); keepUnread->setValidChars("0123456789");
	saveThr=new QCheckBox(i18n("save threads"), gExpire);
	
	SIZE(saveThr); WIDTH(expInt, 50);
	WIDTH(keepRead, 50); WIDTH(keepUnread, 50);
	
	QLabel *l4=new QLabel(i18n("expire every"), gExpire);
	QLabel *l5=new QLabel(i18n("days"), gExpire);
	QLabel *l6=new QLabel(i18n("keep read messages:"), gExpire);
	QLabel *l7=new QLabel(i18n("days"), gExpire);
	QLabel *l8=new QLabel(i18n("keep unread messages:"), gExpire);
	QLabel *l9=new QLabel(i18n("days"), gExpire);
	
	SIZE(l4); SIZE(l5); SIZE(l6); SIZE(l7); SIZE(l8); SIZE(l9);
	
	QVBoxLayout *topL=new QVBoxLayout(this, 10);
	QGridLayout *genL=new QGridLayout(gGeneral, 5, 3, 20, 10);
	QGridLayout *expL=new QGridLayout(gExpire, 5, 3, 20, 10);
	
	
	
	genL->addMultiCellWidget(autoChk, 0,0, 0,2);
	
	genL->addMultiCellWidget(showSig, 1,1, 0,2);
	
	genL->addWidget(l1, 3,0);
	genL->addWidget(maxFetch, 3,1);
	
	genL->addWidget(l2, 4,0);
	genL->addWidget(markTime, 4,1);
	genL->addWidget(l3, 4,2);
	
	genL->setRowStretch(2,1);
	genL->setColStretch(0,10);
	genL->setColStretch(1,1);
	
	
	
	
	expL->addWidget(l4, 0,0);
	expL->addWidget(expInt, 0,1);
	expL->addWidget(l5, 0,2);
	
	expL->addWidget(l6, 2,0);
	expL->addWidget(keepRead, 2,1);
	expL->addWidget(l7, 2,2);
	
	expL->addWidget(l8, 3,0);
	expL->addWidget(keepUnread, 3,1);
	expL->addWidget(l9, 3,2);
	
	expL->addMultiCellWidget(saveThr, 4,4, 0,2);
		
	expL->setRowStretch(1,1);
	expL->setColStretch(0,10);
	expL->setColStretch(1,1);
	
	
	topL->addWidget(gGeneral);
	topL->addWidget(gExpire);
	topL->activate();
	
	readConfig();	
}



KNReadOptions::~KNReadOptions()
{
}



void KNReadOptions::applyConfig()
{
	KConfig *conf=CONF();
	
	conf->setGroup("READNEWS");
	
	conf->writeEntry("autoCheck", autoChk->isChecked());
	conf->writeEntry("showSig",showSig->isChecked());
	
	if(strlen(maxFetch->text())>0)
		conf->writeEntry("MaxFetch", atoi(maxFetch->text()));
	
	if(strlen(markTime->text())>0)
		conf->writeEntry("markSecs", atoi(markTime->text()));
	

	conf->setGroup("EXPIRE");
	
	if(strlen(expInt->text())>0)
		conf->writeEntry("expInterval", atoi(expInt->text()));
		
	if(strlen(keepUnread->text())>0)
		conf->writeEntry("unreadDays", atoi(keepUnread->text()));
	
	if(strlen(keepRead->text())>0)
		conf->writeEntry("readDays", atoi(keepRead->text()));
		
	conf->writeEntry("saveThreads", saveThr->isChecked());
}



void KNReadOptions::readConfig()
{
	KConfig *conf=CONF();
	char tmp[10];
	
	conf->setGroup("READNEWS");
	
	
	sprintf(tmp,"%d",conf->readNumEntry("MaxFetch",300));
	maxFetch->setText(tmp);
	
	sprintf(tmp,"%d", conf->readNumEntry("markSecs",5));
	markTime->setText(tmp);
	
	showSig->setChecked(conf->readBoolEntry("showSig",true));
	autoChk->setChecked(conf->readBoolEntry("autoCheck",true));
	
	conf->setGroup("EXPIRE");
	
	sprintf(tmp, "%d", conf->readNumEntry("expInterval", 5));
	expInt->setText(tmp);
	
	sprintf(tmp,"%d", conf->readNumEntry("readDays",10));
	keepRead->setText(tmp);
	
	sprintf(tmp,"%d", conf->readNumEntry("unreadDays",15));
	keepUnread->setText(tmp);
	
	saveThr->setChecked(conf->readBoolEntry("saveThreads",true));
	
}







