/***************************************************************************
                     knoptionsdialog.h - description
 copyright            : (C) 1999 by Christian Thurner
 email                : cthurner@freepage.de
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KNOPTIONSDIALOG_H
#define KNOPTIONSDIALOG_H


#include <qdialog.h>
#include <qpushbutton.h>
#include <qtoolbutton.h>
#include <ktabctl.h>

#include "knserveroptions.h"
#include "knreadoptions.h"
#include "knpostoptions.h"
#include "knfntcoloptions.h"


class KNOptionsDialog : public QDialog  {

  Q_OBJECT
	
	public:
		KNOptionsDialog(QWidget *parent=0, const char *name=0);
		~KNOptionsDialog();
		
		KNOptionsWidget* server()		{ if(bServer) return mServer; else return 0;}
		KNOptionsWidget* read()			{ if(bRead) 	return mRead; 	else return 0;}
		KNOptionsWidget* post()			{ if(bPost) 	return mPost; 	else return 0;}
		KNOptionsWidget* fntColor() { if(bFntCol) return mFntCol; else return 0;}
		
	protected:
		KTabCtl *tabs;
		QPushButton *cancel, *help,*ok;
		//QToolButton *ok ;
		
		KNServerOptions *mServer;
		KNReadOptions *mRead;
		KNPostOptions *mPost;
		KNFntColOptions *mFntCol;
		
		bool bServer, bRead, bPost, bFntCol;
		
	protected slots:
		void slotTabSelected(int id);
		
};

#endif




