/***************************************************************************
                     knode.h - description
 copyright            : (C) 1999 by Christian Thurner
 email                : cthurner@freepage.de
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KNODE_H
#define KNODE_H 
 

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

// include files for QT
#include <qprinter.h>
#include <qpainter.h>
#include <qprogressbar.h>
#include <qdir.h>

// include files for KDE 
#include <kapp.h>
#include <ktmainwindow.h> 
#include <kaccel.h>
#include <kiconloader.h>
#include <kmsgbox.h>

// application specific includes
#include "knodeview.h"
#include "knntpclient.h"
#include "kngrmanager.h"
#include "knpostingmanager.h"
#include "knfiltermanager.h"
#include "knfoldermanager.h"


class KNodeApp : public KTMainWindow
{
  	Q_OBJECT

	public:
  				
  	KNodeApp();
  	~KNodeApp();
  	
  	
  	//GUI
  	void setStatusMsg(const char *text=0, int id=SB_MAIN);
    void setStatusHelpMsg(const char *text);
    void setCursorBusy(bool b=true);
    void setProgrBarSteps(int s)	{ progress->setTotalSteps(s); }
    void resetProgrBar()					{ progress->reset(); }
    void setProgress(int p)				{ progress->setProgress(p); }


    //Member-Access
    NNTP* nntpClient()						{ return Client; }
    KNGrManager* gManager()				{ return GManager; }
    KNFolderManager* foManager()	{ return FoManager; }
    KNFilterManager* fiManager() 	{ return FiManager; }
    KNArticleManager* artManager(){ return AManager; }

  public slots:
  	void slotSaveYourself()				{ cleanup(); }

  protected slots:
  	
  	//slots for the menubar
  	void commandCallback(int id_);
  	void TestCallback(int _id); //DEBUG
  	
  	void slotFileQuit();
  	void slotFilePrint();
  	
  	void slotMsgNew();
  	void slotMsgReply();
  	void slotMsgRemail();
  	void slotMsgMarkRead();
  	void slotMsgMarkUnread();
  	void slotMsgThrRead();
  	void slotMsgThrUnread();
  	void slotMsgThrScore();
  	void slotMsgEdit();
  	void slotMsgDelete();
  	  	
  	void slotGotoNextArt();
  	void slotGotoPrevArt();  	
  	void slotGotoNextUnreadArt();
  	void slotGotoNextThr();
  	
  	void slotViewHeaders(int id);
  	void slotViewSort(int id);
  	void slotViewRefresh();
  	  	  	
  	
  	//view-slots  	
	 	void slotEViewChanged(QListViewItem *it);
  	void slotHViewChanged(QListViewItem *it);
  	void slotHViewDClicked(QListViewItem *it);
  	void slotReferenceClicked(int refNr);
  	void slotSortingChanged(int oldCol, int newCol);
  	
  	//other slots  	
  	void slotConnection(bool c);
  	void slotPopupAboutToShow();

  	
    	
	private:

	  //init && update
		void initMenuBar();
 	  void initToolBar();
 	  void initStatusBar();
 	  void initView();
 	  void initAccel();
 	       	
    void setMenusEnabled(int *ptr , bool e);
  	void ViewToolBar();
    void ViewStatusBar();
  	void updateMenuAccels();

  	void saveOptions();
  	void readOptions();
  	
  	
    //show dialogs
  	void showOptionsDialog();
  	void showKeyDialog();
  	
  	//exit
    void cleanup();
    bool queryExit();



    //menuBar
    QPopupMenu 	*file_menu,
    						*groups_menu, *groups_menu_folders,
    						*message_menu, *message_menu_thread,
     						*message_menu_mark, *message_menu_send,
    						*goto_menu,
    						*view_menu, *view_menu_hdr, *view_menu_sort,
    						*settings_menu,
    						*help_menu;

   	QPopupMenu *test_menu; //DEBUG
   	
   	//popups
   	QPopupMenu *groupPopup, *folderPopup, *readPopup, *postPopup;
   	
   	KAccel *acc;
   	
   	KToolBar *tb0;
   	KNodeView *view;
   	QProgressBar *progress;

    bool bViewToolbar;
  	bool bViewStatusbar;
    KMenuBar::menuPosition menu_bar_pos;
  	KToolBar::BarPosition tool_bar_pos;  	
				
    NNTP	*Client;
    KNGrManager	*GManager;
    KNArticleManager *AManager;
    KNPostingManager *PManager;
    KNFilterManager *FiManager;
    KNFolderManager *FoManager;
                 	
};   
 
#endif // KNODE_H
 
 
 
 
 
 
 
 


































































































































































