/***************************************************************************
                     knode.cpp - description
 copyright            : (C) 1999 by Christian Thurner
 email                : cthurner@freepage.de
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdio.h>
#include <knode.h>
#include <qdir.h>
#include <qlabel.h>
#include <kkeydialog.h>
#include <qheader.h>
#include "knoptionsdialog.h"
#include "knhdrviewitem.h"
#include "knentryviewitem.h"
#include "knheaderbase.h"
#include "knentrybase.h"
#include "utilities.h"
#include "resource.h"
#include "menu_ids.h"


//#define TEST

NNTP *xClient;

//========================================================================
//=============================== KNODEAPP ===============================
//========================================================================


KNodeApp::KNodeApp()
{
	
	
  //init

  //check if KNode Dir exists
	QDir dir=QDir::home();
	bool succ=false;
	QString tmp=dir.absPath()+"/.knode";
	dir.setPath(tmp);
	
	if(!dir.exists()) {
		debug("creating directory \"~/.knode\"\n");
		succ=dir.mkdir(tmp);
		if(succ) succ=dir.mkdir("Folders");
		if(succ) succ=dir.mkdir("Filters");
	
		if(!succ) {
			MBox(err,
				i18n("ERROR : KNode could not create\na directory in your home-directory !")
			);
			exit(1);
		}
			
		else {
			tmp="cp " + kapp->kde_datadir() + "/knode/filters/* ";
			tmp+=knDir()+"Filters/";
		  system(tmp);
		}	
	}
	
	//init Filter Manager
	FiManager=new KNFilterManager();
	
	
		
  //init the GUI
  setCaption("KNode " VERSION);


  initView();
  initMenuBar();
  initToolBar();
 	initStatusBar();


  //init Newsclient
	Client=new NNTP;
	xClient=Client;
	connect(Client, SIGNAL(connected(bool)), this, SLOT(slotConnection(bool)));
	
	
	//init Article Manager
	AManager=new KNArticleManager(view->hdrView);
	connect(FiManager, SIGNAL(filterChanged(KNMessageFilter*)),
		AManager, SLOT(slotFilterChanged(KNMessageFilter*)));	
			
		
  //init Group Manager
	GManager=new KNGrManager(AManager, view->entryView);
	GManager->readConfig();
	
	
	//init Folder Manager
	FoManager=new KNFolderManager(view->entryView);
	
		
  //init Posting Manager
	PManager=new KNPostingManager(view->hdrView, FoManager);
  connect(view->msgView, SIGNAL(mailTo(const char*)), PManager,
		SLOT(slotMailTo(const char*)));
	
	FoManager->setPManager(PManager);	
	
		
	
	
	//init accels
	initAccel();
		
		
	//init menu-items
	slotEViewChanged(0);
	
	//read options
	readOptions();
	if (!bViewToolbar) enableToolBar(KToolBar::Hide,0);
  if (!bViewStatusbar) enableStatusBar(KStatusBar::Hide);

  menuBar()->setMenuBarPos(menu_bar_pos);
  tb0->setBarPos(tool_bar_pos);

  view_menu->setItemChecked(ID_SHOW_STATB,bViewStatusbar);
  view_menu->setItemChecked(ID_SHOW_TOOLB0,bViewToolbar);
}



KNodeApp::~KNodeApp()
{
 	
	delete groupPopup;
	delete folderPopup;
	delete readPopup;
	delete postPopup;
	
	delete acc;
 	
 	delete Client;
 	debug("client deleted\n");
 	
 	delete PManager;
	debug("pmanager deleted\n");
	
	delete GManager;
 	debug("gmanager deleted\n");
 	
 	delete AManager;
 	debug("amanager deleted\n");
 	
 	delete FiManager;
  debug("fimanager deleted\n");

  delete FoManager;
  debug("fomanager deleted\n");
 	 	
}




//========================================================================
//================================== GUI =================================
//========================================================================


void KNodeApp::setStatusMsg(const char *text=0, int id=SB_MAIN)
{
  statusBar()->clear();
  if(text) statusBar()->changeItem(text, id);
  else {
  	statusBar()->changeItem(SB_DEFLT, id);
  	progress->reset();
  }
  kapp->processEvents(500);
}



void KNodeApp::setStatusHelpMsg(const char *text)
{
   statusBar()->message(text, 2000);
}


void KNodeApp::setCursorBusy(bool b=true)
{
	if(b) kapp->setOverrideCursor(waitCursor);
	else  kapp->restoreOverrideCursor();
}






//========================================================================
//============================ INIT && UPDATE ============================
//========================================================================


 void KNodeApp::initMenuBar()
{
	

  //file
  file_menu = new QPopupMenu();
  file_menu->insertItem(i18n("&Save as.."), ID_FILE_SAVEAS);
 	file_menu->setItemEnabled(ID_FILE_SAVEAS,false);
  file_menu->insertItem(i18n("&Print"), ID_FILE_PRINT);
  file_menu->insertItem(i18n("&Connect"), ID_FILE_CON);
  file_menu->insertSeparator();
  file_menu->insertItem(i18n("&Download all"), ID_FILE_DLALL);
  file_menu->insertSeparator();
  file_menu->insertItem(i18n("E&xit"),ID_FILE_EXIT);


  //groups
  groups_menu=new QPopupMenu();
 	groups_menu->insertItem(i18n("&get new headers"), ID_GET_NEW_HDRS);
 	groups_menu->insertItem(i18n("expire now"), ID_EXPNOW);
 	groups_menu->insertSeparator();
 	groups_menu->insertItem(i18n("&subscribe"), ID_ALL_GROUPS);
 	groups_menu->insertItem(i18n("&unsubscribe"), ID_UNSUBSCRIBE);
 	groups_menu->insertSeparator();
 	groups_menu->insertItem(i18n("mark all as &read"), ID_ALL_READ);
 	groups_menu->insertItem(i18n("mark all as u&nread"), ID_ALL_UNREAD);
 	groups_menu->insertSeparator();
 	
 	
 	
 	//folders
 	groups_menu_folders=new QPopupMenu();
 	groups_menu_folders->insertItem(i18n("em&pty folder"), ID_EMPTY_FOLDER);
 	groups_menu->insertItem(i18n("&folders"), groups_menu_folders, ID_FOLDERS);



  //message
  message_menu=new QPopupMenu();
  message_menu->insertItem(i18n("&new message"), ID_NEW_MSG);
  message_menu->insertItem(i18n("post &reply"), ID_POST_REPL);
  message_menu->insertItem(i18n("&mail reply"), ID_MAIL_REPL);
  message_menu->insertSeparator();

  //mark as
  message_menu_mark=new QPopupMenu();
  message_menu_mark->insertItem(i18n("as read"), ID_MARK_READ);
  message_menu_mark->insertItem(i18n("as unread"), ID_MARK_UNREAD);
  message_menu->insertItem(i18n("mar&k"), message_menu_mark, ID_MARK);
  	
 	//thread
 	message_menu_thread=new QPopupMenu();
 	message_menu_thread->insertItem(i18n("mark as read"), ID_THR_READ);
 	message_menu_thread->insertItem(i18n("mark as unread"), ID_THR_UREAD);
 	message_menu_thread->insertItem(i18n("set score"), ID_THR_SCORE);
 	message_menu->insertItem(i18n("&thread"), message_menu_thread, ID_THREAD);
 	message_menu->insertSeparator();
 		
 	//own messages
 	message_menu->insertItem(i18n("&edit"), ID_OMSG_EDIT);
 	message_menu->insertItem(i18n("&delete"), ID_OMSG_DEL);
 	
 	message_menu_send=new QPopupMenu();
 	message_menu_send->insertItem(i18n("&outbox"), ID_SEND_OUTB);
 	message_menu_send->insertItem(i18n("&now"), ID_OMSG_SEND_NOW);
 	message_menu_send->insertItem(i18n("&later"), ID_OMSG_SEND_LAT);
 	message_menu->insertItem(i18n("&send"), message_menu_send, ID_SEND);
 	
 	
 	//goto
 	goto_menu=new QPopupMenu();
 	goto_menu->insertItem(i18n("&next article"), ID_NEXT_ART);
 	goto_menu->insertItem(i18n("&previous article"), ID_PREV_ART);
 	goto_menu->insertSeparator(); 	
 	goto_menu->insertItem(i18n("next unread &article"), ID_NEXT_UNRART);
 	goto_menu->insertItem(i18n("next unread &thread"), ID_NEXT_THR);


 	

  //view
  view_menu = new QPopupMenu();
  view_menu->setCheckable(true);

  view_menu->insertItem(i18n("show th&reads"), ID_SHOW_THR);
  view_menu->insertItem(i18n("&expand all"), ID_EXP_ALL);
  view_menu->insertItem(i18n("&collapse all"), ID_COL_ALL);
  view_menu->insertItem(i18n("&refresh"), ID_REFRSH);
  view_menu->insertSeparator();

  view_menu_hdr = new QPopupMenu();
  view_menu_hdr->setCheckable(true);
  view_menu_hdr->insertItem(i18n("&short"), ID_SHOW_SHORT_HDR);
  view_menu_hdr->insertItem(i18n("&normal"), ID_SHOW_NORM_HDR);
  view_menu_hdr->setItemChecked(ID_SHOW_NORM_HDR, true);
  view_menu_hdr->insertItem(i18n("&all"), ID_SHOW_ALL_HDR);
  view_menu->insertItem(i18n("&headers"), view_menu_hdr, ID_SHOW_HDRS);

  view_menu->insertItem(i18n("&Filter"), FiManager->pUpMenu(), ID_FILTER);

  view_menu_sort=new QPopupMenu();
  view_menu_sort->setCheckable(true);
  view_menu_sort->insertItem(i18n("subject"), 0);
  view_menu_sort->insertItem(i18n("from"), 1);
  view_menu_sort->insertItem(i18n("score"), 2);
  view_menu_sort->insertItem(i18n("date"), 3);
  view_menu->insertItem(i18n("So&rt"), view_menu_sort, ID_SORT);


  view_menu->insertSeparator();
  view_menu->insertItem(i18n("&Statusbar"), ID_SHOW_STATB);

  view_menu->insertItem(i18n("&Toolbar"), ID_SHOW_TOOLB0);



	//settings
	settings_menu=new QPopupMenu();
	settings_menu->insertItem(i18n("&Preferences"), ID_PREF);
	settings_menu->insertItem(i18n("&Filters"), ID_FILTERS);
	settings_menu->insertItem(i18n("&Key bindings"), ID_KEY_BIND);


	//help
  help_menu = new QPopupMenu();
  help_menu = kapp->getHelpMenu(true, i18n(
  "<<< KNode Version " VERSION " >>> \
  \n\
  \nHomepage : http://software.freepage.de/cthurner \
  \nAuthor : Christian Thurner , cthurner@freepage.de \
  \nThis is free software covered by the GPL." ));


  //other popups
  groupPopup = new QPopupMenu();
  groupPopup->insertItem(i18n("unsubscribe"), ID_UNSUBSCRIBE);
  groupPopup->insertSeparator();
  groupPopup->insertItem(i18n("mark all as read"), ID_ALL_READ);
 	groupPopup->insertItem(i18n("mark all as unread"), ID_ALL_UNREAD);

  folderPopup = new QPopupMenu();
  folderPopup->insertItem(i18n("empty folder"), ID_EMPTY_FOLDER);

  readPopup = new QPopupMenu();

  QPopupMenu *readPopupThr = new QPopupMenu();
  readPopupThr->insertItem(i18n("mark as read"), ID_THR_READ);
 	readPopupThr->insertItem(i18n("mark as unread"), ID_THR_UREAD);
 	readPopupThr->insertItem(i18n("set score"), ID_THR_SCORE);

  readPopup->insertItem(i18n("post reply"), ID_POST_REPL);
  readPopup->insertItem(i18n("mail reply"), ID_MAIL_REPL);
  readPopup->insertSeparator();
  readPopup->insertItem(i18n("mark as read"), ID_MARK_READ);
 	readPopup->insertItem(i18n("mark as unread"), ID_MARK_UNREAD);
 	readPopup->insertSeparator();
 	readPopup->insertItem(i18n("thread"), readPopupThr, ID_THREAD);

  postPopup = new QPopupMenu();
  postPopup->insertItem(i18n("edit"), ID_OMSG_EDIT);
 	postPopup->insertItem(i18n("delete"), ID_OMSG_DEL);
 	postPopup->insertSeparator();
 	postPopup->insertItem(i18n("send now"), ID_OMSG_SEND_NOW);
 	postPopup->insertItem(i18n("send later"), ID_OMSG_SEND_LAT);
 	
 	
#ifdef TEST  	
	//test
 	
	test_menu=new QPopupMenu;
	test_menu->insertItem("GroupListWidget", 10);
	test_menu->insertItem("GroupSelectDlg", 20);
	test_menu->insertItem("GroupDialog", 30);
	test_menu->insertItem("SenderDialog", 40);
	test_menu->insertItem("ServerOpt", 50);
	test_menu->insertItem("Opt", 60);
	test_menu->insertItem("FilterConf", 70);
	test_menu->insertItem("FilterList", 80);
	test_menu->insertItem("Keys", 90);
	test_menu->insertItem("Score", 100);
	test_menu->insertItem("next", 110);
	test_menu->insertItem("next thr", 120);
#endif	
	
	
	
	
	
	
	//init
	menuBar()->insertItem(i18n("&File"), file_menu);

  menuBar()->insertItem(i18n("&Group"), groups_menu);

  menuBar()->insertItem(i18n("&Message"), message_menu);

  menuBar()->insertItem(i18n("Go&to"), goto_menu);

  menuBar()->insertItem(i18n("&View"), view_menu);
 	
 	menuBar()->insertItem(i18n("&Options"), settings_menu);

  menuBar()->insertSeparator();
  menuBar()->insertItem(i18n("&Help"), help_menu);

#ifdef TEST
	menuBar()->insertItem("Test",test_menu);
 	connect(test_menu, SIGNAL(activated (int)), SLOT(TestCallback (int)));
#endif	
	
	//connect
	connect(file_menu, SIGNAL(activated (int)), SLOT(commandCallback (int)));

  connect(groups_menu, SIGNAL(activated (int)), SLOT(commandCallback (int)));
  connect(groups_menu_folders, SIGNAL(activated (int)), SLOT(commandCallback (int)));

  connect(message_menu, SIGNAL(activated (int)), SLOT(commandCallback (int)));
  connect(message_menu_thread, SIGNAL(activated (int)), SLOT(commandCallback (int)));
  connect(message_menu_mark, SIGNAL(activated (int)), SLOT(commandCallback (int)));
 	connect(message_menu_send, SIGNAL(activated (int)), SLOT(commandCallback (int)));

 	connect(goto_menu, SIGNAL(activated (int)), SLOT(commandCallback (int)));
 	
  connect(view_menu, SIGNAL(activated (int)), SLOT(commandCallback (int)));
  connect(view_menu_hdr, SIGNAL(activated (int)), SLOT(slotViewHeaders (int)));
  connect(view_menu_sort, SIGNAL(activated (int)), SLOT(slotViewSort (int)));

  connect(settings_menu, SIGNAL(activated (int)), SLOT(commandCallback (int)));

  connect(groupPopup, SIGNAL(activated (int)), SLOT(commandCallback (int)));
  connect(folderPopup, SIGNAL(activated (int)), SLOT(commandCallback (int)));
  connect(readPopup, SIGNAL(activated (int)), SLOT(commandCallback (int)));
  connect(readPopupThr, SIGNAL(activated (int)), SLOT(commandCallback (int)));
  connect(postPopup, SIGNAL(activated (int)), SLOT(commandCallback (int)));
  connect(postPopup, SIGNAL(aboutToShow()), SLOT(slotPopupAboutToShow()));

}



void KNodeApp::initToolBar()
{


  tb0=new KToolBar(this,0,32);
  addToolBar(tb0);

  tb0->insertButton(Icon("connect.xpm"),ID_FILE_CON, true, i18n("(dis-)connect"));
  tb0->insertButton(Icon("dlall.xpm"), ID_FILE_DLALL, true, i18n("download all new articles"));
  tb0->insertSeparator();
  tb0->insertSeparator();

  tb0->insertButton(Icon("newmsg.xpm"), ID_NEW_MSG, true, i18n("new message"));
  tb0->insertButton(Icon("reply.xpm"), ID_POST_REPL, true, i18n("post reply"));
  tb0->insertButton(Icon("remail.xpm"), ID_MAIL_REPL, true, i18n("mail reply"));
  tb0->insertSeparator();
  tb0->insertButton(Icon("nextart.xpm"), ID_NEXT_UNRART, true,
  	i18n("goto next unread article"));
  tb0->insertButton(Icon("nextthr.xpm"), ID_NEXT_THR, true,
  	i18n("goto next unread thread"));

  tb0->insertSeparator();
  tb0->insertButton(Icon("filter.xpm"),
  	ID_FILTER, FiManager->pUpMenu(), true, i18n("selects a filter"),-1);
  tb0->insertButton(Icon("refresh.xpm"), ID_REFRSH,
  	true, i18n("refresh the message list"));

  tb0->insertButton(Icon("grpdlg.xpm"), ID_ALL_GROUPS, true, i18n("newsgroups"));
  tb0->insertSeparator();
  tb0->insertSeparator();
  tb0->insertButton(Icon("settings.xpm"), ID_PREF, true, i18n("preferences"));
     	
 	connect(tb0,SIGNAL(clicked(int)),this,SLOT(commandCallback(int)));

}



void KNodeApp::initStatusBar()
{
	KStatusBar *sb=statusBar();
  progress=new QProgressBar(sb);
  progress->setLineWidth(1);

	sb->insertWidget(progress,100, SB_PROGR);
  sb->insertItem("MMMMMMMMMMMMMMMMMMMMMMMMMMMMM",SB_MAIN);
	sb->insertItem("",SB_GROUP);
	setStatusMsg();	
}



void KNodeApp::initView()
{

  KApplication *app=KApplication::getKApplication();
  view = new KNodeView(app, this);
  setView(view);

  connect(view->entryView, SIGNAL(selectionChanged(QListViewItem *)),
  	this, SLOT(slotEViewChanged(QListViewItem *)));
    	
  connect(view->hdrView, SIGNAL(selectionChanged(QListViewItem *)),
  	this, SLOT(slotHViewChanged(QListViewItem *)));
  	
  connect(view->hdrView, SIGNAL(doubleClicked(QListViewItem*)),
  	this, SLOT(slotHViewDClicked(QListViewItem*)));
  	
  connect(view->msgView, SIGNAL(referenceClicked(int)),
  	this, SLOT(slotReferenceClicked(int)));
  	
  connect(view->hdrView, SIGNAL(sortingChanged(int,int)),
  	this, SLOT(slotSortingChanged(int,int)));
  	
}



void KNodeApp::initAccel()
{
	acc=new KAccel(this);
	
	//stdAccels
	acc->insertStdItem(KAccel::Print);	
	acc->connectItem(KAccel::Print, this, SLOT(slotFilePrint()));
	
	acc->insertStdItem(KAccel::Quit);
	acc->connectItem(KAccel::Quit, this, SLOT(slotFileQuit()));
	
	
	//customAccels
	acc->insertItem("new message", "post", "P");
	acc->connectItem("post", this, SLOT(slotMsgNew()));
	
	acc->insertItem("post reply", "reply", "R");
	acc->connectItem("reply", this, SLOT(slotMsgReply()));
	
	acc->insertItem("mail reply", "remail", "A");
	acc->connectItem("remail", this, SLOT(slotMsgRemail()));
	
	acc->insertItem("mark as read", "mread", "D");
	acc->connectItem("mread", this, SLOT(slotMsgMarkRead()));
	
	acc->insertItem("mark as unread", "muread", "U");
	acc->connectItem("muread", this, SLOT(slotMsgMarkUnread()));
	
	acc->insertItem("mark thread as read", "mtread", "ALT+D");
	acc->connectItem("mtread", this, SLOT(slotMsgThrRead()));
	
	acc->insertItem("mark thread as uread", "mturead", "ALT+U");
	acc->connectItem("mturead", this, SLOT(slotMsgThrUnread()));
	
	acc->insertItem("set score", "score", "S");
	acc->connectItem("score", this, SLOT(slotMsgThrScore()));
	
	acc->insertItem("edit message", "edit", "T");
	acc->connectItem("edit", this, SLOT(slotMsgEdit()));
	
	acc->insertItem("delete message", "del", "Delete");
	acc->connectItem("del", this, SLOT(slotMsgDelete()));
	
	acc->insertItem("next article", "nxtart", "CTRL+Down");
	acc->connectItem("nxtart", this, SLOT(slotGotoNextArt()));
	
	acc->insertItem("next article", "prevart", "CTRL+Up");
	acc->connectItem("prevart", this, SLOT(slotGotoPrevArt()));
		
	acc->insertItem("next unread article", "nxtunrart", "Space");
	acc->connectItem("nxtunrart", this, SLOT(slotGotoNextUnreadArt()));
	
	acc->insertItem("next unread thread", "nxtthr", "CTRL+Space");
	acc->connectItem("nxtthr", this, SLOT(slotGotoNextThr()));
	
	acc->insertItem("refresh the message list", "refresh", "F5");
	acc->connectItem("refresh", this, SLOT(slotViewRefresh()));
	
	
	
	acc->readSettings();
	
	updateMenuAccels();
}



void KNodeApp::setMenusEnabled(int *ptr , bool e)
{
	int i=0;
	QString accel(10);
	
	while(ptr[i]!=-1) {
		menuBar()->setItemEnabled(ptr[i],e);
  	tb0->setItemEnabled(ptr[i],e);
  	
  	switch(ptr[i]) {
  		
  		case ID_POST_REPL: 		accel="reply";			break;
  		case ID_MAIL_REPL: 		accel="remail";			break;
  		case ID_MARK_READ: 		accel="mread";			break;
  		case ID_MARK_UNREAD: 	accel="muread";			break;
  		case ID_THR_READ:			accel="mtread";			break;
  		case ID_THR_UREAD:		accel="mturead";		break;
  		case ID_THR_SCORE:		accel="score";			break;
  		case ID_OMSG_EDIT:		accel="edit";				break;
  		case ID_OMSG_DEL:			accel="del";				break;
  		case ID_NEXT_ART:			accel="nxtart";			break;
  		case ID_PREV_ART:			accel="prevart";		break;
  		case ID_NEXT_UNRART:	accel="nxtunrart";	break;
  		case ID_NEXT_THR:			accel="nxtthr";			break;
  		case ID_REFRSH:				accel="refresh";		break;
  		default:							accel="";						break;
  	}
  	
  	if(!accel.isEmpty()) acc->setItemEnabled(accel, e);
  	
  	i++;
  }		
	
}



void KNodeApp::ViewToolBar()
{

  bViewToolbar=!bViewToolbar;
  menuBar()->setItemChecked(ID_SHOW_TOOLB0, bViewToolbar);
  enableToolBar(KToolBar::Toggle,0);
  setStatusMsg(SB_DEFLT);
}



void KNodeApp::ViewStatusBar()
{
  bViewStatusbar=!bViewStatusbar;
  menuBar()->setItemChecked(ID_SHOW_STATB, bViewStatusbar);
  enableStatusBar();
  setStatusMsg(SB_DEFLT);
}



void KNodeApp::updateMenuAccels()
{
	//std Accels
	acc->changeMenuAccel(file_menu, ID_FILE_PRINT, KAccel::Print);
	acc->changeMenuAccel(file_menu, ID_FILE_EXIT, KAccel::Quit);
	
	//custom Accels
	acc->changeMenuAccel(message_menu, ID_NEW_MSG, "post");
	acc->changeMenuAccel(message_menu, ID_POST_REPL, "reply");
	acc->changeMenuAccel(message_menu, ID_MAIL_REPL, "remail");
	acc->changeMenuAccel(message_menu_mark, ID_MARK_READ, "mread");
	acc->changeMenuAccel(message_menu_mark, ID_MARK_UNREAD, "muread");
	acc->changeMenuAccel(message_menu_thread, ID_THR_READ, "mtread");
	acc->changeMenuAccel(message_menu_thread, ID_THR_UREAD, "mturead");
	acc->changeMenuAccel(message_menu_thread, ID_THR_SCORE, "score");
	acc->changeMenuAccel(message_menu, ID_OMSG_EDIT, "edit");
	acc->changeMenuAccel(message_menu, ID_OMSG_DEL, "del");
	acc->changeMenuAccel(goto_menu, ID_NEXT_ART, "nxtart");
	acc->changeMenuAccel(goto_menu, ID_PREV_ART, "prevart");
	acc->changeMenuAccel(goto_menu, ID_NEXT_UNRART, "nxtunrart");
	acc->changeMenuAccel(goto_menu, ID_NEXT_THR, "nxtthr");
	acc->changeMenuAccel(view_menu, ID_REFRSH, "refresh");		
}


void KNodeApp::saveOptions()
{
	QStrList lst;
	lst.setAutoDelete(true);
  KConfig *conf=CONF();
     	
  conf->setGroup("APPEARANCE");

  //main window
  conf->writeEntry("WSize", this->size());


  conf->writeEntry("ShowTBar0",tb0->isVisible());
  conf->writeEntry("ShowStatusbar",statusBar()->isVisible());
  conf->writeEntry("MenuBarPos", (int)menuBar()->menuBarPos());
  conf->writeEntry("TBar0_Pos", (int)tb0->barPos());

  //view
  conf->writeEntry("Sep1_Pos", view->sepPos(1));
  conf->writeEntry("Sep2_Pos", view->sepPos(2));
  view->headersSize(&lst);
  conf->writeEntry("Hdrs_Size", lst);
  conf->writeEntry("sortCol", view->hdrView->sortColumn());
  conf->writeEntry("sortAscending", view->hdrView->ascending());

  conf->setGroup("READNEWS");

  KNMessageFilter *f=FiManager->currentFilter();
  int id=-1;

  if(f) id=f->id();

  conf->writeEntry("lastFilterID", id);

  acc->writeSettings();

}



void KNodeApp::readOptions()
{
   	QStrList lst;
		lst.setAutoDelete(true);
   	
   	KConfig *conf=CONF();   	
   	conf->setGroup("APPEARANCE");
  	
   	//main window
    QSize s(600,400);
   	this->resize(conf->readSizeEntry("WSize", &s));
  	
  	bViewToolbar = conf->readBoolEntry("ShowTBar0", true);
  	bViewStatusbar = conf->readBoolEntry("ShowStatusbar", true);
  	
  	
  	menu_bar_pos = (KMenuBar::menuPosition)
  		conf->readNumEntry("MenuBarPos", KMenuBar::Top);
  	
  	tool_bar_pos = (KToolBar::BarPosition)
  		conf->readNumEntry("TBar0_Pos", KToolBar::Top);
  	
  		
  	//view
  	view->setSepPos(1, conf->readNumEntry("Sep1_Pos",25));
  	view->setSepPos(2, conf->readNumEntry("Sep2_Pos",50));	
  	conf->readListEntry("Hdrs_Size", lst);
  	if(lst.count()>0) view->setHeadersSize(&lst);
  	int sortCol=conf->readNumEntry("sortCol",0);
  	view->hdrView->setSorting(sortCol, conf->readBoolEntry("sortAscending", true));
  	view_menu_sort->setItemChecked(sortCol, true);
  	
  	
  	conf->setGroup("READNEWS");
  	FiManager->setFilter(conf->readNumEntry("lastFilterID", 0));
  	AManager->slotFilterChanged(FiManager->currentFilter());	
  	
  		
  	
}




//========================================================================
//================================ DIALOGS ===============================
//========================================================================


void KNodeApp::showOptionsDialog()
{
	KNOptionsDialog *odlg=new KNOptionsDialog(this);
	
		
	if(odlg->exec()) {
	
		if(odlg->server()) {
			odlg->server()->applyConfig();
			Client->readConfig();
			PManager->readConfig();
		}
		
		if(odlg->read()) {
			odlg->read()->applyConfig();
			GManager->readConfig();
			AManager->readConfig();
			view->msgView->readConfig();
		}
		
		if(odlg->post()) {
			odlg->post()->applyConfig();
			PManager->readConfig();
		}
		
		if(odlg->fntColor()) {
			odlg->fntColor()->applyConfig();
			view->msgView->readConfig();
			view->msgView->updateContents();
		}		
	}		
	
	delete odlg;
}



void KNodeApp::showKeyDialog()
{
	if(KKeyDialog::configureKeys(acc,false)) updateMenuAccels();
}





//========================================================================
//================================ SLOTS =================================
//========================================================================


//============== CALLBACK ==============

void KNodeApp::commandCallback(int id_)
{
	

	
	switch(id_)
	{
		
		//file
		case ID_FILE_EXIT:	slotFileQuit();	break;
				
		case ID_FILE_CON:
			if(Client->isConnected()) Client->cmdDisconnect();
			else Client->cmdConnect();
		break;
		
		case ID_FILE_DLALL: GManager->checkAll(); break;
		
		case ID_FILE_PRINT: slotFilePrint(); break;		
		
		//groups
		case 	ID_GET_NEW_HDRS:	
			GManager->current()->checkForNewHdrs();
			AManager->showHdrs();
		break;
		
		case ID_EXPNOW:
			GManager->expireCurrentNow();
			slotHViewChanged(0);
		break;
		
		case	ID_ALL_GROUPS:		
			GManager->showGroupDialog();
			if(GManager->current()==0) slotEViewChanged(0);
		break;
		
		case 	ID_UNSUBSCRIBE:			
			if(MBox(yn,i18n("Do you really want to unsubscribe this group?"))==1) {
			 GManager->unsubscribe();
			 slotEViewChanged(0);
			}
		break;
		
		case	ID_ALL_READ:			AManager->setAllHdrsRead(); break;
		
		case 	ID_ALL_UNREAD:		AManager->setAllHdrsRead(false); break;
			
		
		//folders
		case ID_EMPTY_FOLDER:		FoManager->emptyFolder(); slotHViewChanged(0); break;
		
		case ID_SEND_OUTB:			PManager->sendAllInOutbox(); break;		
		
		//message
		case	ID_NEW_MSG:				slotMsgNew(); 				break;
		
		case	ID_POST_REPL:			slotMsgReply();				break;
		
		case 	ID_MAIL_REPL:			slotMsgRemail();			break;
				
		case 	ID_MARK_READ:			slotMsgMarkRead(); 		break;
		
		case 	ID_MARK_UNREAD:		slotMsgMarkUnread(); 	break;
		
		
		case ID_THR_READ:				slotMsgThrRead(); 		break;
		
		case ID_THR_UREAD:			slotMsgThrUnread(); 	break;
		
		case ID_THR_SCORE:			slotMsgThrScore(); 		break;
		
		case	ID_OMSG_EDIT:			slotMsgEdit();			  break;
				
		case 	ID_OMSG_DEL:			slotMsgDelete();      break;
		
		case 	ID_OMSG_SEND_NOW:	
			PManager->sendMsg();
			slotHViewChanged(view->hdrView->currentItem());
		break;
		
		case	ID_OMSG_SEND_LAT:	
			PManager->sendMsg(0, false);
			slotHViewChanged(view->hdrView->currentItem());
		break;
		
		
		//goto
		case ID_NEXT_ART:				slotGotoNextArt(); 	break;
		
		case ID_PREV_ART:				slotGotoPrevArt(); 	break;
				
		case ID_NEXT_UNRART:		slotGotoNextUnreadArt(); 	break;
		
		case ID_NEXT_THR:				slotGotoNextThr();	break;
					
				
		//view
		case ID_SHOW_THR:
			AManager->toggleThreaded();
			view_menu->setItemChecked(ID_SHOW_THR, AManager->threaded());
			slotHViewChanged(0);
		break;
		
		case ID_EXP_ALL:				AManager->expandAllHdrs(true); break;
					
		case ID_COL_ALL:				AManager->expandAllHdrs(false); break;
							
		case ID_SHOW_STATB:			ViewStatusBar(); break;
		
		case ID_SHOW_TOOLB0:		ViewToolBar(); break;		
	  	
		case ID_REFRSH:					slotViewRefresh(); break;		
		
		
		//settings
		case	ID_PREF: 					showOptionsDialog(); break;
		
		case	ID_FILTERS:				FiManager->showDialog(); break;
		
		case ID_KEY_BIND:				showKeyDialog(); break;
		
	}
	
	
	
	
	
}		                   		




//============= FILE-MENU ===============

void KNodeApp::slotFileQuit()
{
  cleanup();
  KTMainWindow::deleteAll();
  kapp->quit();
}



void KNodeApp::slotFilePrint()
{
	view->msgView->printContents();
}



//============= MESSAGE-MENU ===============

void KNodeApp::slotMsgNew()
{
	PManager->newMsg();
}



void KNodeApp::slotMsgReply()
{
	PManager->replyMsg(KNPostHeader::Post);
}



void KNodeApp::slotMsgRemail()
{
	PManager->replyMsg(KNPostHeader::Mail);
}



void KNodeApp::slotMsgMarkRead()
{
	AManager->setCurrentHdrRead();
	AManager->stopTimer();
}



void KNodeApp::slotMsgMarkUnread()
{
	AManager->setCurrentHdrRead(false);
	AManager->stopTimer();
}



void KNodeApp::slotMsgThrRead()
{
	AManager->setCurrentThreadRead(true);
}



void KNodeApp::slotMsgThrUnread()
{
	AManager->setCurrentThreadRead(false);
}



void KNodeApp::slotMsgThrScore()
{
	AManager->setScoreOfThread();
}



void KNodeApp::slotMsgEdit()
{
	PManager->editCurrent();
	if(PManager->current()==0) slotHViewChanged(0);
}



void KNodeApp::slotMsgDelete()
{
	PManager->removeMsg();
	slotHViewChanged(0);
}



void KNodeApp::slotGotoNextArt()
{
	view->nextHdr();
}



void KNodeApp::slotGotoPrevArt()
{
	view->prevHdr();
}



void KNodeApp::slotGotoNextUnreadArt()
{
	view->nextUnreadHdr();
}



void KNodeApp::slotGotoNextThr()
{
	view->nextUnreadThread();
}



void KNodeApp::slotViewHeaders(int id)
{
	KNMsgView::HeaderType hType=view->msgView->HType();
	
	switch(id) {
		case ID_SHOW_SHORT_HDR:	hType=KNMsgView::Short; break;
		
		case ID_SHOW_NORM_HDR:	hType=KNMsgView::Normal; break;
		
		case ID_SHOW_ALL_HDR:		hType=KNMsgView::All; break;
	};
			
	
	if(hType!=view->msgView->HType()) {
		view->msgView->setHType(hType);
		view->msgView->updateContents();
	
		view_menu_hdr->setItemChecked(ID_SHOW_SHORT_HDR, (hType==KNMsgView::Short));
		view_menu_hdr->setItemChecked(ID_SHOW_NORM_HDR, (hType==KNMsgView::Normal));
		view_menu_hdr->setItemChecked(ID_SHOW_ALL_HDR, (hType==KNMsgView::All));
	}	
		
}



void KNodeApp::slotViewSort(int id)
{
	//view_menu_sort->setItemChecked(view->hdrView->sortColumn(), false);
	view->hdrView->slotSortList(id);
	//view_menu_sort->setItemChecked(id, true);	
}



void KNodeApp::slotViewRefresh()
{
	AManager->showHdrs();
	slotHViewChanged(0);
}

  	


//==================== VIEW-SLOTS ======================

void KNodeApp::slotEViewChanged(QListViewItem *it)
{
	
	static int gids[]={	ID_UNSUBSCRIBE , ID_ALL_READ, ID_ALL_UNREAD,
											ID_SHOW_THR, ID_GET_NEW_HDRS, ID_FILTER,
											ID_REFRSH, ID_EXPNOW, ID_EXP_ALL, ID_COL_ALL, -1 };

  static int fids[]={	ID_EMPTY_FOLDER, ID_FOLDERS, -1 };	

  view->hdrView->clear();
	kapp->processEvents();
    	
	KNEntryBase *en=0;
	bool gm=false, fm=false;
	QString msg;
	
	QPopupMenu *menu=0;
	
	if(it) {
		
		setCursorBusy();
	
		en = ((KNEntryViewItem*) it)->entry;
		
		if(en->Type()==KNEntryBase::group) {
			
			view->hdrView->header()->setLabel(1,i18n("From"));
			view->hdrView->setRootIsDecorated(true);
			gm=GManager->setCurrent(en);
			FoManager->setCurrent(0);
			if(gm) {
				menu=groupPopup;
				view_menu->setItemChecked(ID_SHOW_THR, AManager->threaded());
			}
		}
		
		else {
			
			fm=FoManager->setCurrent(en);
			GManager->setCurrent(0);
			view->hdrView->header()->setLabel(1,i18n("Newsgroups / To"));
			view->hdrView->setRootIsDecorated(false);
			if(fm) menu=folderPopup;
				
		}	
	
		setCursorBusy(false);
	}
	
	view->setEntryMenu(menu);
	setMenusEnabled(gids, gm);
	setMenusEnabled(fids, fm);
	
	if(!gm && !fm) setStatusMsg("", SB_GROUP);
		
			
	slotHViewChanged(0);
		
	
}



void KNodeApp::slotHViewChanged(QListViewItem *it)
{
	

	static int rids[]={	ID_POST_REPL, ID_MAIL_REPL, ID_MARK_READ,
											ID_MARK_UNREAD, ID_THR_READ, ID_THR_UREAD,
											ID_NEXT_ART, ID_PREV_ART, ID_NEXT_UNRART,
											ID_NEXT_THR, ID_THR_SCORE, -1 };
	
	static int pids[]={	ID_OMSG_DEL, ID_OMSG_EDIT, ID_OMSG_SEND_NOW,
											ID_OMSG_SEND_LAT, -1	};
	
	KNHeaderBase *hdr=0;
	bool rm=false, pm=false;
	QPopupMenu *menu=0;
	
	
	if(it) {
		
			
		hdr = ((KNHdrViewItem *)it)->entry;
		
		kapp->processEvents();		
		if(hdr->Type()==KNHeaderBase::readHdr) {
			
			rm=AManager->setCurrentHdr(hdr);
						
			if(rm) {
				menu=readPopup;
				AManager->startTimer();
				view->msgView->showMsg(hdr);
			}
			else view->msgView->slotStatusMsg(i18n(
			"<b><font size=+1>sorry, article could not be retrieved</b></font>"));
		}
				
		else {
			
			pm=PManager->setCurrent(hdr);
						
			if(pm) {
				menu=postPopup;
			  AManager->stopTimer();
			  view->msgView->showMsg(hdr);
			}
			
		}
	  		
	}
	else {
		AManager->stopTimer();
		view->msgView->showBlankPage();
		if(view->hdrView->currentItem()) view->hdrView->currentItem()->setSelected(false);
		view->hdrView->setCurrentItem(0);
	}
	
	setMenusEnabled(rids, rm);
	setMenusEnabled(pids, pm);
	view->setHdrMenu(menu);
	
	//view->msgView->showMsg(hdr);
}
	




void KNodeApp::slotHViewDClicked(QListViewItem *it)
{
	if(it) {
		KNHeaderBase *hdr=((KNHdrViewItem*)it)->entry;
		
		if(hdr->Type()==KNHeaderBase::postHdr)
			PManager->editCurrent();
	}
}



void KNodeApp::slotReferenceClicked(int refNr)
{
	KNReadHeader *cur=AManager->currentHdr();
	QString refMID=cur->references[refNr];
	
	if(AManager->setCurrentHdr(refMID)) {
		view->hdrView->setSelected(AManager->currentHdr()->item, true);
		view->hdrView->ensureItemVisible(AManager->currentHdr()->item);
		//setStatusMsg(GManager->current()->statusString(), SB_GROUP);
	}		
		
	else {
		view->hdrView->setCurrentItem(0);
		view->msgView->slotStatusMsg(
			i18n("<b><font size=+1>sorry, article could not be retrieved</b></font>"));
	}

	
}



void KNodeApp::slotSortingChanged(int oldCol, int newCol )
{
	view_menu_sort->setItemChecked(oldCol, false);
	view_menu_sort->setItemChecked(newCol, true);
}




//======================= OTHER SLOTS ========================

void KNodeApp::slotConnection(bool c)
{
	if(c) {
		//led->on();
		menuBar()->changeItem(i18n("Dis&connect"), ID_FILE_CON);
		tb0->setButtonPixmap(ID_FILE_CON,Icon("disconnect.xpm"));
	
	}
	else {
		//led->off();
		menuBar()->changeItem(i18n("&Connect"), ID_FILE_CON);
		tb0->setButtonPixmap(ID_FILE_CON,Icon("connect.xpm"));
	}

}



void KNodeApp::slotPopupAboutToShow()
{
	const QObject *sender=this->sender();
	
	if(sender==postPopup) {
		if(FoManager->current()==FoManager->outbox() ||
			FoManager->current()==FoManager->sent() ) {
			
			menuBar()->setItemEnabled(ID_OMSG_SEND_LAT, false);
			postPopup->setItemEnabled(ID_OMSG_SEND_LAT, false);
		
			if(FoManager->current()==FoManager->sent()) {
				menuBar()->setItemEnabled(ID_OMSG_SEND_NOW, false);
				postPopup->setItemEnabled(ID_OMSG_SEND_NOW, false);
				menuBar()->setItemEnabled(ID_OMSG_EDIT, false);
				postPopup->setItemEnabled(ID_OMSG_EDIT, false);
			}
		}
	
		else {
			postPopup->setItemEnabled(ID_OMSG_SEND_NOW,true);
			postPopup->setItemEnabled(ID_OMSG_SEND_LAT,true);
			postPopup->setItemEnabled(ID_OMSG_EDIT,true);
		}
	}
}





//========================================================================
//================================ OTHERS ================================
//========================================================================


void KNodeApp::cleanup()
{
	saveOptions();
  GManager->saveYourself();
	FoManager->saveYourself();
}



bool KNodeApp::queryExit()
{
	cleanup();	
	return true;
}




	




// ============= DEBUG ==============

#ifdef TEST


#include "kngrouplistwidget.h"
#include "kngroupselectdialog.h"
#include "kngroupdialog.h"
#include "knsenderdialog.h"
#include "knserveroptions.h"
#include "knoptionsdialog.h"
#include "knfilterdialog.h"
#include "knfiltermanager.h"
#include "knscoredialog.h"

#endif


void KNodeApp::TestCallback(int id_)
{

#ifdef TEST


	KNGroupListWidget *glw;
	KNGroupSelectDialog *gsd;
	KNGroupDialog *gdlg;
	KNSenderDialog *sdlg;
	KNServerOptions *sopt;
	KNOptionsDialog *opdl;
	KNFilterDialog *fconf;
	KNFilterListDialog *fld;
	KNMessageFilter *f;
	KNScoreDialog *sc;
	
	switch(id_) {
		
	
		case 10:
			glw=new KNGroupListWidget(0,0,groupNames());
			glw->show();
		break;
		
		case 20:
			gsd=new KNGroupSelectDialog();
			gsd->exec();
			delete gsd;
		break;
		
		case 30:
			gdlg=new KNGroupDialog(this);
			gdlg->exec();
			delete gdlg;
		break;
		
		case 40:
			sdlg=new KNSenderDialog(this);
			sdlg->exec();
			delete sdlg;
		break;
		
		case 50:
			sopt=new KNServerOptions();
			sopt->show();
		break;
		
		case 60:
			opdl=new KNOptionsDialog(this);
			opdl->exec();
			delete opdl;
		break;
		
		case 70:
			/*f=new KNMessageFilter();
			fconf=new KNFilterDialog(this,0,f);
			fconf->exec();
			delete fconf;
			delete f;*/
		break;
		
		case 80:
			fld=new KNFilterListDialog(this);
			fld->show();
		break;
		
		case 90:
			KKeyDialog::configureKeys(acc);
		break;
		
		case 100:
			sc=new KNScoreDialog(50, this);
			sc->exec();
			delete sc;
		break;
		
		case 110: AManager->expandAllHdrs(true); break;
		
		case 120: AManager->expandAllHdrs(false); break;		
	}
#endif
}


















































































































































































































































































































































































