/***************************************************************************
                     knmsgview.cpp - description
 copyright            : (C) 1999 by Christian Thurner
 email                : cthurner@freepage.de
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <qstring.h>
#include <stdio.h>
#include <string.h>
#include <kcursor.h>
#include <qclipboard.h>
#include <qkeycode.h>
#include <kfm.h>
#include "knmsgview.h"
#include "knreadmessage.h"
#include "knpostheader.h"
#include "knreadheader.h"
#include "knglobals.h"




KNMsgView::KNMsgView(QWidget *parent=0, const char *name=0) :
	QWidget(parent,name)
{
	current=0;
	
	
		
	html=new KNHtml(this);
	readConfig();
	html->setFixedFont("fixed");
	html->setURLCursor(KCursor::handCursor());
  	
	hScrollBar=new QScrollBar(QScrollBar::Horizontal,this);
	vScrollBar=new QScrollBar(QScrollBar::Vertical,this);
	
	connect(html, SIGNAL(onURL(const char*)), this, SLOT(slotOnURL(const char*)));
	connect(html, SIGNAL(URLSelected(const char*, int)), this,
		SLOT(slotURLSelected(const char*, int)));
	connect(html, SIGNAL(clicked()), this, SLOT(slotClicked()));
	connect(vScrollBar, SIGNAL(valueChanged(int)), html, SLOT(slotScrollVert(int)));
	connect(hScrollBar, SIGNAL(valueChanged(int)), html, SLOT(slotScrollHorz(int)));
	connect(html, SIGNAL(documentChanged()), this, SLOT(slotDocChanged()));
	connect(html, SIGNAL(textSelected(bool)), this, SLOT(slotTextSelected(bool)));
	setHType(Normal);
	
	this->setFocusPolicy(QWidget::StrongFocus);	
}



KNMsgView::~KNMsgView()
{
}



void KNMsgView::readConfig()
{
  KConfig *c=CONF();
  QString fnt;

  c->setGroup("READNEWS");
	showSig=c->readBoolEntry("showSig",true);
	
	c->setGroup("FONTS-COLORS");
	
	fnt= c->readEntry("family", "helvetica");
	if(!fnt.isEmpty()) html->setStandardFont(fnt);
	//html->setStandardFont(c->readEntry("family", "helvetica"));
	sizeB=c->readNumEntry("sizeBase", 3);
	html->setDefaultFontBase(sizeB);
	
	sizeS=c->readNumEntry("sizeSubj", 1);
	
	QColor cArr[3], col, b(black), w(white), g(gray);
	
	char colEntry[10], colHex[10];
		
	for(int i=0; i<7; i++) {
		sprintf(colEntry,"color%d", i+1);
		
		if(i<2) cArr[i]=c->readColorEntry(colEntry, &b);
		else if(i==2) cArr[i]=c->readColorEntry(colEntry, &w);
		else {
			if(i==3) col=c->readColorEntry(colEntry, &g);
			else col=c->readColorEntry(colEntry, &b);
			sprintf(colHex, "#%2x%2x%2x", col.red(), col.green(), col.blue());
			hexColors[i-3]=colHex;
		}
	}	
	
	html->setDefaultTextColors(cArr[0], cArr[1], cArr[1]);
	html->setDefaultBGColor(cArr[2]);
	
}



void KNMsgView::resizeEvent(QResizeEvent*)
{
	html->setGeometry(0,0,width()-16,height()-16);
	hScrollBar->setGeometry(0,height()-16,width()-16,16);
	vScrollBar->setGeometry(width()-16, 0, 16, height()-16);
	hScrollBar->setSteps( 12, html->width() - 12 );
  vScrollBar->setSteps( 12, html->height() - 12 );
}



void KNMsgView::keyPressEvent(QKeyEvent *e)
{
	switch(e->key()) {
	
		case Key_PageDown: 	vScrollBar->addPage(); break;
		
		case Key_PageUp:		vScrollBar->subtractPage(); break;
		
		case Key_Up:				vScrollBar->subtractLine(); break;
		
		case Key_Down:			vScrollBar->addLine(); break;
		
		case Key_Home:			vScrollBar->setValue(vScrollBar->minValue()); break;
		
		case Key_End:				vScrollBar->setValue(vScrollBar->maxValue()); break;
		
		
		default: e->ignore();
	};
}



void KNMsgView::slotClicked()
{
	if(!this->hasFocus()) this->setFocus();
}



void KNMsgView::slotOnURL(const char *url)
{
	if(url) debug("%s\n",url);
}



void KNMsgView::slotURLSelected(const char *_url, int btn)
{
	QString url=_url, type, target;
	int pos=url.find(':');
	
	
	if(pos!=-1) {
		
		type=url.left(pos);
		
		if(type=="http" || type=="ftp") {
			KFM kfm;
			kfm.openURL(url);
		}
		
		
		
		else {
			target=url.mid(pos+1, url.length()-pos);
		  if(type=="mailto") emit mailTo(target.data());		
			else if(type=="news") emit referenceClicked(target.toInt());
		}
	}
	
}


void KNMsgView::slotDocChanged()
{
	if (html->docHeight() > (this->height()-16))
    		vScrollBar->setRange(0, html->docHeight() - (this->height()-16));
  	else vScrollBar->setRange(0, 0);

  	if (html->docWidth() > (this->width()-16))
    		hScrollBar->setRange(0, html->docWidth()-(this->width()-16));
  	else hScrollBar->setRange(0, 0);
}



bool KNMsgView::isValidURLChar(char c)
{
	static char invalid[]=" <>()\"|";
	bool ret=(strchr(invalid, c)==0);
	return ret;
		
}



QString KNMsgView::toHtmlString(const char* line, bool parseURLs=true)
{
	QString result(256), url(128);
	uint tmp, len;
	const char *start;
	

	len=strlen(line);
	
				
	for(uint idx=0; idx<len; idx++){
		switch(line[idx]) {
				
			case '<' : 	result+="&lt;"; break;
				
			case '>' : 	result+="&gt;"; break;
								
			case '&' : 	result+="&amp;"; break;
				
			case '"' : 	result+="&quot;"; break;
				
			case ' ' :	
				if(line[idx+1]==' ')  {
					tmp=idx;
					while(line[tmp]==' ') {
						result+="&nbsp;";
						tmp++;
					}
						idx=tmp-1;
				}
				else result+=" ";
			break;
			
			case 'h' :	
				if(parseURLs) {
					start=&line[idx];
					if(strncmp(start, "http://", 7)==0) {
						url="";
						for(tmp=idx; tmp<len; tmp++)
							if(!isValidURLChar(line[tmp])) break;
							else url+=line[tmp];
						result+="<a href=\"";	result+=url; result+="\">";
						result+=url; result+="</a>";
					  idx=tmp-1;					
					}
					else result+=line[idx];	
				}
				else result+=line[idx];
			break;							
			
			case 'w' :
				if(parseURLs) {
					start=&line[idx];
					if(strncmp(start, "www.", 4)==0) {
						url="";
						for(tmp=idx; tmp<len; tmp++)
							if(!isValidURLChar(line[tmp])) break;
							else url+=line[tmp];
						result+="<a href=\"http://"; result+=url;
						result+="\">"; result+=url;	result+="</a>";
						idx=tmp-1;
					}
					else result+=line[idx];
				}
				else result+=line[idx];
			break;											
			
			case 'f' :
				if(parseURLs) {
					start=&line[idx];
					if(strncmp(start, "ftp://", 6)==0) {
						url="";
						for(tmp=idx; tmp<len; tmp++)
							if(!isValidURLChar(line[tmp])) break;
							else url+=line[tmp];
						result+="<a href=\"";	result+=url; result+="\">";
						result+=url; result+="</a>";
						idx=tmp-1;
					}
					else if(strncmp(start, "ftp.", 4)==0) {
						url="";
						for(tmp=idx; tmp<len; tmp++)
							if(!isValidURLChar(line[tmp])) break;
							else url+=line[tmp];
						result+="<a href=\"ftp://"; result+=url;
						result+="\">"; result+=url;	result+="</a>";
						idx=tmp-1;
					}
					else result+=line[idx];	
				}
				else result+=line[idx];
			break;
			
			/*case 'm' :
				if(parseURLs) {
					start=&line[idx];
					if(strncmp(start, "mailto:", 7)==0) {
						url="";
						for(tmp=idx; tmp<len; tmp++)
							if(!isValidURLChar(line[tmp])) break;
							else url+=line[tmp];
						result+="<a href=\"";	result+=url; result+="\">";
						result+=url; result+="</a>";
						idx=tmp-1;
					}
					else result+=line[idx];	
				}
				else result+=line[idx];
			break;
			
			case '@' :
				if(parseURLs) {
					
					uint beg=idx;
					url="";
				
					while(1) {
						beg--;
						if(!isValidURLChar(line[beg])) break;
					}
				
					if(beg>0) beg++;
					else if(!isValidURLChar(line[beg])) beg++;
					
					
					for(tmp=beg; tmp<len; tmp++)
						if(!isValidURLChar(line[tmp])) break;
						else url+=line[tmp];	
				
						
					result.replace((result.length()-(idx-beg)), (idx-beg), "<a href=mailto:\"");	
					result+=url; result+="\">";
					result+=url; result+="</a>";
					idx=tmp-1;
				}
				else result+=line[idx];
			
			break;*/
				
					
				
						
			default  : result+=line[idx];
		}
		
	}					
			
	
	return result;
	
}



void KNMsgView::showBlankPage()
{
	html->begin();
	html->end();
	html->parse();
	current=0;
}



void  KNMsgView::updateContents()
{
	if(current) showMsg(current);
	else showBlankPage();
}



void KNMsgView::showMsg(KNHeaderBase *hdr)
{

	QString header, hinfo, buff;
	buff.resize(4096);
	
				
	if(!hdr) {
		showBlankPage();
		return;
	}
	else current=hdr;
	
	switch(hType) {
		
		case All:
			for(char *var=hdr->msgHead()->first(); var; var=hdr->msgHead()->next()){
				hinfo+=toHtmlString(var, false);
				hinfo+="<br>";
			}
		break;
		
		default:
			buff.sprintf("<font size=+%d><b>%s</b></font><br>", sizeS,
				toHtmlString(hdr->subject, false).data());
			hinfo+=buff;
	
			QString tmp;
			if(hdr->replyTo.length()>2) tmp=hdr->replyTo;   //should be enough
			else tmp=hdr->email;
						
	    buff.sprintf("<b>%s:</b> <a href=\"mailto:%s\">%s</a><br>",i18n("From"),
			toHtmlString(tmp, false).data(), toHtmlString(hdr->from, false).data() );
			hinfo+=buff;
	
	    if(hType==Normal) {
	
	      if(hdr->hasGroups()) {
	      	buff.sprintf("<b>%s:</b> %s<br>",
	      	i18n("Newsgroup(s)"),toHtmlString(((KNPostHeader*)hdr)->groups, false).data());
	     		hinfo+=buff;
	     	}
	       	
	      buff.sprintf("<b>%s:</b> %s<br><b>%s:</b> %d",i18n("Date"),
	      	hdr->tString().data(),i18n("Lines"),hdr->lines);
		
		    hinfo+=buff;
			}
	}
	
	buff.sprintf("<table width=\"100%%\" cellpadding=2><tr><td width=50 bgcolor=\"%s\">&nbsp;</td><td>",
		hexColors[FG_COL].data());					
	header+=buff;
	header+=hinfo;
	buff.sprintf("</td></tr><tr><td colspan=2 bgcolor=\"%s\">", hexColors[FG_COL].data());
	header+=buff;
				
	if(hdr->hasReferences()) {
		
		header+="<b>";
		header+=i18n("References: ");
		header+="</b>";
		
		KNReadHeader *rHdr=(KNReadHeader*)hdr;
				
		for(int refCnt=0; refCnt<5; refCnt++)
			if(!rHdr->references[refCnt].isNull()) {
			buff.sprintf("<a href=\"news:%d\">%d</a>&nbsp;",
			refCnt, refCnt+1);
			header+=buff;
		}
				
	}
			
	else header+=i18n("no references");
		
	header+="</td></tr></table><br><br>";
		
	html->slotScrollVert(0);
	vScrollBar->setValue(0);
	
	html->begin();
	html->parse();
	html->write("<html><head>");
	html->write(header);
	html->write("</head>");
	
	if(hdr->Message()->isHtml())
		for(char *var=hdr->msgBody()->first(); var;
			var=hdr->msgBody()->next())	html->write(var);
	else {
		html->write("<body>");
		
		QString result, tmpQuotCol;
		char firstChar;
		int oldLevel=0, newLevel=0;
		uint idx=0;
		buff="";	
		
		for(char *var=hdr->msgBody()->first(); var; var=hdr->msgBody()->next()) {
			
			if(strcmp(var,"-- ")==0)
				if(showSig) {
					result+="<br><hr size=2><br>";
					continue;
				}
				else break;
			
			
			idx=0; oldLevel=newLevel;
			newLevel=0;
			firstChar=var[idx];
			while(idx < strlen(var)) {
				firstChar=var[idx];
				if(firstChar==' ') idx++;
				else if(firstChar=='>') { idx++; newLevel++; }
				else break;
			}
		
			if(newLevel!=oldLevel)
				if(newLevel==0) buff="</font>";
				else {
					if(newLevel>=3) newLevel=3;
					
					buff.sprintf("</font><font color=\"%s\">", hexColors[newLevel].data());
				}
			
			if(!buff.isEmpty()) {
				result+=buff;	
				buff="";
			}	
			result+=toHtmlString(var);
			result+="<br>";
			//debug("%s", result.data());
		}	
		
		html->write(result);
	  html->write("</body></html>");
	}		
		
	
	html->end();
}	



void KNMsgView::slotStatusMsg(const QString &msg)
{
	html->begin();
	html->write(msg);
	html->end();
	html->parse();
	current=0;	
}



void KNMsgView::slotTextSelected(bool s)
{
	if(s) {
		QString sel;
	  html->getSelectedText(sel);
	  QApplication::clipboard()->setText(sel);
	}
}























