/***************************************************************************
                     knheaderbase.h - description
 copyright            : (C) 1999 by Christian Thurner
 email                : cthurner@freepage.de
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KNHEADERBASE_H
#define KNHEADERBASE_H

#include "knmessagebase.h"
#include <qstring.h>
#include <time.h>

class KNHdrViewItem;
typedef unsigned int uint;

class KNHeaderBase {
	
	public:
		
		enum HType {postHdr , readHdr};
				
		KNHeaderBase();
		virtual ~KNHeaderBase();
		
		void clearData();
		
		virtual HType Type()=0;
		QString& tString();
		
		virtual QStrList* msgBody()=0;
		virtual QStrList* msgHead()=0;
		virtual KNMessageBase* Message()=0;
		
		bool hasData()	{ return !subject.isEmpty(); }
		virtual bool hasGroups()=0;
		virtual bool hasReferences()=0;
				
		void setItem(KNHdrViewItem *it);
		
		
		
		int id;
		KNHdrViewItem *item;
		QString email, replyTo, from, subject, timeString;
		time_t time;
		uint lines;
		
		
};

#endif



























