/***************************************************************************
                     kngrmanager.cpp - description
 copyright            : (C) 1999 by Christian Thurner
 email                : cthurner@freepage.de
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <qheader.h>
#include <qdir.h>
#include <ksimpleconfig.h>

#include "kngrmanager.h"
#include "resource.h"
#include "utilities.h"
#include "knentryviewitem.h"
#include "knglobals.h"
#include "kngroupdialog.h"
#include "knexpire.h"



KNGrManager::KNGrManager(KNArticleManager *a, QListView *v)
{
	aManager=a;
	view=v;	

	GList=new QList<KNGroupEntry>;
	GList->setAutoDelete(true);
	
	actLst=new QStrList(false);
	actLst->setAutoDelete(false);
		
	count=loadGroups();
	currGroup=0;
	AutoCheck=true;
}



KNGrManager::~KNGrManager()
{
	delete GList;
	delete actLst;
}



void KNGrManager::readConfig()
{
	KConfig *conf=CONF();
	conf->setGroup("READNEWS");
	AutoCheck=conf->readBoolEntry("autoCheck",true);
		
}



void KNGrManager::saveYourself()
{
	
	if(!expireAll())
		for(KNGroupEntry *var=GList->first(); var; var=GList->next()) {
	  	var->syncDynamicData();
	  	var->saveInfo();
	 	}
}



bool KNGrManager::expireAll()
{
	QDate today=QDate::currentDate();
	QDate lastExpDate;
	int y, m, d, interval;
	
	
	KConfig *c=CONF();
		
	c->setGroup("EXPIRE");
	y=c->readNumEntry("lastExpY", today.year());
	m=c->readNumEntry("lastExpM", today.month());
	d=c->readNumEntry("lastExpD", today.day());
	interval=c->readNumEntry("expInterval", 5);
	
	lastExpDate.setYMD(y,m,d);
	
	if(lastExpDate.daysTo(today) >= interval) {
		
		KNExpire expire;
		
		int progr=0;
		xTop->setStatusMsg(i18n("deleting expired messages ..."));
		xTop->setProgrBarSteps(count);
		xTop->resetProgrBar();
		
		for(KNGroupEntry *var=GList->first(); var; var=GList->next()) {
			
			expire.doExpire(var);
			
			debug("KNExpire: %s => %d expired , %d left",
				var->name().data(), expire.expiredCount(), expire.leftInGroup());
			
			xTop->setProgress(++progr);
			kapp->processEvents(250);
		}
	
		xTop->setStatusMsg();
		
		c->writeEntry("lastExpY", today.year());
		c->writeEntry("lastExpM", today.month());
		c->writeEntry("lastExpD", today.day());
				
		return true;
	}
	else return false;	
	
}



void KNGrManager::expireCurrentNow()
{
	if(currGroup) {
		
		KNExpire expire;
		expire.doExpire(currGroup, true);
		debug("KNExpire: %s => %d expired , %d left",
				currGroup->name().data(), expire.expiredCount(), expire.leftInGroup());
	
		if(expire.expiredCount()>0) {
			currGroup->updListItem();
			if(currGroup->loadHdrs()) aManager->showHdrs();
			else aManager->setGroup(0);
		}		
		
	}
}



void KNGrManager::showGroupDialog()
{
	KNGroupDialog *dial=0;
		
	//check if grouplist file exists
	QString fName=knDir();
	fName+="groups";
		
	if(!QFile(fName).exists()) {
		
		int res=MBox(yn, i18n("You dont have any groups.\n Fetch now?"));
	 	if(res==1) {
	  	dial=new KNGroupDialog(xTop);
	  	if(!dial->slotNewList()) {
	  		delete dial;
	  		return;
	  	}
	  }
	  else return;
	
	}
	
	else dial=new KNGroupDialog(xTop);
		
			
	if (dial->exec()) {
		
		QStrList *sub=dial->sub(),
		*unsub=dial->unsub();
		
		for(char *var=sub->first(); var; var=sub->next())
			subscribe(var);
			
		for(char *var=unsub->first(); var; var=unsub->next())		
			for(KNGroupEntry *en=GList->first(); en; en=GList->next())
				if(strcmp(var, en->name())==0) unsubscribe(en);
	
	}	
	
	delete dial;
}



void KNGrManager::subscribe(char *gName)
{
	QDir dir=QDir::home();
	dir.cd(".knode");
	QString dirName=gName+QString(".grp");
	
	if(dir.mkdir(dirName)) {
	  GList->append(new KNGroupEntry(gName));
		showListItems();
		count++;
	}
	else MBox(err, i18n("Cannot create group-directory !!"));
}



bool KNGrManager::unsubscribe(KNGroupEntry *en=0)
{
	if(en==0) en=currGroup;
	
	QString cmd="rm -r " + en->path();
		
	if(GList->removeRef(en)) {
		system(cmd);
		debug("Files deleted!\n");
		count--;
		if(currGroup==en) currGroup=0;
		return true;
	}
	else return false;
}



QStrList* KNGrManager::activeList()
{
	actLst->clear();
	
	for(KNGroupEntry *en=GList->first(); en; en=GList->next())
		actLst->append(en->name());
	
	return actLst;	
}



void KNGrManager::showListItems()
{
	for(KNGroupEntry *en=GList->first(); en; en=GList->next())
		if(!en->item()) {
			en->setLstItem(new KNEntryViewItem(view));
			en->item()->setPixmap(0,ICON("group.xpm"));
			en->updListItem();
		}
}



int KNGrManager::loadGroups()
{
 	int count=0;
	QString fName;
	QStrList *entries;
	KNGroupEntry *group;
		
	QDir d=QDir::home();
	d.cd(".knode");
	
	entries=(QStrList*)d.entryList("*.grp", QDir::Dirs);
	
	for(char *var=entries->first(); var; var=entries->next()) {
	
		fName=knDir();
		fName+=var;
		fName+="/info";
		debug("load group-info : %s\n", fName.data());
		
		KSimpleConfig info(fName);
		
		group=new KNGroupEntry ( 	info.readEntry("name", ""),
															info.readUnsignedNumEntry("count",0),
															info.readUnsignedNumEntry("read",0),
															info.readUnsignedNumEntry("lastMsg",0),
															info.readBoolEntry("threaded", true) );
		
		
		GList->append(group);
	  count++;
	   	
	}
	
	
	
	showListItems();
	debug("%d groups read from file\n", count);
	return count;
	
}


	
bool KNGrManager::setCurrent(KNEntryBase *_en)
{
	
	if(_en) {
		
		xTop->resetProgrBar();
		xTop->setProgrBarSteps(3);
	
		currGroup=(KNGroupEntry*) _en;
		
		if(currGroup->loadHdrs()) {
		  xTop->setStatusMsg(i18n("loading saved headers ..."));
			xTop->setProgress(1);
		
			if(AutoCheck) {
				xTop->setStatusMsg(i18n("checking for new headers ..."));
				currGroup->checkForNewHdrs();
			}
			else if(!xClient->cmdGroup(currGroup->name())) {
				xTop->resetProgrBar();
				currGroup=0;
				return false;
			}
								
			xTop->setProgress(2);			
			xTop->setStatusMsg(i18n("creating list-items ..."));
			
		  aManager->setGroup(currGroup);
		  aManager->showHdrs();		
		
		  xTop->setProgress(3);
			xTop->setStatusMsg();
		}
		else currGroup=0;
	}
	
	else currGroup=0;
		
	
	return (currGroup!=0);
		
}



void KNGrManager::checkAll()
{
	xTop->setCursorBusy(true);
	
	for(KNGroupEntry *g=GList->first(); g; g=GList->next())
		if(g->loadHdrs()) g->checkForNewHdrs();
	
	if(currGroup) xClient->cmdGroup(currGroup->name());
	
	xTop->setCursorBusy(false);
}














