/***************************************************************************
                          knthread.cpp  -  description
                             -------------------
   
    copyright            : (C) 1999 by Christian Thurner
    email                : cthurner@freepage.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#include "knthread.h"

KNThread::KNThread()
{
	hdrs = new QList<KNReadHeader>;
	hdrs->setAutoDelete(false);
	
	src=0;
	
}



KNThread::KNThread(KNReadHeaderList *l, KNReadHeader *h)
{
	hdrs = new QList<KNReadHeader>;
	hdrs->setAutoDelete(false);
	
	src=l;
	
	createThreadOf(h);
	
	
}



KNThread::~KNThread()
{
	delete hdrs;
}



void KNThread::createThreadOf(KNReadHeader *h)
{
	
	KNReadHeader *ref, *tmp;
	int topID, idRef=h->idRef;
	
	ref=h;
					
	while(idRef!=0) {
		ref=src->byID(idRef);
		idRef=ref->idRef;
	}
		
	topID=ref->id;
	hdrs->append(ref);
		
	
	for(uint i=0; i<src->length(); i++) {
		
		tmp=src->at(i);
		
		if(tmp->idRef!=0) {
			
			idRef=tmp->idRef;
		
		  while(idRef!=0) {
		  	ref=src->byID(idRef);
		  	idRef=ref->idRef;
		  }
		  	
			if(ref->id==topID) hdrs->append(src->at(i));
		}
	}
	
			
}



int KNThread::setRead(bool r, int &newCnt)
{
	KNReadHeader *ref;
	int idRef, changeCnt=0, n_ew=0;

	for(KNReadHeader *h=hdrs->first(); h; h=hdrs->next()) {
		
		if(r) h->unrSubCnt=0;
	
		if(h->isRead()!=r) {
		
			changeCnt++;
			h->setRead(r);
			h->setHasChanged(true);
			if(h->isNew()) n_ew++;
					
			
			if(!r) {
				
				idRef=h->idRef;
				
				while(idRef!=0) {
					ref=src->byID(idRef);
					ref->unrSubCnt++;
					idRef=ref->idRef;
		    }
	  	}       	
	  }
	}
	
	if(changeCnt>0)
		for(KNReadHeader *h=hdrs->first(); h; h=hdrs->next())
			if(h->item) h->updateItem();
	
	newCnt=n_ew;		
	return changeCnt;
	 	
}



void KNThread::setScore(short s)
{
	
	if(hdrs->first()->score!=s)

		for(KNReadHeader *h=hdrs->first(); h; h=hdrs->next()) {
	   	h->score=s;
			if(h->item) h->updateItem();
			h->setHasChanged(true);
		}

}










