/***************************************************************************
                     knreadheader.cpp - description
 copyright            : (C) 1999 by Christian Thurner
 email                : cthurner@freepage.de
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "knreadheader.h"
#include "knhdrviewitem.h"
#include "knglobals.h"



KNReadHeader::KNReadHeader()
{
	flags.fill(false,7);
		
	message=0;
	idRef=-1;
	thrLevel=0;
	unrSubCnt=0;
	score=50;
	age=0;
}



KNReadHeader::~KNReadHeader()
{
	this->clearData();
	delete message;
}



void KNReadHeader::setFromLine(const QString &fString)
{
	
	FromLineParser p;
	
	p.doParse(fString);
	
	if(!p.from().isEmpty()) {
		from=p.from();
		saneName();
	}
	
	if(!p.email().isEmpty()) {
		email=p.email();
		if(from.isEmpty()) from=email;
	}
	else {
		email="no email-adress";
		if(from.isEmpty()) from="no name";
	}
	
	
}



void KNReadHeader::setReplyToLine(const char *fString)
{
	FromLineParser p;
	p.doParse(fString);
	
	if(!p.email().isEmpty()) replyTo=p.email();
	
}



void KNReadHeader::saneName()
{
	int first=-1, last=-1;
		
	first=from.find('"');
	if(first>=0) last=from.findRev('"');
	
	if(last>=0 && first>=0 && last>first+1){
		from.remove(first,1);
		from.truncate(last-1);
	}
	
}



void KNReadHeader::initItem()
{
	if(item) {	
		item->setText(0,subject);
		item->setText(1,from);
		item->setText(3,tString());
		updateItem();
	}
}



void KNReadHeader::updateItem()
{
	static QPixmap 	gb=ICON("greyball.xpm"),
									rb=ICON("redball.xpm"),
									ns=ICON("newsubs.xpm"),
									ey=ICON("eyes.xpm"),
									nullPM;
	
	item->setFirstColBold(isNew());
	item->setGreyOut(!hasUnreadSubs() && isRead());
	
	if(isRead()) item->setPixmap(0, gb);
	else item->setPixmap(0, rb);
	
	if(hasNewSubs()) item->setPixmap(1, ns);
	if(score==100) item->setPixmap(2, ey);
	else item->setPixmap(2,nullPM);
	
	char tmp[4];
	sprintf(tmp,"%3d", score);
	item->setText(2,tmp);
	
}



void KNReadHeader::clearData()
{
	KNHeaderBase::clearData();
	mID.resize(0);
	for(int i=0; i<5; i++) references[i].resize(0);
}





KNReadHeader::FromLineParser::FromLineParser()
{
}



KNReadHeader::FromLineParser::~FromLineParser()
{
}


					
void KNReadHeader::FromLineParser::doParse(const QString &fString)
{
	int type=0, pos1=0, pos2=0;		
		
	if (fString.find('(')!=-1) type=1;
	else if (fString.find('<')!=-1) type=2;
			
	switch(type) {
			
		case 0: e_mail=fString.copy(); break;
			
		case 1:	pos1=fString.find("(");
						e_mail=fString.mid(0,pos1);
						pos2=fString.find(")",++pos1);
						f_rom=decodeRFC1522String(fString.mid(pos1, pos2-pos1));
		break;
			
		case 2:	pos1=fString.find('<');
						if(pos1==0) {
							pos2=fString.find('>',++pos1);
							e_mail=fString.mid(pos1,pos2-pos1);
						}
						else {
							f_rom=decodeRFC1522String(fString.mid(0,pos1-1));							
							pos2=fString.find('>',++pos1);
							e_mail=fString.mid(pos1, pos2-pos1);
						}
		break;
	}
		
	
}



void KNReadHeader::FromLineParser::doParse(const char *fLine)
{
	doParse(QString(fLine));
}










































