/***************************************************************************
                     knpostheader.h - description
 copyright            : (C) 1999 by Christian Thurner
 email                : cthurner@freepage.de
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KNPOSTHEADER_H
#define KNPOSTHEADER_H

#include "knheaderbase.h"
#include "knsendmessage.h"
#include "knmessagecomp.h"



class KNPostHeader : public KNHeaderBase  {
	
	public:
		
		enum SendMode { Post=0, Mail=1 };
		
		KNPostHeader();
		~KNPostHeader();
		
		void clearData();
				
		bool hasReferences() 			{ return false; }
		HType Type() 							{ return postHdr; }
		bool hasGroups() 					{ return !groups.isEmpty(); }
		bool isNew()							{ return (this->folderID==-1); }
		
		QStrList* msgHead();
		QStrList* msgBody()				{ return message->body(); }
		KNSendMessage* Message()	{ return message; }
				
		void initItem();
		void setTime();
				
		void createMsgHead(int encoding=3);
			
				
		int folderID;
		long bodyOffset;
		bool hasChanged;//, isSent;
		QString mailTo, fupTo, replyTo, groups, refLine, orga;
		KNSendMessage *message;
		SendMode sMode;
		
};

#endif

























