/***************************************************************************
                     knpostheader.cpp - description
 copyright            : (C) 1999 by Christian Thurner
 email                : cthurner@freepage.de
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "knpostheader.h"
#include "knmessagecomp.h"
#include "utilities.h"
#include "knhdrviewitem.h"
#include "knsender.h"
#include <mimelib/datetime.h>
#include <kcharsets.h>

KNPostHeader::KNPostHeader()
{
	message=0;
	folderID=-1;
	bodyOffset=0;
	sMode=Post;
	hasChanged=false;
	//isSent=false;
}



KNPostHeader::~KNPostHeader()
{
	this->clearData();
}



void KNPostHeader::clearData()
{
	KNHeaderBase::clearData();
	fupTo.resize(0);
	groups.resize(0);
	refLine.resize(0);
	orga.resize(0);
}



void KNPostHeader::setTime()
{
	DwDateTime dt;
	time=dt.AsUnixTime();
}	



void KNPostHeader::initItem()
{
	if(!item) return;
	
	item->setText(0,subject);
	item->setText(1,groups);
	item->setText(3,tString());
}



QStrList* KNPostHeader::msgHead()
{
	if(message->header()->isEmpty()) createMsgHead();
	
	return message->header();
			
}



void KNPostHeader::createMsgHead(int encoding=3)
{
	QStrList *header=message->header();	
	DwDateTime date;	
	QString buff;
	
	setTime();
	date.FromUnixTime(time);
	date.Assemble();
	
	header->clear();
		
	//from and email
	buff.sprintf("From: %s <%s>",from.data(), email.data());
	header->append(buff);
	
	//reply-to
	if(!replyTo.isEmpty()) {
		buff="Reply-to: ";
		buff+=replyTo;
		header->append(buff);
	}
		
	//groups or mailto
	if(sMode==KNPostHeader::Post){
	  buff="Newsgroups: ";
	  buff+=groups;
	}
	else {
		buff="To: ";
		buff+=mailTo;
	}
	header->append(buff);
		
		
	//maybe fup2
	if(!fupTo.isEmpty() && sMode==KNPostHeader::Post) {
		buff="Followup-To: ";
		buff+=fupTo;
	  header->append(buff);
	}
	
	//subject	
	buff="Subject: ";
	buff+=subject;
	header->append(buff);
	
	//Date
	buff="Date: ";
	buff+=date.AsString().data();
	header->append(buff);
	
	//Lines
	buff.sprintf("Lines: %d", lines);
	header->append(buff);
	
	//organization
	if(!orga.isEmpty()) {
		buff="Organization: ";
		buff+=orga;
		header->append(buff);
	}
		
	//maybe references
	if(!refLine.isNull()) {
	  buff="References: ";
	  buff+=refLine;
	  header->append(buff);
	}
	
	//Mime
	header->append("Mime-Version: 1.0");	
		
	//Content-Type	
	buff="Content-Type: text/plain; charset=";
	buff+=kapp->getCharsets()->defaultCh().name();
	header->append(buff);
	
	//Encoding
	switch(encoding) {
		case KNSender::sBit 		:
			buff="Content-Transfer-Encoding: 7bit";
		break;
		
		case KNSender::eBit 		:
			buff="Content-Transfer-Encoding: 8bit";
		break;	
		
		case KNSender::quotedPr	:
			buff="Content-Transfer-Encoding: quoted-printable";
		break;
		
		default:
			buff="Content-Transfer-Encoding: unknown";
		break;
	}
	header->append(buff);
	
	//X-Mailer
	header->append("X-Mailer: KNode " VERSION);
			
}




















