/***************************************************************************
                     kngrouplistwidget.h - description
 copyright            : (C) 1999 by Christian Thurner
 email                : cthurner@freepage.de
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KNGROUPLISTWIDGET_H
#define KNGROUPLISTWIDGET_H

#include <qwidget.h>
#include <qlistbox.h>
#include <qlineedit.h>
#include <qradiobutton.h>
#include <qbuttongroup.h>
#include <qstrlist.h>
#include <qpushbutton.h>
#include <ktabbar.h>

class KNGroupListWidget : public QWidget  {

  Q_OBJECT
	
	public:
		
		KNGroupListWidget(QWidget *parent=0, const char *name=0, QStrList *subscribed=0);
		~KNGroupListWidget();
	  		
		const char* currentText()					{ return list->text(list->currentItem()); }
		virtual QSize sizeHint();
		
		void setPixmap(int idx=-1, bool s=true);
		void newList()										{ loadList(); tabs->setCurrentTab(aID); }
		
				
	protected:
				
	  void updPixmaps();
	  void loadList();
	  		
		QListBox *list;
		QLineEdit *filterEdit;
		//QPushButton *all, *sub;
		KTabBar *tabs;
				
		QStrList *allList, *subList, *ListPtr;
		int aID, sID;
			
		
	protected slots:
		void slotFilter(const char *text);
		//void slotAll();
		//void slotSub();
		void slotTabSelected(int id);
		void slotItemSelected(int idx)	{ emit itemSelected(list->text(idx)); }
		
	
	signals:
		void itemSelected(const char *text);
		
};

#endif









