/***************************************************************************
                     kngroupentry.h - description
 copyright            : (C) 1999 by Christian Thurner
 email                : cthurner@freepage.de
***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KNGROUPENTRY_H
#define KNGROUPENTRY_H


#include "knreadheaderlist.h"
#include "knentrybase.h"
#include "knmessagefilter.h"



class KNGroupEntry : public KNEntryBase  {
	
	friend class KNExpire;
	friend class KNArticleManager;

	public:
		KNGroupEntry(const QString &name, uint cnt=0, uint re=0, uint la=0, bool thr=true);
		~KNGroupEntry();
	
		EntryType Type() 				{ return group; }
				
		void setRead(uint r)		{ mRead=r; }
		const uint read()				{ return mRead; }
		
		void setOldLast(uint o)	{ mOlast=o; }
		const uint oldLast()		{ return mOlast; }
		
		void setLast(uint l)		{ mLast=l; }
		const uint last()				{ return mLast; }
							
		void toggleThreaded()		{ mThr=!mThr;  }
		bool threaded()					{ return mThr; }
		
		const uint newCount()		{ return mNewCnt; }
			
	  void updListItem();
	 		 	  	
	  bool loadHdrs();
	  void clearHdrList();
	  void saveDynamicData(int count,bool ovr=false);
	  void syncDynamicData();
	  void saveInfo();
	  QString path();
	
	  void checkForNewHdrs();
	 		
	
	protected:	
		uint mRead, mOlast, mLast, mNewCnt;	;
		bool mThr;
							
		
	private:
		int getNewHdrs();
		void sortHdrs(int count);
		int findRef(KNReadHeader *h, int from, int to, bool reverse=false);
		void updateThreadInfo();
		
		int saveStaticData(int count,bool ovr=false);
		int readHdrsFromFile();
						
		KNReadHeaderList hList;
								
						
		struct dynData {
			
			void setData(KNReadHeader *h);
			
			uint id;
			int idRef;
			bool read;
			short thrLevel, score;
		};
		
};

#endif















































