/* ------------------------------------------------------------- 

    kngicvs.cpp (part of K News Grabber)

    (C) 1999 by Cengiz Tuztas

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Cengiz.Tuztas@uni-essen.de

    $Id:$

   ------------------------------------------------------------- */

#include <kngicvs.h>

KNGICVS::KNGICVS( DwString binChars, const char *fn )
  :QWidget()
{
  pmScaled = 0;
  pm = 0;
  debug( "Creating KNGICVS" );
  filename = fn;
  pm = new QPixmap();
  if ( pm )
    debug( "pm" );
  else 
    debug( "!pm" );
  if ( pm->loadFromData( ( const uchar * ) binChars.data(), binChars.size() ) )
    {
      debug( "Loaded Image " );
    }
  else
    {
      debug( "Could not load Image" );
      delete this;
    }
}

void
KNGICVS::paintEvent( QPaintEvent * )
{

  QWMatrix m;

  if ( pmScaled )
    {
      // Exists, I do not need to scale 
      bitBlt( this, 0,0, pmScaled );
    }
  else
    {
      // New Scaling needs to be done

      m.scale( ( ( double ) 160 ) / pm->width(),
	       ( ( double ) 102 ) / pm->height() );
      pmScaled = new QPixmap( pm->xForm( m ) );
      bitBlt( this, 0, 0, pmScaled );
      delete pm;
    }
      
}

