/* ------------------------------------------------------------- 

    knghash.h (part of K News Grabber)

    (C) 1999 by Cengiz Tuztas

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    Cengiz.Tuztas@uni-essen.de

    $Id: knghash.h,v 1.2 1999/05/19 20:45:04 ctuztas Exp $

   ------------------------------------------------------------- */

#ifndef _KNGHASH_H_
#define _KNGHASH_H_

#include <kng.h>
#include <qdict.h>
#include <qfile.h>
#include <qdatetime.h>
#include <qdir.h>
#include <qdatastream.h>

class KNGHashEntry
{
 public:
  
  KNGHashEntry();
  KNGHashEntry( const char *, const QDate *dt = 0 );
  ~KNGHashEntry();
  
  void setDate( const QDate * );
  void setKey ( const char * );
  const QDate *date();
  const char *key();
  
 private:
  QString *s;
  QDate *d;
};

class KNGHash : public QObject , public QDict<KNGHashEntry>
{
Q_OBJECT

 public:

  KNGHash();
  KNGHash( bool ); 
  ~KNGHash();

  void writeData();
  void readData();
  void deletehashFile();

 private:
  QFile *file;
  bool s_mode;
};


#endif // _KNGHASH_H_
