/***************************************************************************
                          ipinput.h  -  A simple netconfig tool
                             -------------------
    begin                : Wed Oct 20 1999
    copyright            : (C) 1999 by Federico David Sacerdoti
    email                : fds@slinuxmachines.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   * 
 *                                                                         *
 ***************************************************************************/


#ifndef IPINPUT_H
#define IPINPUT_H

#include <qwidget.h>
#include <qlined.h>
#include <stdio.h>

/**A QLineEdit box that accepts an IP address in 4-dot form. It can do
error checking and error reporting.
  *@author Federico David Sacerdoti
  */

//lass QString;

class IPinput : public QLineEdit  {
public: 
	IPinput(QWidget* parent);
	~IPinput();
	
	/* Gets a 'good' IP address that has been verified for correctness.
	 * Doesnt mean it means anything, just that it looks like a proper address */	
	QString getIP();
	/* Makes the IP address go "red". Means that it is incorrect in some way */
	void bad();
	
protected:
	/* Checks that the inputs are actually IP numbers */
	bool checkIP(const QString & ip);
	
protected:
	QPalette red;

};

#endif







