  /*

  knat v. 1.0.0

  Copyright (C) 2000 Luigi Genoni
  		     venom@DarkStar.sns.it
  */


#ifndef KNETFILTER_H
#define KNETFILTER_H

#include <qlistbox.h>
#include <qpopupmenu.h>
#include <qpushbutton.h>
#include <qcombobox.h>
#include <qlineedit.h>
#include <qwidget.h>
#include <qmenubar.h>
#include <qmessagebox.h>

#include <kapp.h>
#include <ktopwidget.h>
#include <kpopmenu.h>
#include <kprocess.h>
#include <kstatusbar.h>

#define ID_HINTTEXT 1

class knetfilter : public KTMainWindow
{

  Q_OBJECT

protected:
  /* setup functions */
  void setupMenuBar();
  void setupToolBar();
  void setupStatusBar();
  void setupknetfilterWidget(); 

  void setupConnect();

  /* check for iptables function */
  void checkIptables();

  /* check for masqurading function */
  void checkMasquerade();

public:
  knetfilter( QWidget *parent=0, const char *name=0 );
  ~knetfilter();

  void closeEvent (QCloseEvent *);

  /* defines some processes */
  KProcess addp;
  KProcess addp2;
  KProcess addp3;
  KProcess delp;
  KProcess delp2;
  KProcess delp3;
  KProcess save;
  KProcess load;
  KProcess stop;
  KProcess stop_nat;
  KProcess polrules;
  KProcess natpolrules;
  KProcess natrules;
  KProcess masqon;
  KProcess masqoff;
  KProcess rules;
  KProcess fetchIp;
  KProcess fetchNetmask;
  KProcess entries;
  KProcess tcpdump;
  KProcess addredirect;
  KProcess delredirect;

public slots:
  void addRule();
  void delRule();
  void addRule_tcp();
  void delRule_tcp();
  void addRule_udp();
  void delRule_udp();
  void addRule_icmp();
  void delRule_icmp();
  void stopAll();
  void saveAll();
  void loadAll();
  void stopNAT(); 
  void slotExit();
  void addDone_tcp();
  void delDone_tcp();
  void addDone_udp();
  void delDone_udp();
  void addDone_icmp();
  void delDone_icmp();
  void saveDone();
  void loadDone();
  void stopDone();
  void stop_natDone();
  void checkMasqon();
  void masqonDone();
  void masqoffDone();
  void clearLog();

   /* interface functions */
  void startprobeInterface();
  void probeInterface(KProcess *, char *, int);
  void probeInterface2(KProcess *, char *, int); 
  void probeInterfaceDone();
  void starttcpDump();
  void closetcpDump();
  void tcpDump();
  void listDump(KProcess *, char *, int);

  /* list rules functions */
  void iptablesRules();
  void closeiptablesRules();
  void startlistRules();
  void listRulesDone();
  void listRules(KProcess *, char *, int);

  void interfaceActivated(int);
  void interfacenrActivated(int);
  void chainActivated(int);
  void policyActivated(int);
  void flagsActivated(int);
  void polchainActivated(int);

  /* chain policy options */
  void polRules();
  void closepolRules();
  void startpolRules();
  void polRulesDone();
  void setpolRules(KProcess *, char *, int);
  void chainpolicyActivated(int);


  /* nat redirections options */
  void natRules();
  void closenatRules();
  void startnatRules();
  void stopnatRules();
  void setnatRules(KProcess *, char *, int);
  //void natinterfaceActivated(int);
  //void natinterfacenrActivated(int);
  void natchainActivated(int);
  void natprotocolActivated(int);


  /* nat chain policy options */
  void natpolRules();
  void closenatpolRules();
  void startnatpolRules();
  void natpolRulesDone();
  void natpolchainActivated(int);
  void setnatpolRules(KProcess *, char *, int);
  void natpolicyActivated(int);
  

   /* list masq functions */
  void startmasqEntries();
  void userEntries(KProcess *, char *, int);
  void userEntriesDone();


private:
  /* some global objects */
  QPushButton *startBtn;
  QPushButton *stopBtn;
  QPushButton *helpBtn;
  QPushButton *exitBtn; 
  QListBox *messageLog;
  QPopupMenu *file;
  QPopupMenu *tables;
  QPopupMenu *nat_tables;
  QPopupMenu *options;
  QPopupMenu *help;
  QLineEdit *ipAddr;
  QLineEdit *netmaskAddr;
  QLineEdit *addSourcePort;
  QLineEdit *addDestinationPort;
  QLineEdit *addIcmpType;
  QLineEdit *extraNet;
  QLineEdit *extraNetMask;
  QLineEdit *firstNet;
  QLineEdit *firstNetMask;
  QLineEdit *firstPort;
  QLineEdit *secondNet;
  QLineEdit *secondNetMask;
  QLineEdit *secondPort;
  QLineEdit *thirdNet;
  QLineEdit *thirdNetMask;
  QLineEdit *thirdPort;
  QWidget *polList;
  QWidget *natList;
  QWidget *natpolList;
  QWidget *masqList;
  QWidget *dumpList;
  QListBox *polBox;
  QListBox *natBox;
  QListBox *natpolBox;
  QListBox *masqBox;
  QListBox *dumpBox;
  QComboBox *interface;
  QComboBox *interfacenr;
  QComboBox *chain;
  QComboBox *policy;
  QComboBox *nat;
  QComboBox *natinterface;
  QComboBox *natinterfacenr;
  QComboBox *natprotocol;
  QComboBox *flags;
  QComboBox *polchain;
  QComboBox *polchainpolicy;
  QComboBox *natchain;
  QComboBox *natchainpolicy;
  QComboBox *natpolchain;
  QComboBox *natpolchainpolicy;
  /* the menubar, toolbar and statusbar */
  KMenuBar *menubar;
  KToolBar *toolbar;
  KStatusBar *statusbar;

  QWidget *masqWidget;

  /* checking for files */
  FILE *sbin;
  FILE *ip_masquerade;
  
  int toolbar1;
	
  bool isMasqon;
  int useMasq;
  char *use;
	
  char *interfaceChoice;
  int interfacenrChoice;
  char *interfaceChoicedmp;
  char *interfacenrChoicedmp;
  char *interfaceChoicemasq;
  char *chainChoice;
  char *policyChoice;
  char *flagChoice;
  //char *natinterfaceChoice;
  //int natinterfacenrChoice;
  //char *natinterfaceChoicedmp;
  //char *natinterfacenrChoicedmp;
  //char *natinterfaceChoiceuse;
  char *natprotocolChoice;
  char *polchainChoice;
  char *chainpolicyChoice;
  char *natchainChoice;
  char *natchainResult;
  char *natpolchainChoice;
  char *natchainpolicyChoice;

  int add;
  int del; 

  int polcheck;
  int rulecheck;
  int dumpcheck;
  int natpolcheck;
  int natcheck;

};

#endif
