
#ifndef KMODEM_H
#define KMODEM_H

#include <kapp.h>


#include <sys/ioctl.h>
#include <sys/socket.h>
#include <net/ppp_defs.h>
#include <net/if.h>


#include <qtimer.h>
#include <qfileinf.h>
#include <qlabel.h>
#include <qpixmap.h>
#include <qstring.h>
#include <qwmatrix.h>

#define IDLE 0x0000
#define RECEIVED 0x0001
#define TRANSMITED 0x0002
#define RECVTRANS 0x0003
#define OFF 0x0004

#define VERSION "1.2.1"


class KModem : public QLabel
{

Q_OBJECT;

private:

bool online;
int sock, status, old_status;
struct ifreq ifreq;
struct ppp_stats stats;
QWMatrix matrix;
QString * device;
//QTimer *timer;
QFileInfo * file;
QPixmap modemoff, modemidle, modemrd, modemwr, modemrw;
long old_recv, old_trans, io_recv, io_trans;

public:

void closeEvent(QCloseEvent*);
void timerEvent(QTimerEvent*);
void paintEvent(QPaintEvent*);
void resizeEvent(QResizeEvent*);
KModem(int);

public slots:
//void write_settings();

};

#endif
