#include "kldap.h"

AttributeEditPage::AttributeEditPage(QWidget* parent, Kldapw* kldapw, char* dn) : KldapPage(parent, kldapw)
{
  QPixmap pix;

  if(dn == NULL)
  {
    dn = kldapw->getSelectedDN();
  }
  this->dn = dn;

  if(strcmp(dn, "") == 0)
    {
      QMessageBox::warning(this, "kldap", "No Item selected.\n", "OK", 0);
      return;
    }

  QGridLayout* layout = new QGridLayout(this, 10, 4, 5);

  editTree = new KTreeList(this);
  editTree->setBackgroundColor(*(new QColor(255, 255, 255)));
  editTree->setAutoUpdate(true);
  editTree->setTreeDrawing(true);

  btnAdd = new QPushButton("&Add", this);
  btnAdd->setMaximumSize(btnAdd->sizeHint());
  btnAdd->setEnabled(false);

  btnModify = new QPushButton("&Modify", this);
  btnModify->setMaximumSize(btnModify->sizeHint());
  btnModify->setEnabled(false);

  btnDel = new QPushButton("&Delete", this);
  btnDel->setMaximumSize(btnDel->sizeHint());
  btnDel->setEnabled(false);

  pix = kldapw->getPixmap("dn");

  LDAPItem* dnItem = new LDAPItem(dn, &pix, "d");
  editTree->insertItem(dnItem);
  fillList();

  layout->addMultiCellWidget(editTree, 0, 8, 0, 3);
  layout->addWidget(btnAdd, 9, 0);
  layout->addWidget(btnModify, 9, 2);
  layout->addWidget(btnDel, 9, 1);

  btnModify->hide();
  editTree->setFocus();
  show();

  QObject::connect(editTree, SIGNAL(expanded(int)), this, SLOT(expandTree(int)));
  QObject::connect(editTree, SIGNAL(selected(int)), this, SLOT(selectedSlot(int)));
  QObject::connect(editTree, SIGNAL(highlighted(int)), this, SLOT(highlightedItem(int)));
  QObject::connect(btnAdd, SIGNAL(clicked()), this, SLOT(addAttribute()));
  QObject::connect(btnDel, SIGNAL(clicked()), this, SLOT(deleteAttribute()));
  QObject::connect(btnModify, SIGNAL(clicked()), this, SLOT(modifyValue()));
}

void AttributeEditPage::highlightedItem(int index)
{
  LDAPItem* item = (LDAPItem*)editTree->itemAt(editTree->currentItem());
  if(strcmp(item->getDN(), "d")==0)
  {
    btnDel->setEnabled(false);
    btnAdd->setEnabled(true);
    btnModify->setEnabled(false);
  }
  if(strcmp(item->getDN(), "a")==0)
  {
    btnDel->setEnabled(true);
    btnAdd->setEnabled(true);
    btnModify->setEnabled(false);
  }
  if(strcmp(item->getDN(), "v")==0)
  {
    btnDel->setEnabled(true);
    btnAdd->setEnabled(false);
    btnModify->setEnabled(true);
  }
}

void AttributeEditPage::addAttribute()
{
  LDAPItem* item = (LDAPItem*)editTree->itemAt(editTree->currentItem());

  if(strcmp(item->getDN(), "a")==0)
  {
    addValue();
    return;
  }
  else if(strcmp(item->getDN(), "v")==0)
  {
    return;
  }
  else
  {
    AttributeDialog* dlg = new AttributeDialog(this, kldapw, LDAP_MOD_ADD, dn, NULL);
    if(dlg->exec())
    {
      QPixmap pix;
      pix = kldapw->getPixmap("attribute");
      LDAPItem* newItem = new LDAPItem((char*)dlg->txtValue->text(), &pix, "a");
      editTree->addChildItem(newItem, 0);
    }
  }
}

void AttributeEditPage::deleteAttribute()
{
  LDAPItem* item = (LDAPItem*)editTree->itemAt(editTree->currentItem());

  if(strcmp(item->getDN(), "v")==0)
  {
    deleteValue();
    return;
  }
  else if(strcmp(item->getDN(), "d")==0)
  {
    return;
  }
  else
  {
    char* mod_type;
    char* value;
    int error;

    value  = NULL;
    mod_type = (char*)editTree->itemAt(editTree->currentItem())->getText();

    error = kldapw->modify(dn, LDAP_MOD_DELETE, mod_type, value);

    if(error == 0)
    {
      editTree->removeItem(editTree->currentItem());
    }
  }
}

void AttributeEditPage::addValue()
{
  char* attributeName = (char*)(editTree->itemAt(editTree->currentItem()))->getText();

  AttributeValueDialog* dlg = new AttributeValueDialog(this, kldapw, LDAP_MOD_ADD, dn, attributeName);
  if(dlg->exec())
  {
    QPixmap pix;
    pix = kldapw->getPixmap("value");
    LDAPItem* newItem = new LDAPItem((char*)dlg->txtValue->text(), &pix, "v");
    editTree->addChildItem(newItem, editTree->currentItem());
  }
}

void AttributeEditPage::deleteValue()
{
  LDAPItem* item = (LDAPItem*)editTree->itemAt(editTree->currentItem());

  if(strcmp(item->getDN(), "d")==0)
  {
    return;
  }
  else
  {
    char* mod_type;
    char* value;
    int error;

    value  = (char*)item->getText();
    mod_type = (char*)editTree->itemAt(editTree->currentItem())->getParent()->getText();
    error = kldapw->modify(dn, LDAP_MOD_DELETE, mod_type, value);

    if(error == 0)
    {
      editTree->removeItem(editTree->currentItem());
    }
  }
}

void AttributeEditPage::modifyValue()
{
/*
  LDAPItem* item = (LDAPItem*)editTree->itemAt(editTree->currentItem());
  char* attributeName = (char*)(editTree->itemAt(editTree->currentItem()))->getText();

  if(strcmp(item->getDN(), "v")!=0)
  {
    return;
  }
  else
  {
    AttributeDialog* dlg = new AttributeDialog(this, kldapw, "v", LDAP_MOD_REPLACE, dn, attributeName);
    dlg->txtValue->setText(item->getText());

    if(dlg->exec())
    {
      item->setText(dlg->txtValue->text());
    }
  }*/
}

void AttributeEditPage::expandTree(int index)
{
  switcher(index);
}

void AttributeEditPage::selectedSlot(int itemIndex)
{
  editTree->expandOrCollapseItem(itemIndex);
}

void AttributeEditPage::switcher(int index)
{
  LDAPItem* item;

  item = (LDAPItem*)editTree->itemAt(index);
  if(strcmp(item->getDN(), "a")==0)
  {
    buildTree((char*)item->getText(), index);
  }
  if(strcmp(item->getDN(), "d")==0)
  {
    //editTree->expandItem(0);
    removeItems(0);
    fillList();
  }
  if(strcmp(item->getDN(), "v")==0)
  {
    //cout << "Not implemented yet...\n";
  }
}

void AttributeEditPage::removeItems(int index)
{
  int childIndex;

  if(editTree->visibleCount() > 0) // Schaut, ob ueberhaupt Elemente zu loeschen sind
  {
      for(childIndex = editTree->itemIndex(editTree->itemAt(index)->getChild()); childIndex != -1; childIndex = editTree->itemIndex(editTree->itemAt(index)->getChild()))
	    {
	      editTree->removeItem(childIndex);
	    }
  }
}

void AttributeEditPage::buildTree(char* attributeName, int index)
{
  LDAPMessage* result;
  LDAPMessage* ep;
  int error;
  char** entry;
  QPixmap pix;
  LDAPItem* valueItem;

  removeItems(index);

  error = ldap_search_s(ldap, dn, LDAP_SCOPE_BASE, "objectClass=*", NULL, 0, &result);

  if(error == 0)
  {
    for(ep = ldap_first_entry(ldap, result); ep != NULL; ep = ldap_next_entry(ldap, ep))
    {
      entry = (char**)ldap_get_values(ldap, ep, (char*)editTree->itemAt(index)->getText());
	
      for(int i = 0; entry && entry[i] != NULL; i++)
	    {
	      pix = kldapw->getPixmap("value");
	      valueItem = new LDAPItem(entry[i], &pix, "v");
	      editTree->addChildItem(valueItem, index);
	    }
    }
  }
  else
  {
    QMessageBox::warning(this, "kldap", ldap_err2string(error), "OK", 0);
  }
}

void AttributeEditPage::fillList()
{
  LDAPMessage* result;
  LDAPMessage* ep;
  BerElement* ber;
  char* ap;
  //char** entry;
  int error;
  QPixmap pix;
  LDAPItem* itemAttribute;

  error = ldap_search_s(ldap, dn, LDAP_SCOPE_BASE, "objectClass=*", NULL, 0, &result);

  if(error == 0)
    {
      for(ep = ldap_first_entry(ldap, result); ep != NULL; ep = ldap_next_entry(ldap, ep))
	{
	  for(ap = ldap_first_attribute(ldap, ep, &ber); ap != NULL; ap = ldap_next_attribute(ldap, ep, ber))
	    {
	
	      pix = kldapw->getPixmap("attribute");
	      itemAttribute = new LDAPItem(ap, &pix, "a");
	      editTree->addChildItem(itemAttribute, 0);
	      //entry = (char**)ldap_get_values(ldap, ep, ap);
	    }
	}
    }
  else
    {
      QMessageBox::warning(this, "kldap", ldap_err2string(error), "OK", 0);
    }

    editTree->expandItem(0);
}
