#include "kldap.h"

SearchDialog::SearchDialog(QWidget* parent, Kldapw* kldapw) : QDialog(parent, "Search Dialog", TRUE)
{
  this->kldapw = kldapw;

  setCaption("Search");

  if(strcmp(kldapw->getSelectedDN(), "") == 0)
  {
    QMessageBox::warning(this, "kldap", "No Item selected.\n", "OK", 0);
    done(1);
    return;
  }

  QGridLayout* layout = new QGridLayout(this, 10, 4, 5);

  QLabel* lblDN = new QLabel((new QString("DN: "))->append(kldapw->getSelectedDN()), this);
  QLabel* lblQuery = new QLabel("Query", this);
  txtQuery = new QLineEdit(this);
  QPushButton* btnSearch = new QPushButton("&Search", this);
  listView = new QListView(this);
  QPushButton* btnOK = new QPushButton("&OK", this);
  btnEdit = new QPushButton("&Edit", this);


  layout->addMultiCellWidget(lblDN, 0, 0, 0, 3);
  layout->addWidget(lblQuery, 1, 0);
  layout->addMultiCellWidget(txtQuery, 1, 1, 1, 3);
  layout->addWidget(btnSearch, 2, 3);
  layout->addMultiCellWidget(listView, 3, 8, 0, 3);
  layout->addWidget(btnEdit, 9, 0);
  layout->addWidget(btnOK, 9, 1);

  listView->addColumn("Name");
  listView->addColumn("DN");
  btnEdit->setEnabled(false);
  txtQuery->setFocus();

  QObject::connect(btnOK, SIGNAL(clicked()), this, SLOT(reject()));
  QObject::connect(btnSearch, SIGNAL(clicked()), this, SLOT(search()));
  QObject::connect(txtQuery, SIGNAL(returnPressed()), this, SLOT(search()));
  QObject::connect(btnEdit, SIGNAL(clicked()), this, SLOT(edit()));
  QObject::connect(listView, SIGNAL(selectionChanged()), this, SLOT(itemSelectedSlot()));

  //search();

  resize(400, 330);
}

void SearchDialog::edit()
{
  PageDialog* dlg = new PageDialog(this);
  QListViewItem* item = listView->currentItem();

  if(item == NULL) return;

  char* editDN = (char*)item->text(1);

  dlg->addPage(new AttributeEditPage(dlg, kldapw, editDN));
  dlg->exec();
}

void SearchDialog::search()
{
  LDAPMessage* result;
  LDAPMessage* ep = NULL;
  char** objectclass;
  QPixmap pix;
  int error;
  char* displayName;
  int i = 0;
  LDAP* ldap = kldapw->getldap();
  char* filter;

  listView->clear();

  filter = (char*)txtQuery->text();
  if(strcmp(filter, "")==0)
    filter = "objectclass=*"; // Default is "objectclass=*"

  error = ldap_search_s(ldap, kldapw->getSelectedDN(), LDAP_SCOPE_SUBTREE, filter, NULL, 0, &result);

  if(error == 0)
  {
    error = ldap_sort_entries(ldap, &result, NULL, strcasecmp);
    cout << ldap_err2string(error);

    /* Fr jeden gefundenen Eintrag ein Element mit entsprechendem Bild hinzufgen */
      for(ep = ldap_first_entry(ldap, result); ep != NULL; ep = ldap_next_entry(ldap, ep))
	{
	
	  objectclass = (char**)ldap_get_values(ldap, ep, "objectclass");
	
	  if(objectclass != NULL)
	  {
	    if(strcmp(objectclass[i], "top") == 0) // Achtung. Ohne == 0 gibt es ein segfault
      {
        i++;
      }

      pix = kldapw->getPixmap(objectclass[i]);
    }

	  displayName = (ldap_explode_dn(ldap_get_dn(ldap, ep), 1))[0];

	  /*
	     Z.B. beim Novell LDAP-Server (gesehen bei Version1.03) ist es moeglich, das er ein "Unknown" Objekt zurueckgibt.
	     Das hat keine DN. Weil displayName dann keine Wert hat, weist folgende Zeile ihm einen Wert zu ("Unknown")
	  */
	
	  if(strcmp(displayName, "")==0) displayName = "Unknown";

	
	
	  QListViewItem* item = new QListViewItem(listView, displayName, ldap_get_dn(ldap, ep));
	  item->setPixmap(0, pix);
	
    //listView->insertItem(item);
    }
    }
  else
    {
      if(error == LDAP_NO_SUCH_OBJECT)
	QMessageBox::warning(this, "kldap", "This server needs a DN to connect." "Please enter one. (Error: NO SUCH OBJECT)", "OK", 0);
      else
	QMessageBox::warning(this, "kldap", ldap_err2string(error), "OK", 0);
    }

    ldap_msgfree(result);
    ldap_msgfree(ep);
}

void SearchDialog::itemSelectedSlot()
{
  btnEdit->setEnabled(true);
}
