// $Id: preferences.cpp,v 1.7 1998/12/08 16:25:37 denis Exp $
// $Log: preferences.cpp,v $
// Revision 1.7  1998/12/08 16:25:37  denis
// Reconnect on disconnect preference option added
// Cleaned up a little before releasing
//
// Revision 1.6  1998/11/20 12:17:56  denis
// Cleaned a little

#include "preferences.h"
#include "mainwindow.h"

#include "preferences.moc"

Preferences::Preferences() : QTabDialog(0, 0, TRUE)
{
  setCaption("Preferences");
  userwidget = new UserWidget(this);
  addTab(userwidget, "User");
  serverwidget = new ServerWidget(this);
  addTab(serverwidget, "Server");
  proxywidget = new ProxyWidget(this);
  addTab(proxywidget, "Proxy");
  loggingwidget = new LoggingWidget(this);
  addTab(loggingwidget, "Logging");
  soundwidget = new SoundWidget(this);
  addTab(soundwidget, "Sound");
  otherwidget = new OtherWidget(this);
  addTab(otherwidget, "Other");
  setCancelButton();
  connect(this, SIGNAL(applyButtonPressed()), SLOT(savePreferences()));
  resize(330,270);
  setMinimumSize(330,270);
}

Preferences::~Preferences()
{
  if(userwidget)
    delete userwidget;
  if(serverwidget)
    delete serverwidget;
}

void Preferences::setUser(unsigned long uin, const char *nick, const char *pass)
{
  userwidget->setInfo(uin, nick, pass);
}

void Preferences::setServer(const char *host, int port)
{
  serverwidget->setInfo(host, port);
}

void Preferences::setProxy(int use, const char *host, unsigned short port, int auth, const char *user, const char *pass)
{
  proxywidget->setInfo(use, host, port, auth, user, pass);
}

void Preferences::setLogging(int lvl, const char *logfile)
{
  loggingwidget->setInfo(lvl, logfile);
}

void Preferences::setSound(int beep, int wav, int user)
{
  soundwidget->setInfo(beep, wav, user);
}

void Preferences::setOther(int rus, int clsrpl, int crlf, int quote, int recon)
{
  otherwidget->setInfo(rus, clsrpl, crlf, quote, recon);
}

void Preferences::savePreferences()
{
  ((MainWindow*)(kapp->topWidget()))->saveConfig(
    userwidget->uin(),userwidget->nick(),userwidget->pass(),
    serverwidget->host(),serverwidget->port(),
    proxywidget->use(),proxywidget->host(),proxywidget->port(),proxywidget->auth(),proxywidget->user(),proxywidget->pass(),
    loggingwidget->level(),loggingwidget->logfile(),
    soundwidget->bell(),soundwidget->wav(),soundwidget->user(),
    otherwidget->rus(),otherwidget->closereply(),otherwidget->crlf(),otherwidget->quote(),otherwidget->reconnect());
}
