#ifndef _DOCKING_H_
#define _DOCKING_H_

#include <qpixmap.h>
#include <qpopmenu.h>
#include <qpoint.h>

class DockWidget : public QWidget
{
  Q_OBJECT
public:
  DockWidget();
  ~DockWidget();
  const int isDocked();
  void setIcon(QPixmap);
  void setToolTip(QString);
public slots:
  void dock();
  void undock();
  void paintIcon();
  void hideWindow();
  void showWindow();
signals:
  void quitClicked();
protected:
  int docked;
  int toggleID;
  int doRemove;
  QPopupMenu *dockPopup;
  QPixmap dockIcon;
  int picnum;
  void paintEvent(QPaintEvent*);
protected slots:
  void mousePressEvent(QMouseEvent*);
  void mouseDoubleClickEvent(QMouseEvent*);
  void emitQuit();
};

#endif /* _DOCKING_H_ */
