// $Id: wrapedit.cpp,v 1.3 1998/11/23 13:33:53 denis Exp $
// $Log: wrapedit.cpp,v $
// Revision 1.3  1998/11/23 13:33:53  denis
// needUpdate added to avoid flickering
//
// Revision 1.2  1998/11/23 10:13:05  denis
// Buffer limit added
// Wrapping support enhanced
//

#include <kapp.h>
#include <qkeycode.h>
#include <stdio.h>
#include <stdlib.h>
#include "wrapedit.h"

void WrapEdit::keyPressEvent(QKeyEvent *ev)
{
  if((ev->key() < 0x1000 || ev->key() == Key_Enter || ev->key() == Key_Return)
     && text().length()>=limit) // Do not accept more symbols!
  {
    kapp->beep();
    return;
  }

  QMultiLineEdit::keyPressEvent(ev) ;

  if(ev->key() != Key_Delete && ev->key() != Key_Backspace &&
     ev->key() != Key_Right && ev->key() != Key_Left &&
     ev->key() != Key_Down && ev->key() != Key_Up && ev->key() != Key_Next &&
     ev->key() != Key_Prior && ev->key() != Key_Home && ev->key() != Key_End &&
     wrap)
    wrapText();
}

void WrapEdit::resizeEvent(QResizeEvent *ev)
{
  QMultiLineEdit::resizeEvent(ev);
  wrapText(0);
}

void WrapEdit::quote()
{
}

void WrapEdit::setWraping(bool w)
{
  wrap = w ;
}

bool WrapEdit::isWraping()
{
  return wrap ;
}

void WrapEdit::setLimit(unsigned int l)
{
  limit = l;
}

unsigned int WrapEdit::getLimit()
{
  return limit;
}

void WrapEdit::wrapText(int r)
{
  int row, col, crow;
  int moveCursor ;

  setAutoUpdate(FALSE);
  cursorPosition(&crow,&col) ;
  needUpdate = FALSE;
  for(row = r!=-1?r:crow; row < numLines(); row++)
    while(textWidth(row) + 5 > width())
    {
      /* Let's find last word on this line */
      char buffer[512] ;
      strncpy(buffer,textLine(row),512) ;

      char *p, *lastWord ;
      p = &buffer[0] + strlen(buffer) ;
      while(*p == ' ' || *p == '\t')
        p--;
      while(*p != ' ' && *p != '\t')
        p--;

      lastWord = p + 1 ;
      *p = '\0' ;

      /* Is the cursor somewhere around lastWord ? */
      if(strlen(buffer) + strlen(lastWord) + 1 == (unsigned int)col)
        moveCursor = 1 ;
      else
        moveCursor = 0 ;

      /* Replace current line */
      removeLine(row) ;
      insertLine(buffer,row) ;

      /* add lastWord to the start of next line */
      QString next = (QString)lastWord ;
      QString prev ;

/*      fprintf(stderr,"row = %d, col = %d, buffer = %d, lastWord = %d, lines = %d\n",
              row,col,strlen(buffer),strlen(lastWord),numLines()) ;*/

      if(numLines() > row + 1)
      {
        if(numLines() > row)
          prev = textLine(row + 1) ;
        removeLine(row + 1) ;
        if(prev.length() > 0)
          next += " " ;
        next += prev ;
      }
      insertLine((const char *)next,row + 1) ;
      if(moveCursor)
        setCursorPosition(crow + 1, strlen(lastWord)) ;
      else
        setCursorPosition(crow,col) ;
      needUpdate = TRUE;
    }
  setAutoUpdate(TRUE);
  if(needUpdate)
    update();
}
