#ifndef _USERLIST_
#define _USERLIST_

#include <qlistbox.h>
#include <qlist.h>
#include "useritem.h"
#include "icqmessage.h"
#include "blinklistbox.h"

class UserList : public WBlinkListBox {
  Q_OBJECT
public:
  UserList(QWidget *parent=0, const char *name=0, WFlags f=0);
  ~UserList();
  UserItem *getItem(int);
  void setStatus(unsigned long, unsigned long);
  void addMsg(unsigned long, TimeStr, const char*);
  void addMsg(unsigned long, TimeStr, const char*, const char*);
  void updateInfoByUIN(unsigned long,const char*,const char*, const char*,const char*,char);
  void allOffline();
  void appendItem(UserItem*);
  void appendNILItem(UserItem*);
  void changeList();
  void clear();
  const char *getNickByUIN(unsigned long);
  const char *getEMailByUIN(unsigned long);
  ContactItem *getInfoByUIN(unsigned long);
  ContactItem *getContactInfoByUIN(unsigned long);
  void deleteByUIN(unsigned long);
  int isUINInContactList(unsigned long);
  UserItem *getItemByUIN(unsigned long);
  void setBlinkingByUIN(unsigned long,int) ;
  int isUINOnline(unsigned long);
  int isUINOffline(unsigned long);
  int isUINNotInList(unsigned long);
  void addToContactListByUIN(unsigned long);
  void delNotInListByUIN(unsigned long);
public slots:
signals:
protected:
  QPopupMenu *popup, *alertpopup;
  int oldCurrent;
  int doRemove ;
  int onlineID, visibleID;
  QList<UserItem> onlineList;
  QList<UserItem> offlineList;
  QList<UserItem> notInList;
  QList<UserItem> authorizeList;
  void paintCell(QPainter*, int, int);
  void mousePressEvent(QMouseEvent*);
  void addMsg(unsigned long, icqMessage*);
protected slots:
  void addRequest();
private:
private slots:
};
#endif
