// $Id: prefuser.cpp,v 1.3 1998/12/08 16:28:34 denis Exp $
// $Log: prefuser.cpp,v $
// Revision 1.3  1998/12/08 16:28:34  denis
// Cleaned up a little before releasing
//

#include "prefuser.h"

#include "prefuser.moc"

UserWidget::UserWidget(QWidget *parent) : QWidget(parent)
{
  mainlabel = new QLabel("Enter Current User Settings:",this);
  userbox = new QGroupBox("Current User Settings", this);
  uinline = new KIntegerLine(this);
  uinlabel = new QLabel(uinline, "ICQ#:", this);
  nickline = new QLineEdit(this);
  nicklabel = new QLabel(nickline, "Nick Name:", this);
  passline = new QLineEdit(this);
  passline->setEchoMode(QLineEdit::Password);
  passlabel = new QLabel(passline, "Password:", this);
}

UserWidget::~UserWidget()
{
  if(nicklabel)
    delete nicklabel;
  if(nickline)
    delete nickline;
  if(uinlabel)
    delete uinlabel;
  if(uinline)
    delete uinline;
  if(passlabel)
    delete passlabel;
  if(passline)
    delete passline;
  if(mainlabel)
    delete mainlabel;
  if(userbox)
    delete userbox;
}

void UserWidget::resizeEvent(QResizeEvent *re)
{
  QSize mainlblsize, nicklblsize, uinlblsize, passlblsize, nicklinesize, uinlinesize, passlinesize;
  QWidget::resizeEvent(re);
  mainlblsize = mainlabel->sizeHint();
  mainlabel->setGeometry(10,10,mainlblsize.width(),mainlblsize.height());
  userbox->setGeometry(7,30,width()-13,height()-37);
  uinlblsize = uinlabel->sizeHint();
  nicklblsize = nicklabel->sizeHint();
  passlblsize = passlabel->sizeHint();
  uinlinesize = uinline->sizeHint();
  nicklinesize = nickline->sizeHint();
  passlinesize = passline->sizeHint();
  int w = QMAX(QMAX(nicklblsize.width(),uinlblsize.width()),passlblsize.width());
  int h = QMAX(QMAX(QMAX(nicklblsize.height(), uinlblsize.height()), 
          QMAX(passlblsize.height(), nicklinesize.height())), 
          QMAX(uinlinesize.height(), passlinesize.height()));
  uinlabel->resize(w,h);
  nicklabel->resize(w,h);
  passlabel->resize(w,h);
  uinline->resize(width()-w-40,h);
  nickline->resize(width()-w-40,h);
  passline->resize(width()-w-40,h);
  int mh = (userbox->height()-20)/3;
  uinlabel->move(15,userbox->y()+mh/2-h/2+15);
  uinline->move(w+23,userbox->y()+mh/2-h/2+15);
  nicklabel->move(15,userbox->y()+mh+mh/2-h/2+15);
  nickline->move(w+23,userbox->y()+mh+mh/2-h/2+15);
  passlabel->move(15,userbox->y()+mh*2+mh/2-h/2+15);
  passline->move(w+23,userbox->y()+mh*2+mh/2-h/2+15);
}

void UserWidget::setInfo(unsigned long uin, const char *nick, const char *pass)
{
  uinline->setValue(uin);
  nickline->setText(nick);
  passline->setText(pass);
}

unsigned long UserWidget::uin()
{
  return uinline->value();
}

const char *UserWidget::nick()
{
  return nickline->text();
}

const char *UserWidget::pass()
{
  return passline->text();
}
