// $Id: infowindow.cpp,v 1.4 1998/12/08 16:18:46 denis Exp $
// $Log: infowindow.cpp,v $
// Revision 1.4  1998/12/08 16:18:46  denis
// Cleaned up a little before releasing
//

#include <kapp.h>
#include <qmsgbox.h>
#include <qmovie.h>
#include "infowindow.h"
#include "mainwindow.h"

#include "infowindow.moc"

InfoWindow::InfoWindow(int plocal) : QDialog()
{
  setCaption("Info");
	local = plocal;
  tabctl = new KTabCtl(this);
  mainwidget = new MainWidget(tabctl);
  addrwidget = new AddrWidget(tabctl);
  morewidget = new MoreWidget(tabctl);
  aboutwidget = new AboutWidget(tabctl);
	if(local)
    noteswidget = new NotesWidget(tabctl);
  tabctl->addTab(mainwidget,"Main");
  tabctl->addTab(addrwidget,"Address");
  tabctl->addTab(morewidget,"More");
  tabctl->addTab(aboutwidget,"About");
	if(local)
    tabctl->addTab(noteswidget,"My Notes");
  donebtn = new QPushButton("Done",this);
  connect(donebtn, SIGNAL(clicked()), SLOT(doneCommand()));
  updatebtn = new QPushButton("Update",this);
  connect(updatebtn, SIGNAL(clicked()), SLOT(updateCommand()));
  updateanim = new QLabel(this);
  QString filename = kapp->kde_datadir()+"/"+kapp->appName()+"/pics/search.gif";
  updateanim->setMovie(QMovie((const char*)filename));
  updateanim->movie()->pause();
  resize(310,210);
  setMinimumSize(310,210);
}

InfoWindow::~InfoWindow()
{
}

void InfoWindow::resizeEvent(QResizeEvent *re)
{
  QDialog::resizeEvent(re);
  int h = QMAX(donebtn->sizeHint().height(),updatebtn->sizeHint().height());
  int w = QMAX(donebtn->sizeHint().width(),updatebtn->sizeHint().width());
  tabctl->setGeometry(3,3,width()-9,height()-25-h);
  donebtn->setGeometry(width()/2-w-10,height()-h-12,w,h);
  updatebtn->setGeometry(width()/2+10,height()-h-12,w,h);
  updateanim->setGeometry(width()-40,height()-40,32,32);
  updateanim->movie()->restart();
}

void InfoWindow::closeEvent(QCloseEvent *ce)
{
  QDialog::closeEvent(ce);
	((MainWindow*)(kapp->topWidget()))->delInfoWin(this);
}

void InfoWindow::doneCommand()
{
  if(local)
	  if(info.notes != noteswidget->text())
	  {
      info.notes = noteswidget->text();
      ((MainWindow*)(kapp->topWidget()))->saveUser(info);
	  }
  hide();
	((MainWindow*)(kapp->topWidget()))->delInfoWin(this);
}

void InfoWindow::updateCommand()
{
  if(((MainWindow*)(kapp->topWidget()))->isLogged())
	{
    updateanim->movie()->unpause();
    updatebtn->setEnabled(FALSE);
    icq_SendInfoReq(info.uin);
	  icq_SendExtInfoReq(info.uin);
		upd_count=2;
	}
	else
    QMessageBox::warning(this, "Error", "You are not connected to the icq network!");
}

void InfoWindow::setMain(unsigned long puin, unsigned long pip, const char *pnick, const char *pemail, const char *pfirst, const char *plast)
{
  mainwidget->setInfo(puin, pip, pnick, pemail, pfirst, plast);
}

void InfoWindow::setAddr(const char *pcity, const char *pstate, const char *pzip, unsigned short pcountry, char pcountry_stat, const char *ptime)
{
  addrwidget->setInfo(pcity, pstate, pzip, pcountry, pcountry_stat, ptime);
}

void InfoWindow::setMore(const char *php, unsigned int page, const char *pphone, const char *pgender)
{
  morewidget->setInfo(php, page, pphone, pgender);
}

void InfoWindow::setAbout(const char *pabout)
{
  aboutwidget->setInfo(pabout);
}

void InfoWindow::setNotes(const char *pnotes)
{
  if(local)
    noteswidget->setInfo(pnotes);
}

void InfoWindow::setInfo(ContactItem item)
{
  QString stmp;
  info = item;
  setMain(info.uin, info.lastIp, info.nick, info.email, info.firstName, info.lastName);
	setAddr(info.city, info.state, info.zip, info.country, info.countryStat, "N/A");
	setMore(info.homePage, info.age, info.phone, info.gender==1?"Female":info.gender==2?"Male":"Not Entered");
	setAbout(info.about);
	if(local)
  	setNotes(info.notes);
}

unsigned long InfoWindow::UIN()
{
  return info.uin;
}

void InfoWindow::updateInfo(const char *nick, const char *first, const char *last, const char *email, char auth)
{
  info.nick = nick;
	info.firstName = first;
	info.lastName = last;
	info.email = email;
	info.auth = auth;
  setInfo(info);
  if(local)
    ((MainWindow*)(kapp->topWidget()))->saveUser(info);
	if(--upd_count==0)
	{
    if(local)
  	  ((MainWindow*)(kapp->topWidget()))->updateContact();
		stopCommand();
	}
	update();
}

void InfoWindow::stopCommand()
{
  updateanim->movie()->pause();
  updatebtn->setEnabled(TRUE);
}

void InfoWindow::updateExtInfo(const char *city, unsigned short country_code, char country_stat, const char *state, unsigned short age, char gender, const char *phone, const char *hp, const char *about)
{
  info.city = city;
	info.country = country_code;
	info.countryStat = country_stat;
	info.state = state;
	info.age = age;
	info.gender = gender;
	info.phone = phone;
	info.homePage = hp;
	info.about = about;
	setInfo(info);
  if(--upd_count==0)
	{
    if(local)
		{
      ((MainWindow*)(kapp->topWidget()))->saveUser(info);
  	  ((MainWindow*)(kapp->topWidget()))->updateContact();
		}
		stopCommand();
	}
	update();
}
