/***************************************************************************
                          helpme.cpp  -  description
                             -------------------
    begin                : Sat Dec 4 1999
    copyright            : (C) 1999 & 2000 by llornkcor
    email                : ljp@llornkcor.com
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "helpme.h"
#include <kurllabel.h>
#include <qprogressdialog.h>

HelpMe::HelpMe(QWidget *parent, const char *name ) : QDialog(parent,name)
{
	setCaption(i18n("About Kgutenbook"));
	resize(500,350);
	setMinimumSize(500,350);
	setMaximumSize(500,350);
	
  QLabel* StatusBar;
  StatusBar = new QLabel( this, "Status_Bar" );
	StatusBar->setMinimumSize( 0, 0 );
	StatusBar->setFocusPolicy( QWidget::NoFocus );
	StatusBar->setBackgroundMode( QWidget::PaletteBackground );
	StatusBar->setFontPropagation( QWidget::NoChildren );
	StatusBar->setPalettePropagation( QWidget::NoChildren );
	StatusBar->setFrameStyle( 0 );
	StatusBar->setLineWidth( 2 );
	StatusBar->setMidLineWidth( 0 );
	StatusBar->QFrame::setMargin( 0 );
	StatusBar->setText( QString(i18n("Kgutenbook Version "))+ VERSION );
	StatusBar->setMargin( -1 );
	StatusBar->setGeometry(10,10,220,20);

	Edit = new QMultiLineEdit(this);
	Edit->setGeometry(10,40,480,240);
	Edit->setReadOnly(true);
	Edit->append(i18n("Based on gutenbook.pl, available from http://www.gutenbook.org"));
	Edit->append(i18n("Much appreciation to Lee Burgess."));
	Edit->append(i18n("For the original idea and concept of gutenbook."));
	Edit->append("");
	Edit->append(i18n("A list of current Gutenberg ftp sites is at http://www.gutenberg.org"));
	Edit->append("");
	Edit->append(i18n("For bug reports or questions about Kgutenbook, email"));
	Edit->append(i18n("ljp@llornkcor.com"));
	Edit->append("");
	Edit->append(i18n("Arnold's Laws of Documentation:"));
  Edit->append(i18n("(1) If it should exist, it doesn't."));
  Edit->append(i18n("(2) If it does exist, it's out of date."));
  Edit->append(i18n("(3) Only documentation for"));
  Edit->append(i18n("useless programs transcends the"));
  Edit->append(i18n("first two laws."));
	Edit->append("");
  Edit->append(i18n("Everything is temporary, anyway....\n :o)"));

	QPushButton *help;
	help = new QPushButton(this);
	help->setGeometry(360,10,60,22);
	help->setPixmap( QPixmap(kapp->kde_toolbardir() +"/help.xpm") );
	help->setFocus();
	connect( help,SIGNAL(clicked()),this,SLOT( help()));
	
	QPushButton *ok;
	ok = new QPushButton(this);
	ok->setGeometry(430,10,60,22);
	ok->setPixmap( QPixmap(kapp->kde_toolbardir() +"/exit.xpm") );
	ok->setFocus();
	connect(ok,SIGNAL(clicked()),this,SLOT(accept()));
	
	KURLLabel *url2;
	url2 = new KURLLabel(this);
	url2->setText("Project Gutenberg");
	url2->setURL("http://www.gutenberg.org");
	url2->setGeometry(190,280,175,30);
	connect(url2,SIGNAL(leftClickedURL()),this,SLOT(goToURL2()));
	
	KURLLabel *url;
	url = new KURLLabel(this);
	url->setText("www.llornkcor.com");
	url->setURL("http://www.llornkcor.com");
	url->setGeometry(50,310,150,30);
	connect(url,SIGNAL(leftClickedURL()),this,SLOT(goToURL()));
	
	KURLLabel *url3;
	url3 = new KURLLabel(this);
	url3->setText("gutenbook web site");
	url3->setURL("http://www.gutenbook.org");
	url3->setGeometry(330,310,200,30);
	connect(url3,SIGNAL(leftClickedURL()),this,SLOT(goToURL3()));
	
}

HelpMe::~HelpMe()
{
delete Edit;

}

void HelpMe::goToURL()
{
	
	url = "http://www.llornkcor.com/";
	goGetit();
}

void HelpMe::goToURL2()
{
	url = "http://www.gutenberg.org";
	goGetit();
}

void HelpMe::goToURL3()
{
	url = "http://www.gutenbook.org";
	goGetit();
}

void HelpMe::goGetit()
{
  QString cmd;
  KConfig *config = kapp->getConfig();	
  config->setGroup( "Browser" );
  QString brow = config->readEntry("Preferred", "");

//  QString s_lookup = "http://www.m-w.com/cgi-bin/dictionary?" + clip;

  if(brow == "KFM") {
  KShellProcess proc("bash");
  proc << "kfmclient" << "openURL"	<< url;
  proc.start(KProcess::DontCare,KProcess::All);
  }

  else if (brow == "Netscape") {
  QString str = QDir::homeDirPath() + "/.netscape/lock";
  struct stat stat_p;

    if ( -1 !=  lstat (str, &stat_p)) {
    KShellProcess proc("bash");
    proc << "netscape" <<"-remote" << "'openURL(" <<url << ")'";
    proc.start(KProcess::DontCare,KProcess::All);

    } else {
    KShellProcess proc("bash");
    proc << "netscape" <<url;
    proc.start(KProcess::DontCare,KProcess::All);
    }
  }

   else if(brow =="Lynx") {
//    cmd = "lynx -source "+ s_lookup + " | cat >> ~/somefile.html";
  KShellProcess proc("bash");
  proc << "xterm" <<"-fg black" << "-bg white"<< "-e" <<"lynx" << url;
  proc.start(KProcess::DontCare,KProcess::All);
    }
}

void HelpMe::help()
{
  QString msg = kapp->kde_htmldir() + "/en/";
  msg += "kgutenbook/index.html";

  QString cmd;
  KConfig *config = kapp->getConfig();	
  config->setGroup( "Browser" );
  QString brow = config->readEntry("Preferred", "");
  QString url = "file:"+msg;

  if(brow == "KFM") {
  kapp->invokeHTMLHelp( "", "");
  }

  else if (brow == "Netscape") {
  QString str = QDir::homeDirPath() + "/.netscape/lock";
  struct stat stat_p;


    if ( -1 !=  lstat (str, &stat_p)) {
    KShellProcess proc("bash");
    proc << "netscape" <<"-remote" << "'openURL(" <<url << ")'";
    proc.start(KProcess::DontCare,KProcess::All);

    } else {
    KShellProcess proc("bash");
    proc << "netscape" <<url;
    proc.start(KProcess::DontCare,KProcess::All);
    }
  }

   else if(brow =="Lynx") {
  KShellProcess proc("bash");
  proc << "xterm" <<"-fg black" << "-bg white"<< "-e" <<"lynx" << url;
  proc.start(KProcess::DontCare,KProcess::All);
    }

}
