/* $Id: kgetoptdlg.cpp,v 1.1.1.1 1999/02/10 18:16:34 koss Exp $
   $Log: kgetoptdlg.cpp,v $
   Revision 1.1.1.1  1999/02/10 18:16:34  koss
   Imported sources

   Revision 1.4  1999/02/07 17:14:40  matt
   updated for new setting dialogs


   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

#include <qlayout.h>

#include <kapp.h>
#include <klocale.h>

#include "kgetoptdlg.h"

#include "dlgConnection.h"
#include "dlgProxy.h"
#include "dlgAutomation.h"
#include "dlgLimits.h"
#include "dlgAdvanced.h"
#include "dlgSystem.h"


KGETOptDlg::KGETOptDlg(QWidget *parent, const char *name, WFlags f)
  : QDialog(parent, name, true, f)
{
  // my name is
  setCaption(i18n("KGet Preferences"));

  QGridLayout *topGridLayout = new QGridLayout( this, 4, 7, 5 );

  topGridLayout->addRowSpacing(0,10);
  topGridLayout->addRowSpacing(3,10);

  topGridLayout->addColSpacing(0,5);
  topGridLayout->addColSpacing(6,5);

  topGridLayout->setRowStretch(0,5);
  topGridLayout->setRowStretch(1,100);
  topGridLayout->setRowStretch(2,10);
  topGridLayout->setRowStretch(3,5);
    
  topGridLayout->setColStretch(0,2);
  topGridLayout->setColStretch(1,10);
  topGridLayout->setColStretch(2,10);
  topGridLayout->setColStretch(3,5);
  topGridLayout->setColStretch(4,5);
  topGridLayout->setColStretch(5,5);
  topGridLayout->setColStretch(6,2);

  // KTabCtl
  tabDlg = new KTabCtl(this);
  topGridLayout->addMultiCellWidget( tabDlg, 1, 1, 1, 5 );
  
  conDlg = new DlgConnection(tabDlg);
  tabDlg->addTab(conDlg, i18n("Connection"));
  prxDlg = new DlgProxy(tabDlg);
  tabDlg->addTab(prxDlg, i18n("Proxy"));
  autDlg = new DlgAutomation(tabDlg);
  tabDlg->addTab(autDlg, i18n("Automation"));
  limDlg = new DlgLimits(tabDlg);
  tabDlg->addTab(limDlg, i18n("Limits"));
  advDlg = new DlgAdvanced(tabDlg);
  tabDlg->addTab(advDlg, i18n("Advanced"));
  sysDlg = new DlgSystem(tabDlg);
  tabDlg->addTab(sysDlg, i18n("System"));

  // help button
  help = new QPushButton(i18n("Help"), this);
  help->setMinimumSize( help->sizeHint() );
  topGridLayout->addWidget( help, 2, 3 );
  connect(help, SIGNAL(clicked()), SLOT(helpShow()));

  // ok button
  ok = new QPushButton(i18n("OK"), this);
  ok->setMinimumSize( ok->sizeHint() );
  ok->setDefault(TRUE);
  topGridLayout->addWidget( ok, 2, 4 );
  connect(ok, SIGNAL(clicked()), SLOT(accept()));
  
  // cancel button
  cancel = new QPushButton(i18n("Cancel"), this);
  cancel->setMinimumSize( cancel->sizeHint() );
  topGridLayout->addWidget( cancel, 2, 5 );
  connect(cancel, SIGNAL(clicked()), SLOT(reject()));

  topGridLayout->activate();
}


KGETOptDlg::~KGETOptDlg()
{
}


void KGETOptDlg::helpShow()
{
  kapp->invokeHTMLHelp(0, 0);
}

///////////////////

// forward data to DlgConnection
void KGETOptDlg::setConnectionData(QStrList *strList)
{
  conDlg->setData(strList);
}


QStrList KGETOptDlg::dataConnection() const
{
  return(conDlg->getData());
}

///////////////////

// set data in DlgProxy
void KGETOptDlg::setProxyData()
{
  prxDlg->setData();
}


void KGETOptDlg::dataProxy()
{
  prxDlg->getData();
}

///////////////////

// forward data to DlgAutomation
void KGETOptDlg::setAutomationData(QStrList *strList)
{
  autDlg->setData(strList);
}

QStrList KGETOptDlg::dataAutomation() const
{
  return(autDlg->getData());
}

///////////////////

// forward data to DlgLimits
void KGETOptDlg::setLimitsData(QStrList *strList)
{
  limDlg->setData(strList);
}

QStrList KGETOptDlg::dataLimits() const
{
  return(limDlg->getData());
}

///////////////////

// forward data to DlgAdvanced
void KGETOptDlg::setAdvancedData(QStrList *strList)
{
  advDlg->setData(strList);
}

QStrList KGETOptDlg::dataAdvanced() const
{
  return(advDlg->getData());
}

///////////////////

// forward data to DlgSystem
void KGETOptDlg::setSystemData(QStrList *strList)
{
  sysDlg->setData(strList);
}

QStrList KGETOptDlg::dataSystem() const
{
  return(sysDlg->getData());
}

void KGETOptDlg::setFontData(QFont font)
{
  sysDlg->setFontData(font);
}

QFont KGETOptDlg::dataFont() const
{
  return(sysDlg->getFontData());
}

///////////////////
